/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import android.os.Handler;
import android.os.Looper;
import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import javax.annotation.Nonnull;

public final class ApolloCallback<T>
extends ApolloCall.Callback<T> {
    final ApolloCall.Callback<T> delegate;
    private final Handler handler;

    public static <T> ApolloCallback<T> wrap(@Nonnull ApolloCall.Callback<T> callback, @Nonnull Handler handler) {
        return new ApolloCallback<T>(callback, handler);
    }

    public ApolloCallback(@Nonnull ApolloCall.Callback<T> callback, @Nonnull Handler handler) {
        this.delegate = (ApolloCall.Callback)Utils.checkNotNull(callback, (Object)"callback == null");
        this.handler = (Handler)Utils.checkNotNull((Object)handler, (Object)"handler == null");
    }

    public void onResponse(final @Nonnull Response<T> response) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ApolloCallback.this.delegate.onResponse(response);
            }
        });
    }

    public void onStatusEvent(final @Nonnull ApolloCall.StatusEvent event) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ApolloCallback.this.delegate.onStatusEvent(event);
            }
        });
    }

    public void onFailure(final @Nonnull ApolloException e) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ApolloCallback.this.delegate.onFailure(e);
            }
        });
    }

    public void onHttpError(final @Nonnull ApolloHttpException e) {
        if (Looper.getMainLooper() == this.handler.getLooper()) {
            this.delegate.onHttpError(e);
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ApolloCallback.this.delegate.onHttpError(e);
                }
            });
        }
    }

    public void onNetworkError(final @Nonnull ApolloNetworkException e) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ApolloCallback.this.delegate.onNetworkError(e);
            }
        });
    }

    public void onParseError(final @Nonnull ApolloParseException e) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                ApolloCallback.this.delegate.onParseError(e);
            }
        });
    }
}

