/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class Present<T>
extends Optional<T> {
    private final T reference;
    private static final long serialVersionUID = 0L;

    Present(T reference) {
        this.reference = reference;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public T get() {
        return this.reference;
    }

    @Override
    public T or(T defaultValue) {
        Utils.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
        return this.reference;
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        Utils.checkNotNull(secondChoice);
        return this;
    }

    @Override
    public <V> Optional<V> transform(Function<? super T, V> function) {
        return new Present<V>(Utils.checkNotNull(function.apply(this.reference), "the Function passed to Optional.transform() must not return null."));
    }

    @Override
    public <V> Optional<V> map(Function<? super T, V> function) {
        return new Present<V>(Utils.checkNotNull(function.apply(this.reference), "the Function passed to Optional.map() must not return null."));
    }

    @Override
    public <V> Optional<V> flatMap(Function<? super T, Optional<V>> function) {
        Utils.checkNotNull(function);
        return Utils.checkNotNull(function.apply(this.reference), "the Function passed to Optional.flatMap() must not return null.");
    }

    @Override
    public Optional<T> apply(final Action<T> action) {
        Utils.checkNotNull(action);
        return this.map(new Function<T, T>(){

            @Override
            @Nonnull
            public T apply(@Nonnull T t) {
                action.apply(t);
                return t;
            }
        });
    }

    @Override
    public T orNull() {
        return this.reference;
    }

    @Override
    public Set<T> asSet() {
        return Collections.singleton(this.reference);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Present) {
            Present other = (Present)object;
            return this.reference.equals(other.reference);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 1502476572 + this.reference.hashCode();
    }

    @Override
    public String toString() {
        return "Optional.of(" + this.reference + ")";
    }
}

