/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Response<T> {
    private final Operation operation;
    private final T data;
    private final List<Error> errors;
    private Set<String> dependentKeys;
    private final boolean fromCache;
    private final Map<String, Object> extensions;

    public static <T> Builder<T> builder(@NotNull Operation operation) {
        return new Builder(operation);
    }

    Response(Builder<T> builder) {
        this.operation = Utils.checkNotNull(builder.operation, "operation == null");
        this.data = builder.data;
        this.errors = builder.errors != null ? Collections.unmodifiableList(builder.errors) : Collections.emptyList();
        this.dependentKeys = builder.dependentKeys != null ? Collections.unmodifiableSet(builder.dependentKeys) : Collections.emptySet();
        this.fromCache = builder.fromCache;
        this.extensions = builder.extensions;
    }

    public Operation operation() {
        return this.operation;
    }

    @Nullable
    public T data() {
        return this.data;
    }

    @NotNull
    public List<Error> errors() {
        return this.errors;
    }

    @NotNull
    public Set<String> dependentKeys() {
        return this.dependentKeys;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean fromCache() {
        return this.fromCache;
    }

    @Nullable
    public Map<String, Object> extensions() {
        return this.extensions;
    }

    public Builder<T> toBuilder() {
        return new Builder<T>(this.operation).data(this.data).errors(this.errors).dependentKeys(this.dependentKeys).fromCache(this.fromCache).extensions(this.extensions);
    }

    public static final class Builder<T> {
        final Operation operation;
        T data;
        List<Error> errors;
        Set<String> dependentKeys;
        boolean fromCache;
        Map<String, Object> extensions;

        Builder(@NotNull Operation operation) {
            this.operation = Utils.checkNotNull(operation, "operation == null");
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(@Nullable List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder<T> dependentKeys(@Nullable Set<String> dependentKeys) {
            this.dependentKeys = dependentKeys;
            return this;
        }

        public Builder<T> fromCache(boolean fromCache) {
            this.fromCache = fromCache;
            return this;
        }

        public Builder<T> extensions(Map<String, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Response<T> build() {
            return new Response(this);
        }
    }
}

