/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.Logger;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloLogger {
    private final Optional<Logger> logger;

    public ApolloLogger(@NotNull Optional<Logger> logger) {
        this.logger = Utils.checkNotNull(logger, "logger == null");
    }

    public Optional<Logger> getLogger() {
        return this.logger;
    }

    public void d(@NotNull String message, Object ... args) {
        this.log(3, message, null, args);
    }

    public void d(@Nullable Throwable t, @NotNull String message, Object ... args) {
        this.log(3, message, t, args);
    }

    public void w(@NotNull String message, Object ... args) {
        this.log(5, message, null, args);
    }

    public void w(@Nullable Throwable t, @NotNull String message, Object ... args) {
        this.log(5, message, t, args);
    }

    public void e(@NotNull String message, Object ... args) {
        this.log(6, message, null, args);
    }

    public void e(@Nullable Throwable t, @NotNull String message, Object ... args) {
        this.log(6, message, t, args);
    }

    private void log(int priority, @NotNull String message, @Nullable Throwable t, Object ... args) {
        if (this.logger.isPresent()) {
            this.logger.get().log(priority, message, Optional.fromNullable(t), args);
        }
    }
}

