/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast.internal;

import com.apollographql.apollo.ast.internal.LexerException;
import com.apollographql.apollo.ast.internal.LexerKt;
import com.apollographql.apollo.ast.internal.Token;
import com.apollographql.apollo.ast.internal.UnicodeKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\tH\u0002J\f\u0010\u0016\u001a\u00020\u000e*\u00020\tH\u0002J\f\u0010\u0017\u001a\u00020\u000e*\u00020\tH\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\f\u0010\u001a\u001a\u00020\t*\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\f\u0010\u001f\u001a\u00020\u000e*\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0014H\u0002J\f\u0010)\u001a\u00020\u000e*\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/apollographql/apollo/ast/internal/Lexer;", "", "src", "", "<init>", "(Ljava/lang/String;)V", "getSrc", "()Ljava/lang/String;", "pos", "", "len", "line", "lineStart", "started", "", "discardComment", "", "isNameStart", "", "nextToken", "Lcom/apollographql/apollo/ast/internal/Token;", "readUnicodeEscape", "isLeadingSurrogate", "isTrailingSurrogate", "isUnicodeScalar", "readVariableUnicodeEscape", "decodeHex", "readFixedUnicodeEscape", "readEscapeCharacter", "readString", "readBlockString", "isDigit", "STATE_NEGATIVE_SIGN", "STATE_ZERO", "STATE_DOT_EXP", "STATE_INTEGER_DIGIT", "STATE_FRACTIONAL_DIGIT", "STATE_SIGN", "STATE_EXP_DIGIT", "STATE_EXP", "readNumber", "isNameContinue", "readName", "column", "apollo-ast"})
public final class Lexer {
    @NotNull
    private final String src;
    private int pos;
    private final int len;
    private int line;
    private int lineStart;
    private boolean started;
    private final int STATE_NEGATIVE_SIGN;
    private final int STATE_ZERO;
    private final int STATE_DOT_EXP;
    private final int STATE_INTEGER_DIGIT;
    private final int STATE_FRACTIONAL_DIGIT;
    private final int STATE_SIGN;
    private final int STATE_EXP_DIGIT;
    private final int STATE_EXP;

    public Lexer(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        this.src = src;
        this.len = this.src.length();
        this.line = 1;
        this.STATE_NEGATIVE_SIGN = 1;
        this.STATE_ZERO = 2;
        this.STATE_DOT_EXP = 3;
        this.STATE_INTEGER_DIGIT = 4;
        this.STATE_FRACTIONAL_DIGIT = 5;
        this.STATE_SIGN = 6;
        this.STATE_EXP_DIGIT = 7;
        this.STATE_EXP = 8;
    }

    @NotNull
    public final String getSrc() {
        return this.src;
    }

    private final void discardComment() {
        block4: while (true) {
            if (this.pos == this.len) {
                return;
            }
            int n = this.pos;
            this.pos = n + 1;
            char c = this.src.charAt(n);
            switch (c) {
                case '\n': {
                    int n2 = this.line;
                    this.line = n2 + 1;
                    this.lineStart = this.pos;
                    break block4;
                }
                case '\r': {
                    int n3;
                    if (this.pos < this.len && this.src.charAt(this.pos) == '\n') {
                        n3 = this.pos;
                        this.pos = n3 + 1;
                    }
                    n3 = this.line;
                    this.line = n3 + 1;
                    this.lineStart = this.pos;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNameStart(char $this$isNameStart) {
        boolean bl;
        char c = $this$isNameStart;
        if (c == '_') return true;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('a' > c) return false;
        if (c >= '{') return false;
        return true;
    }

    @NotNull
    public final Token nextToken() {
        if (!this.started) {
            this.started = true;
            return Token.StartOfFile.INSTANCE;
        }
        block22: while (this.pos < this.len) {
            char c = this.src.charAt(this.pos);
            if (this.isNameStart(c)) {
                return this.readName();
            }
            if (this.isDigit(c) || c == '-') {
                return this.readNumber();
            }
            int start = this.pos;
            int n = this.pos;
            this.pos = n + 1;
            switch (c) {
                case '\t': 
                case ' ': 
                case ',': 
                case '\ufeff': {
                    continue block22;
                }
                case '\n': {
                    int n2 = this.line;
                    this.line = n2 + 1;
                    this.lineStart = this.pos;
                    continue block22;
                }
                case '\r': {
                    int n2;
                    if (this.pos < this.len && this.src.charAt(this.pos) == '\n') {
                        n2 = this.pos;
                        this.pos = n2 + 1;
                    }
                    n2 = this.line;
                    this.line = n2 + 1;
                    this.lineStart = this.pos;
                    continue block22;
                }
                case '#': {
                    this.discardComment();
                    continue block22;
                }
                case '!': {
                    return new Token.ExclamationPoint(start, this.line, this.column(start));
                }
                case '?': {
                    return new Token.QuestionMark(start, this.line, this.column(start));
                }
                case '$': {
                    return new Token.Dollar(start, this.line, this.column(start));
                }
                case '&': {
                    return new Token.Ampersand(start, this.line, this.column(start));
                }
                case '(': {
                    return new Token.LeftParenthesis(start, this.line, this.column(start));
                }
                case ')': {
                    return new Token.RightParenthesis(start, this.line, this.column(start));
                }
                case '.': {
                    if (this.pos + 1 < this.len && this.src.charAt(this.pos) == '.' && this.src.charAt(this.pos + 1) == '.') {
                        this.pos += 2;
                        return new Token.Spread(start, this.line, this.column(start));
                    }
                    throw new LexerException("Unterminated spread operator", start, this.line, this.column(start), null);
                }
                case ':': {
                    return new Token.Colon(start, this.line, this.column(start));
                }
                case '=': {
                    return new Token.Equals(start, this.line, this.column(start));
                }
                case '@': {
                    return new Token.At(start, this.line, this.column(start));
                }
                case '[': {
                    return new Token.LeftBracket(start, this.line, this.column(start));
                }
                case ']': {
                    return new Token.RightBracket(start, this.line, this.column(start));
                }
                case '{': {
                    return new Token.LeftBrace(start, this.line, this.column(start));
                }
                case '}': {
                    return new Token.RightBrace(start, this.line, this.column(start));
                }
                case '|': {
                    return new Token.Pipe(start, this.line, this.column(start));
                }
                case '\"': {
                    Token token;
                    if (this.pos + 1 < this.len && this.src.charAt(this.pos) == '\"' && this.src.charAt(this.pos + 1) == '\"') {
                        this.pos += 2;
                        token = this.readBlockString();
                    } else {
                        token = this.readString();
                    }
                    return token;
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected symbol '").append(c).append("' (0x");
            String string = Integer.toString(c, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new LexerException(stringBuilder.append(string).append(')').toString(), start, this.line, this.column(start), null);
        }
        return new Token.EndOfFile(this.pos, this.line, this.column(this.pos));
    }

    private final int readUnicodeEscape() {
        if (this.pos == this.len) {
            throw new LexerException("Unterminated Unicode escape", this.pos, this.line, this.column(this.pos), null);
        }
        if (this.src.charAt(this.pos) == '{') {
            int n = this.pos;
            this.pos = n + 1;
            return this.readVariableUnicodeEscape();
        }
        int c1 = this.readFixedUnicodeEscape();
        if (this.isUnicodeScalar(c1)) {
            return c1;
        }
        int start = this.pos - 6;
        if (this.isLeadingSurrogate(c1) && this.pos + 1 < this.len && this.src.charAt(this.pos) == '\\' && this.src.charAt(this.pos + 1) == 'u') {
            this.pos += 2;
            int c2 = this.readFixedUnicodeEscape();
            if (this.isTrailingSurrogate(c2)) {
                return UnicodeKt.codePoint(c1, c2);
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
        String string = this.src.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
    }

    private final boolean isLeadingSurrogate(int $this$isLeadingSurrogate) {
        return 55296 <= $this$isLeadingSurrogate ? $this$isLeadingSurrogate < 56320 : false;
    }

    private final boolean isTrailingSurrogate(int $this$isTrailingSurrogate) {
        return 56320 <= $this$isTrailingSurrogate ? $this$isTrailingSurrogate < 57344 : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnicodeScalar(int $this$isUnicodeScalar) {
        boolean bl;
        if (0 <= $this$isUnicodeScalar) {
            if ($this$isUnicodeScalar < 55296) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (57344 > $this$isUnicodeScalar) return false;
        if ($this$isUnicodeScalar >= 0x110000) return false;
        return true;
    }

    private final int readVariableUnicodeEscape() {
        int i;
        int result = 0;
        for (i = 0; i < 9; ++i) {
            if (this.pos == this.len) {
                throw new LexerException("Unterminated Unicode escape", this.pos, this.line, this.column(this.pos), null);
            }
            int n = this.pos;
            this.pos = n + 1;
            char c = this.src.charAt(n);
            if (c == '}') {
                int start;
                if (i == 0) {
                    start = this.pos - i - 4;
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
                    String string = this.src.substring(start, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
                }
                if (!this.isUnicodeScalar(result)) {
                    start = this.pos - i - 4;
                    StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
                    String string = this.src.substring(start, this.pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
                }
                return result;
            }
            int h = this.decodeHex(c);
            if (h == -1) {
                int start = this.pos - i - 4;
                StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
                String string = this.src.substring(start, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
            }
            result = result << 4 | h;
        }
        int start = this.pos - i - 3;
        StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
        String string = this.src.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
    }

    private final int decodeHex(char $this$decodeHex) {
        int n;
        block1: {
            char c;
            block0: {
                c = $this$decodeHex;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = $this$decodeHex - 48;
                break block1;
            }
            n = ('A' <= c ? c < 'G' : false) ? $this$decodeHex - 55 : (('a' <= c ? c < 'g' : false) ? $this$decodeHex - 87 : -1);
        }
        return n;
    }

    private final int readFixedUnicodeEscape() {
        if (this.pos + 4 >= this.len) {
            throw new LexerException("Unterminated Unicode escape", this.pos, this.line, this.column(this.pos), null);
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.pos;
            this.pos = n + 1;
            int h = this.decodeHex(this.src.charAt(n));
            if (h == -1) {
                int start = this.pos - i - 3;
                StringBuilder stringBuilder = new StringBuilder().append("Invalid Unicode escape '");
                String string = this.src.substring(start, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                throw new LexerException(stringBuilder.append(string).append('\'').toString(), start, this.line, this.column(start), null);
            }
            result = result << 4 | h;
        }
        return result;
    }

    private final int readEscapeCharacter() {
        int n;
        if (this.pos == this.len) {
            throw new LexerException("Unterminated escape", this.pos, this.line, this.column(this.pos), null);
        }
        int n2 = this.pos;
        this.pos = n2 + 1;
        char c = this.src.charAt(n2);
        switch (c) {
            case '\"': {
                n = 34;
                break;
            }
            case '\\': {
                n = 92;
                break;
            }
            case '/': {
                n = 47;
                break;
            }
            case 'b': {
                n = 8;
                break;
            }
            case 'f': {
                n = 12;
                break;
            }
            case 'n': {
                n = 10;
                break;
            }
            case 'r': {
                n = 13;
                break;
            }
            case 't': {
                n = 9;
                break;
            }
            case 'u': {
                n = this.readUnicodeEscape();
                break;
            }
            default: {
                throw new LexerException("Invalid escape character '\\" + c + '\'', this.pos - 2, this.line, this.column(this.pos - 2), null);
            }
        }
        return n;
    }

    private final Token readString() {
        StringBuilder builder = new StringBuilder();
        int start = this.pos - 1;
        block5: while (true) {
            if (this.pos == this.len) {
                throw new LexerException("Unterminated string", this.pos, this.line, this.column(this.pos), null);
            }
            int n = this.pos;
            this.pos = n + 1;
            char c = this.src.charAt(n);
            switch (c) {
                case '\\': {
                    UnicodeKt.appendCodePointMpp(builder, this.readEscapeCharacter());
                    continue block5;
                }
                case '\"': {
                    int n2 = this.column(start);
                    String string = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    return new Token.String(start, this.pos, this.line, n2, string);
                }
                case '\n': 
                case '\r': {
                    throw new LexerException("Unterminated string", this.pos - 1, this.line, this.column(this.pos - 1), null);
                }
            }
            builder.append(c);
        }
    }

    private final Token readBlockString() {
        int start = this.pos - 3;
        int startLine = this.line;
        int startColumn = this.column(start);
        List blockLines = new ArrayList();
        StringBuilder currentLine = new StringBuilder();
        while (true) {
            if (this.pos == this.len) {
                throw new LexerException("Unterminated block string", this.pos, this.line, this.column(this.pos), null);
            }
            int n = this.pos;
            this.pos = n + 1;
            char c = this.src.charAt(n);
            switch (c) {
                case '\n': {
                    int n2 = this.line;
                    this.line = n2 + 1;
                    this.lineStart = this.pos;
                    String string = currentLine.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    blockLines.add(string);
                    StringBuilder stringBuilder = StringsKt.clear((StringBuilder)currentLine);
                    break;
                }
                case '\r': {
                    int n2;
                    if (this.pos + 1 < this.len && this.src.charAt(this.pos) == '\n') {
                        n2 = this.pos;
                        this.pos = n2 + 1;
                    }
                    n2 = this.line;
                    this.line = n2 + 1;
                    this.lineStart = this.pos;
                    String string = currentLine.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    blockLines.add(string);
                    StringBuilder stringBuilder = StringsKt.clear((StringBuilder)currentLine);
                    break;
                }
                case '\\': {
                    StringBuilder stringBuilder;
                    if (this.pos + 2 < this.len && this.src.charAt(this.pos) == '\"' && this.src.charAt(this.pos + 1) == '\"' && this.src.charAt(this.pos + 2) == '\"') {
                        this.pos += 3;
                        stringBuilder = currentLine.append("\"\"\"");
                        break;
                    }
                    stringBuilder = currentLine.append(c);
                    break;
                }
                case '\"': {
                    if (this.pos + 1 < this.len && this.src.charAt(this.pos) == '\"' && this.src.charAt(this.pos + 1) == '\"') {
                        this.pos += 2;
                        String string = currentLine.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        blockLines.add(string);
                        return new Token.String(start, this.pos, startLine, startColumn, CollectionsKt.joinToString$default((Iterable)LexerKt.dedentBlockStringLines(blockLines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    }
                    StringBuilder stringBuilder = currentLine.append(c);
                    break;
                }
                default: {
                    StringBuilder stringBuilder = currentLine.append(c);
                }
            }
        }
    }

    private final boolean isDigit(char $this$isDigit) {
        char c = $this$isDigit;
        return '0' <= c ? c < ':' : false;
    }

    private final Token readNumber() {
        int start = this.pos;
        boolean isFloat = false;
        int state = this.STATE_NEGATIVE_SIGN;
        block6: while (this.pos < this.len) {
            int n2;
            char n;
            int n3;
            int n4 = state;
            if (n4 == this.STATE_NEGATIVE_SIGN) {
                if (this.src.charAt(this.pos) == '-') {
                    n3 = this.pos;
                    this.pos = n3 + 1;
                    state = this.STATE_ZERO;
                    continue;
                }
                state = this.STATE_ZERO;
                continue;
            }
            if (n4 == this.STATE_ZERO) {
                n = this.src.charAt(this.pos);
                if (n == '0') {
                    n3 = this.pos;
                    this.pos = n3 + 1;
                    state = this.STATE_DOT_EXP;
                    if (this.pos == this.len) break;
                    n = this.src.charAt(this.pos);
                    if (this.pos >= this.len || !this.isDigit(n)) continue;
                    throw new LexerException("Invalid number, unexpected digit after 0: '" + n + '\'', this.pos, this.line, this.column(this.pos), null);
                }
                if (this.isDigit(n)) {
                    n3 = this.pos;
                    this.pos = n3 + 1;
                    state = this.STATE_INTEGER_DIGIT;
                    continue;
                }
                throw new LexerException("Invalid number, expected digit but got '" + n + '\'', this.pos, this.line, this.column(this.pos), null);
            }
            if (n4 == this.STATE_INTEGER_DIGIT) {
                if (this.isDigit(this.src.charAt(this.pos))) {
                    n = this.pos;
                    this.pos = n + 1;
                    continue;
                }
                state = this.STATE_DOT_EXP;
                continue;
            }
            if (n4 == this.STATE_DOT_EXP) {
                if (this.src.charAt(this.pos) == '.') {
                    isFloat = true;
                    n3 = this.pos;
                    this.pos = n3 + 1;
                    if (this.pos == this.len) {
                        throw new LexerException("Unterminated number", start, this.line, this.column(start), null);
                    }
                    char c2 = this.src.charAt(this.pos);
                    if (!this.isDigit(c2)) {
                        throw new LexerException("Invalid number, expected digit but got '" + c2 + '\'', this.pos, this.line, this.column(this.pos), null);
                    }
                    n2 = this.pos;
                    this.pos = n2 + 1;
                    state = this.STATE_FRACTIONAL_DIGIT;
                    continue;
                }
                state = this.STATE_EXP;
                continue;
            }
            if (n4 == this.STATE_EXP) {
                switch (this.src.charAt(this.pos)) {
                    case 'E': 
                    case 'e': {
                        isFloat = true;
                        n3 = this.pos;
                        this.pos = n3 + 1;
                        if (this.pos == this.len) {
                            throw new LexerException("Unterminated number", start, this.line, this.column(start), null);
                        }
                        state = this.STATE_SIGN;
                        continue block6;
                    }
                }
                break;
            }
            if (n4 == this.STATE_SIGN) {
                n = this.src.charAt(this.pos);
                switch (n) {
                    case '+': 
                    case '-': {
                        n2 = this.pos;
                        this.pos = n2 + 1;
                        if (this.pos == this.len) {
                            throw new LexerException("Unterminated number", start, this.line, this.column(start), null);
                        }
                        n = this.src.charAt(this.pos);
                        if (!this.isDigit(n)) {
                            throw new LexerException("Invalid number, expected digit but got '" + n + '\'', this.pos, this.line, this.column(this.pos), null);
                        }
                        n2 = this.pos;
                        this.pos = n2 + 1;
                        state = this.STATE_EXP_DIGIT;
                        continue block6;
                    }
                }
                if (!this.isDigit(n)) {
                    throw new LexerException("Invalid number, expected digit but got '" + n + '\'', this.pos, this.line, this.column(this.pos), null);
                }
                n2 = this.pos;
                this.pos = n2 + 1;
                state = this.STATE_EXP_DIGIT;
                continue;
            }
            if (n4 == this.STATE_EXP_DIGIT) {
                if (!this.isDigit(this.src.charAt(this.pos))) break;
                n = this.pos;
                this.pos = n + 1;
                continue;
            }
            if (n4 != this.STATE_FRACTIONAL_DIGIT) continue;
            if (this.isDigit(this.src.charAt(this.pos))) {
                n = this.pos;
                this.pos = n + '\u0001';
                continue;
            }
            state = this.STATE_EXP;
        }
        if (this.pos < this.len && (this.src.charAt(this.pos) == '.' || this.isNameStart(this.src.charAt(this.pos)))) {
            throw new LexerException("Invalid number, expected digit but got '" + this.src.charAt(this.pos) + '\'', this.pos, this.line, this.column(this.pos), null);
        }
        String string = this.src.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String asString = string;
        return isFloat ? (Token)new Token.Float(start, this.pos, this.line, this.column(start), asString) : (Token)new Token.Int(start, this.pos, this.line, this.column(start), asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNameContinue(char $this$isNameContinue) {
        boolean bl;
        boolean bl2;
        char c = $this$isNameContinue;
        if (c == '_') return true;
        if ('0' <= c) {
            if (c < ':') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('a' > c) return false;
        if (c >= '{') return false;
        return true;
    }

    private final Token readName() {
        char c;
        int start = this.pos;
        int n = this.pos;
        this.pos = n + 1;
        while (this.pos < this.len && this.isNameContinue(c = this.src.charAt(this.pos))) {
            int n2 = this.pos;
            this.pos = n2 + 1;
        }
        int n3 = this.column(start);
        String string = this.src.substring(start, this.pos);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new Token.Name(start, this.pos, this.line, n3, string);
    }

    private final int column(int pos) {
        return pos - this.lineStart + 1;
    }
}

