/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.InflectorKt;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.OperationTypeSpecBuilder;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.CodeGenerationIR;
import com.apollographql.apollo.compiler.ir.Fragment;
import com.apollographql.apollo.compiler.ir.Operation;
import com.apollographql.apollo.compiler.ir.ScalarType;
import com.apollographql.apollo.compiler.ir.TypeDeclaration;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J2\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J&\u0010\u0014\u001a\u00020\n*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler;", "", "()V", "irAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationIR;", "kotlin.jvm.PlatformType", "moshi", "Lcom/squareup/moshi/Moshi;", "write", "", "args", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$Arguments;", "supportedTypeDeclarations", "", "Lcom/apollographql/apollo/compiler/ir/TypeDeclaration;", "supportedTypeMap", "", "", "typeDeclarations", "writeJavaFiles", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "outputDir", "Ljava/io/File;", "outputPackageName", "Arguments", "Companion", "apollo-compiler_main"})
public final class GraphQLCompiler {
    private final Moshi moshi = new Moshi.Builder().build();
    private final JsonAdapter<CodeGenerationIR> irAdapter = this.moshi.adapter(CodeGenerationIR.class);
    @NotNull
    public static final String FILE_EXTENSION = "graphql";
    @NotNull
    private static final List<String> OUTPUT_DIRECTORY;
    @NotNull
    public static final String APOLLOCODEGEN_VERSION = "0.17.0-alpha.13";
    public static final Companion Companion;

    public final void write(@NotNull Arguments args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object object = this.irAdapter.fromJson(FilesKt.readText$default((File)args.getIrFile(), null, (int)1, null));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        CodeGenerationIR ir = (CodeGenerationIR)object;
        String string = args.getOutputPackageName();
        if (string == null) {
            string = InflectorKt.formatPackageName(args.getIrFile().getAbsolutePath());
        }
        String irPackageName = string;
        CharSequence charSequence = irPackageName;
        String fragmentsPackage = charSequence.length() > 0 ? irPackageName + ".fragment" : "fragment";
        CharSequence charSequence2 = irPackageName;
        String typesPackage = charSequence2.length() > 0 ? irPackageName + ".type" : "type";
        Map<String, String> customTypeMap = this.supportedTypeMap(args.getCustomTypeMap(), ir.getTypesUsed());
        List list = CollectionsKt.emptyList();
        List<TypeDeclaration> list2 = ir.getTypesUsed();
        NullableValueType nullableValueType = args.getNullableValueType();
        boolean bl = args.getGenerateAccessors();
        CodeGenerationIR codeGenerationIR = ir;
        Intrinsics.checkExpressionValueIsNotNull((Object)codeGenerationIR, (String)"ir");
        CodeGenerationContext context = new CodeGenerationContext(list, list2, fragmentsPackage, typesPackage, customTypeMap, nullableValueType, bl, codeGenerationIR, args.getUseSemanticNaming(), args.getGenerateModelBuilder());
        this.writeJavaFiles(ir, context, args.getOutputDir(), args.getOutputPackageName());
    }

    /*
     * WARNING - void declaration
     */
    private final void writeJavaFiles(@NotNull CodeGenerationIR $receiver, CodeGenerationContext context, File outputDir, String outputPackageName) {
        void $receiver$iv$iv;
        TypeSpec typeSpec;
        Object it;
        Object element$iv;
        Map<String, String> $receiver$iv = $receiver.getFragments();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (Fragment)element$iv;
            typeSpec = ((Fragment)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, false, false, 1023, null));
            JavaFile.builder((String)context.getFragmentsPackage(), (TypeSpec)typeSpec).build().writeTo(outputDir);
        }
        $receiver$iv = this.supportedTypeDeclarations($receiver.getTypesUsed());
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (TypeDeclaration)element$iv;
            typeSpec = ((TypeDeclaration)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, false, false, 1023, null));
            JavaFile.builder((String)context.getTypesPackage(), (TypeSpec)typeSpec).build().writeTo(outputDir);
        }
        $receiver$iv = context.getCustomTypeMap();
        if (!$receiver$iv.isEmpty()) {
            TypeSpec typeSpec2 = new CustomEnumTypeSpecBuilder(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, false, false, 1023, null)).build();
            JavaFile.builder((String)context.getTypesPackage(), (TypeSpec)typeSpec2).build().writeTo(outputDir);
        }
        $receiver$iv = $receiver.getOperations();
        iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$receiver$iv), (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            Operation $i$a$2$forEach = (Operation)item$iv$iv;
            Collection collection = destination$iv$iv;
            OperationTypeSpecBuilder operationTypeSpecBuilder = new OperationTypeSpecBuilder((Operation)it2, $receiver.getFragments(), context.getUseSemanticNaming());
            collection.add(operationTypeSpecBuilder);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (OperationTypeSpecBuilder)element$iv;
            String string = outputPackageName;
            if (string == null) {
                string = InflectorKt.formatPackageName(((OperationTypeSpecBuilder)it).getOperation().getFilePath());
            }
            String packageName = string;
            TypeSpec typeSpec3 = ((OperationTypeSpecBuilder)it).toTypeSpec(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, null, false, false, 1023, null));
            JavaFile.builder((String)packageName, (TypeSpec)typeSpec3).build().writeTo(outputDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeDeclaration> supportedTypeDeclarations(@NotNull List<TypeDeclaration> $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_ENUM()) || Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_INPUT_OBJECT_TYPE()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> supportedTypeMap(@NotNull Map<String, String> $receiver, List<TypeDeclaration> typeDeclarations) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        String string = ScalarType.ID.INSTANCE.getName();
        String string2 = $receiver.get(ScalarType.ID.INSTANCE.getName());
        if (string2 == null) {
            String string3 = ClassNames.INSTANCE.getSTRING().toString();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ClassNames.STRING.toString()");
        }
        Pair idScalarTypeMap = TuplesKt.to((Object)string, (Object)string2);
        Iterable iterable = $receiver$iv = (Iterable)typeDeclarations;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)TypeDeclaration.Companion.getKIND_SCALAR_TYPE())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv2;
            TypeDeclaration it = (TypeDeclaration)element$iv$iv;
            String string4 = it.getName();
            String string5 = $receiver.get(it.getName());
            if (string5 == null) {
                String string6 = ClassNames.INSTANCE.getOBJECT().toString();
                string5 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"ClassNames.OBJECT.toString()");
            }
            Pair pair = TuplesKt.to((Object)string4, (Object)string5);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.plus((Map)destination$iv$iv2, (Pair)idScalarTypeMap);
    }

    static {
        Companion = new Companion(null);
        OUTPUT_DIRECTORY = CollectionsKt.listOf((Object[])new String[]{"generated", "source", "apollo"});
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003Jg\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0007H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Arguments;", "", "irFile", "Ljava/io/File;", "outputDir", "customTypeMap", "", "", "nullableValueType", "Lcom/apollographql/apollo/compiler/NullableValueType;", "generateAccessors", "", "useSemanticNaming", "generateModelBuilder", "outputPackageName", "(Ljava/io/File;Ljava/io/File;Ljava/util/Map;Lcom/apollographql/apollo/compiler/NullableValueType;ZZZLjava/lang/String;)V", "getCustomTypeMap", "()Ljava/util/Map;", "getGenerateAccessors", "()Z", "getGenerateModelBuilder", "getIrFile", "()Ljava/io/File;", "getNullableValueType", "()Lcom/apollographql/apollo/compiler/NullableValueType;", "getOutputDir", "getOutputPackageName", "()Ljava/lang/String;", "getUseSemanticNaming", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler_main"})
    public static final class Arguments {
        @NotNull
        private final File irFile;
        @NotNull
        private final File outputDir;
        @NotNull
        private final Map<String, String> customTypeMap;
        @NotNull
        private final NullableValueType nullableValueType;
        private final boolean generateAccessors;
        private final boolean useSemanticNaming;
        private final boolean generateModelBuilder;
        @Nullable
        private final String outputPackageName;

        @NotNull
        public final File getIrFile() {
            return this.irFile;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        @NotNull
        public final Map<String, String> getCustomTypeMap() {
            return this.customTypeMap;
        }

        @NotNull
        public final NullableValueType getNullableValueType() {
            return this.nullableValueType;
        }

        public final boolean getGenerateAccessors() {
            return this.generateAccessors;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getGenerateModelBuilder() {
            return this.generateModelBuilder;
        }

        @Nullable
        public final String getOutputPackageName() {
            return this.outputPackageName;
        }

        public Arguments(@NotNull File irFile, @NotNull File outputDir, @NotNull Map<String, String> customTypeMap, @NotNull NullableValueType nullableValueType, boolean generateAccessors, boolean useSemanticNaming, boolean generateModelBuilder, @Nullable String outputPackageName) {
            Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            this.irFile = irFile;
            this.outputDir = outputDir;
            this.customTypeMap = customTypeMap;
            this.nullableValueType = nullableValueType;
            this.generateAccessors = generateAccessors;
            this.useSemanticNaming = useSemanticNaming;
            this.generateModelBuilder = generateModelBuilder;
            this.outputPackageName = outputPackageName;
        }

        @NotNull
        public final File component1() {
            return this.irFile;
        }

        @NotNull
        public final File component2() {
            return this.outputDir;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.customTypeMap;
        }

        @NotNull
        public final NullableValueType component4() {
            return this.nullableValueType;
        }

        public final boolean component5() {
            return this.generateAccessors;
        }

        public final boolean component6() {
            return this.useSemanticNaming;
        }

        public final boolean component7() {
            return this.generateModelBuilder;
        }

        @Nullable
        public final String component8() {
            return this.outputPackageName;
        }

        @NotNull
        public final Arguments copy(@NotNull File irFile, @NotNull File outputDir, @NotNull Map<String, String> customTypeMap, @NotNull NullableValueType nullableValueType, boolean generateAccessors, boolean useSemanticNaming, boolean generateModelBuilder, @Nullable String outputPackageName) {
            Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            return new Arguments(irFile, outputDir, customTypeMap, nullableValueType, generateAccessors, useSemanticNaming, generateModelBuilder, outputPackageName);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Arguments copy$default(Arguments arguments, File file, File file2, Map map, NullableValueType nullableValueType, boolean bl, boolean bl2, boolean bl3, String string, int n, Object object) {
            if ((n & 1) != 0) {
                file = arguments.irFile;
            }
            if ((n & 2) != 0) {
                file2 = arguments.outputDir;
            }
            if ((n & 4) != 0) {
                map = arguments.customTypeMap;
            }
            if ((n & 8) != 0) {
                nullableValueType = arguments.nullableValueType;
            }
            if ((n & 0x10) != 0) {
                bl = arguments.generateAccessors;
            }
            if ((n & 0x20) != 0) {
                bl2 = arguments.useSemanticNaming;
            }
            if ((n & 0x40) != 0) {
                bl3 = arguments.generateModelBuilder;
            }
            if ((n & 0x80) != 0) {
                string = arguments.outputPackageName;
            }
            return arguments.copy(file, file2, map, nullableValueType, bl, bl2, bl3, string);
        }

        public String toString() {
            return "Arguments(irFile=" + this.irFile + ", outputDir=" + this.outputDir + ", customTypeMap=" + this.customTypeMap + ", nullableValueType=" + (Object)((Object)this.nullableValueType) + ", generateAccessors=" + this.generateAccessors + ", useSemanticNaming=" + this.useSemanticNaming + ", generateModelBuilder=" + this.generateModelBuilder + ", outputPackageName=" + this.outputPackageName + ")";
        }

        public int hashCode() {
            File file = this.irFile;
            File file2 = this.outputDir;
            Map<String, String> map = this.customTypeMap;
            NullableValueType nullableValueType = this.nullableValueType;
            int n = ((((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (nullableValueType != null ? ((Object)((Object)nullableValueType)).hashCode() : 0)) * 31;
            int n2 = this.generateAccessors ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.useSemanticNaming ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.generateModelBuilder ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            String string = this.outputPackageName;
            return (n5 + n6) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Arguments)) break block3;
                    Arguments arguments = (Arguments)object;
                    if (!Intrinsics.areEqual((Object)this.irFile, (Object)arguments.irFile) || !Intrinsics.areEqual((Object)this.outputDir, (Object)arguments.outputDir) || !Intrinsics.areEqual(this.customTypeMap, arguments.customTypeMap) || !Intrinsics.areEqual((Object)((Object)this.nullableValueType), (Object)((Object)arguments.nullableValueType)) || !(this.generateAccessors == arguments.generateAccessors) || !(this.useSemanticNaming == arguments.useSemanticNaming) || !(this.generateModelBuilder == arguments.generateModelBuilder) || !Intrinsics.areEqual((Object)this.outputPackageName, (Object)arguments.outputPackageName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Companion;", "", "()V", "APOLLOCODEGEN_VERSION", "", "FILE_EXTENSION", "OUTPUT_DIRECTORY", "", "getOUTPUT_DIRECTORY", "()Ljava/util/List;", "apollo-compiler_main"})
    public static final class Companion {
        @NotNull
        public final List<String> getOUTPUT_DIRECTORY() {
            return OUTPUT_DIRECTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

