/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.ResponseFieldSpec;
import com.apollographql.apollo.compiler.ResponseFieldSpec$WhenMappings;
import com.apollographql.apollo.compiler.UtilKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.Condition;
import com.apollographql.apollo.compiler.ir.Field;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\u0018\u0000 @2\u00020\u0001:\u0001@B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0006\u0010#\u001a\u00020 J&\u0010$\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0018\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010*\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010+\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010,\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0018\u0010/\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u00100\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0016\u00101\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020 J\u0018\u00102\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u00103\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u00106\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u00107\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u00109\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J \u0010:\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u0010;\u001a\u00020 2\u0006\u0010<\u001a\u00020\u001e2\u0006\u00108\u001a\u00020 H\u0002J \u0010=\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u00108\u001a\u00020 H\u0002J\u0018\u0010>\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u001e\u0010?\u001a\u00020 2\u0006\u00105\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\u0006\u00108\u001a\u00020 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006A"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec;", "", "irField", "Lcom/apollographql/apollo/compiler/ir/Field;", "fieldSpec", "Lcom/squareup/javapoet/FieldSpec;", "normalizedFieldSpec", "responseFieldType", "Lcom/apollographql/apollo/api/ResponseField$Type;", "typeConditions", "", "", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/ir/Field;Lcom/squareup/javapoet/FieldSpec;Lcom/squareup/javapoet/FieldSpec;Lcom/apollographql/apollo/api/ResponseField$Type;Ljava/util/List;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getFieldSpec", "()Lcom/squareup/javapoet/FieldSpec;", "getIrField", "()Lcom/apollographql/apollo/compiler/ir/Field;", "getNormalizedFieldSpec", "getResponseFieldType", "()Lcom/apollographql/apollo/api/ResponseField$Type;", "getTypeConditions", "()Ljava/util/List;", "conditionalResponseFieldReaderType", "Lcom/squareup/javapoet/ParameterizedTypeName;", "kotlin.jvm.PlatformType", "type", "Lcom/squareup/javapoet/TypeName;", "conditionsCodeBlock", "Lcom/squareup/javapoet/CodeBlock;", "customTypeFactoryCode", "factoryMethod", "factoryCode", "fragmentFactoryCode", "genericFactoryCode", "readCustomCode", "readerParam", "fieldParam", "readEnumCode", "readFragmentsCode", "readInlineFragmentCode", "readListCode", "readListItemStatement", "rawFieldType", "readObjectCode", "readScalarCode", "readValueCode", "responseFieldListItemReaderType", "responseFieldObjectReaderType", "writeCustomCode", "writerParam", "writeEnumCode", "writeFragmentsCode", "marshaller", "writeInlineFragmentCode", "writeListCode", "writeListItemStatement", "listItemType", "writeObjectCode", "writeScalarCode", "writeValueCode", "Companion", "apollo-compiler_main"})
public final class ResponseFieldSpec {
    @NotNull
    private final Field irField;
    @NotNull
    private final FieldSpec fieldSpec;
    @NotNull
    private final FieldSpec normalizedFieldSpec;
    @NotNull
    private final ResponseField.Type responseFieldType;
    @NotNull
    private final List<String> typeConditions;
    @NotNull
    private final CodeGenerationContext context;
    private static final Map<ResponseField.Type, String> FACTORY_METHODS;
    private static final Map<ResponseField.Type, String> READ_METHODS;
    private static final Map<ResponseField.Type, String> WRITE_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_READ_METHODS;
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec RESPONSE_READER_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_READER_PARAM;
    private static final ParameterSpec OBJECT_VALUE_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_WRITER_PARAM;
    private static final ClassName FRAGMENTS_CLASS;
    private static final String CONDITIONAL_TYPE_VAR = "conditionalType";
    public static final Companion Companion;

    @NotNull
    public final CodeBlock factoryCode() {
        CodeBlock codeBlock;
        Object v = ResponseFieldSpec.Companion.getFACTORY_METHODS().get(this.responseFieldType);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String factoryMethod = (String)v;
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$0[this.responseFieldType.ordinal()]) {
            case 1: {
                codeBlock = this.customTypeFactoryCode(this.irField, factoryMethod);
                break;
            }
            case 2: 
            case 3: {
                codeBlock = this.fragmentFactoryCode(this.irField, factoryMethod, this.typeConditions);
                break;
            }
            default: {
                codeBlock = this.genericFactoryCode(this.irField, factoryMethod);
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock readValueCode(@NotNull CodeBlock readerParam, @NotNull CodeBlock fieldParam) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)readerParam, (String)"readerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$1[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.readScalarCode(readerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.readCustomCode(readerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.readEnumCode(readerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 9: {
                codeBlock = this.readListCode(readerParam, fieldParam);
                break;
            }
            case 10: {
                codeBlock = this.readInlineFragmentCode(readerParam, fieldParam);
                break;
            }
            case 11: {
                codeBlock = this.readFragmentsCode(readerParam, fieldParam);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock fieldParam, @NotNull CodeBlock marshaller) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull((Object)writerParam, (String)"writerParam");
        Intrinsics.checkParameterIsNotNull((Object)fieldParam, (String)"fieldParam");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        switch (ResponseFieldSpec$WhenMappings.$EnumSwitchMapping$2[this.responseFieldType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.writeScalarCode(writerParam, fieldParam);
                break;
            }
            case 6: {
                codeBlock = this.writeEnumCode(writerParam, fieldParam);
                break;
            }
            case 7: {
                codeBlock = this.writeCustomCode(writerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.writeObjectCode(writerParam, fieldParam, marshaller);
                break;
            }
            case 9: {
                codeBlock = this.writeListCode(writerParam, fieldParam, marshaller);
                break;
            }
            case 10: {
                codeBlock = this.writeInlineFragmentCode(writerParam, marshaller);
                break;
            }
            case 11: {
                codeBlock = this.writeFragmentsCode(writerParam, marshaller);
                break;
            }
            default: {
                CodeBlock codeBlock2 = CodeBlock.of((String)"", (Object[])new Object[0]);
                codeBlock = codeBlock2;
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"CodeBlock.of(\"\")");
            }
        }
        return codeBlock;
    }

    private final CodeBlock customTypeFactoryCode(Field irField, String factoryMethod) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = UtilKt.normalizeGraphQlType(irField.getType());
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string3;
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $T.$L, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), customScalarEnum, customScalarEnumConst, this.conditionsCodeBlock(irField)});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026itionsCodeBlock(irField))");
        return codeBlock;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock fragmentFactoryCode(Field irField, String factoryMethod, List<String> typeConditions) {
        void $receiver$iv;
        Iterable iterable = typeConditions;
        CodeBlock.Builder initial$iv = CodeBlock.builder();
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void typeCondition;
            void builder;
            int n = index$iv++;
            String string = (String)element$iv;
            CodeBlock.Builder builder2 = accumulator$iv;
            int i = n;
            accumulator$iv = builder.add(i > 0 ? ",\n" : "", new Object[0]).add("$S", new Object[]{typeCondition});
        }
        Iterable it = iterable = accumulator$iv;
        CodeBlock typeConditionListCode = CodeBlock.builder().add("$T.asList(", new Object[]{Arrays.class}).add(it.build()).add(")", new Object[0]).build();
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), typeConditionListCode});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026e, typeConditionListCode)");
        return codeBlock;
    }

    private final CodeBlock genericFactoryCode(Field irField, String factoryMethod) {
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $L)", (Object[])new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), this.conditionsCodeBlock(irField)});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.\\$L(\\$\u2026itionsCodeBlock(irField))");
        return codeBlock;
    }

    private final CodeBlock readEnumCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock readValueCode = CodeBlock.builder().addStatement("final $T $L", new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name}).beginControlFlow("if ($LStr != null)", new Object[]{this.fieldSpec.name}).addStatement("$L = $T.valueOf($LStr)", new Object[]{this.fieldSpec.name, this.normalizedFieldSpec.type, this.fieldSpec.name}).nextControlFlow("else", new Object[0]).addStatement("$L = null", new Object[]{this.fieldSpec.name}).endControlFlow().build();
        CodeBlock codeBlock = CodeBlock.builder().addStatement("final $T $LStr = $L.$L($L)", new Object[]{ClassNames.INSTANCE.getSTRING(), this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(ResponseField.Type.STRING), fieldParam}).add(readValueCode).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock\n        .build\u2026lueCode)\n        .build()");
        return codeBlock;
    }

    private final CodeBlock readScalarCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026seFieldType], fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readCustomCode(CodeBlock readerParam, CodeBlock fieldParam) {
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026::class.java, fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readObjectCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        Object[] objectArray = new Object[2];
        TypeName typeName2 = this.normalizedFieldSpec.type;
        if (typeName2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName2);
        objectArray[1] = ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name;
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.responseFieldObjectReaderType(typeName)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L)", objectArray).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readListItemStatement(TypeName rawFieldType) {
        Function0<CodeBlock> readScalar$ = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                CodeBlock codeBlock;
                String readMethod;
                String string = (String)com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getSCALAR_LIST_ITEM_READ_METHODS$p(ResponseFieldSpec.Companion).get(this.$rawFieldType);
                if (string == null) {
                    string = readMethod = "readString";
                }
                if (UtilKt.isEnum(this.$rawFieldType, this.this$0.getContext())) {
                    CodeBlock codeBlock2 = CodeBlock.of((String)"return $T.valueOf($L.$L());\n", (Object[])new Object[]{this.$rawFieldType, com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, readMethod});
                    codeBlock = codeBlock2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock2, (String)"CodeBlock.of(\"return \\$T\u2026R_PARAM.name, readMethod)");
                } else {
                    CodeBlock codeBlock3 = CodeBlock.of((String)"return $L.$L();\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, readMethod});
                    codeBlock = codeBlock3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock3, (String)"CodeBlock.of(\"return \\$L\u2026R_PARAM.name, readMethod)");
                }
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> readCustom$ = new Function0<CodeBlock>(this){
            final /* synthetic */ ResponseFieldSpec this$0;

            @NotNull
            public final CodeBlock invoke() {
                ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.this$0.getContext());
                String string = UtilKt.normalizeGraphQlType(this.this$0.getIrField().getType());
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
                String customScalarEnumConst = string3;
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readCustomType($T.$L);\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, customScalarEnum, customScalarEnumConst});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026   customScalarEnumConst)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                super(0);
            }
        };
        Function0<CodeBlock> readObject$ = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                Object[] objectArray = new Object[2];
                TypeName typeName = this.$rawFieldType;
                if (typeName == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
                }
                objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName);
                objectArray[1] = com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name;
                TypeSpec objectReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ResponseFieldSpec.access$responseFieldObjectReaderType(this.this$0, this.$rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.$rawFieldType).addParameter(com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_READER_PARAM$p(ResponseFieldSpec.Companion)).addStatement("return $L.map($L)", objectArray).build()).build();
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readObject($L);\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, objectReaderTypeSpec});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026me, objectReaderTypeSpec)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> readList$ = new Function0<CodeBlock>(this, rawFieldType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $rawFieldType;

            @NotNull
            public final CodeBlock invoke() {
                TypeName rawFieldType = UtilKt.listParamType(this.$rawFieldType);
                CodeBlock readItemCode = ResponseFieldSpec.access$readListItemStatement(this.this$0, rawFieldType);
                TypeSpec listItemReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ResponseFieldSpec.access$responseFieldListItemReaderType(this.this$0, rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p(ResponseFieldSpec.Companion)).addCode(readItemCode).build()).build();
                CodeBlock codeBlock = CodeBlock.of((String)"return $L.readList($L);\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_READER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, listItemReaderTypeSpec});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"return \\$L\u2026, listItemReaderTypeSpec)");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$rawFieldType = typeName;
                super(0);
            }
        };
        if (!UtilKt.isList(rawFieldType)) {
            if (UtilKt.isCustomScalarType(this.irField.getType(), this.context)) {
                return readCustom$.invoke();
            }
            if (UtilKt.isScalar(rawFieldType, this.context)) {
                return readScalar$.invoke();
            }
            return readObject$.invoke();
        }
        return readList$.invoke();
    }

    private final CodeBlock readListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName rawFieldType = UtilKt.listParamType(this.normalizedFieldSpec.type);
        TypeSpec readerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this.responseFieldListItemReaderType(rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(rawFieldType).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_READER_PARAM()).addCode(this.readListItemStatement(rawFieldType)).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readInlineFragmentCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"normalizedFieldSpec.type");
        Object[] objectArray = new Object[2];
        TypeName typeName2 = this.normalizedFieldSpec.type;
        if (typeName2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[0] = UtilKt.mapperFieldName((ClassName)typeName2);
        objectArray[1] = ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name;
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.conditionalResponseFieldReaderType(typeName)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(ParameterSpec.builder((Type)((Type)((Object)String.class)), (String)ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR(), (Modifier[])new Modifier[0]).build()).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L)", objectArray).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock readFragmentsCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        ClassName className = ResponseFieldSpec.Companion.getFRAGMENTS_CLASS();
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"FRAGMENTS_CLASS");
        TypeSpec readerTypeSpec = builder.superclass((TypeName)this.conditionalResponseFieldReaderType((TypeName)className)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ResponseFieldSpec.Companion.getFRAGMENTS_CLASS()).addParameter(ParameterSpec.builder((Type)((Type)((Object)String.class)), (String)ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR(), (Modifier[])new Modifier[0]).build()).addParameter(ResponseFieldSpec.Companion.getRESPONSE_READER_PARAM()).addStatement("return $L.map($L, $L)", new Object[]{UtilKt.mapperFieldName(ResponseFieldSpec.Companion.getFRAGMENTS_CLASS()), ((Companion)ResponseFieldSpec.Companion).getRESPONSE_READER_PARAM().name, ResponseFieldSpec.Companion.getCONDITIONAL_TYPE_VAR()}).build()).build();
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, ResponseFieldSpec.Companion.getREAD_METHODS().get(this.responseFieldType), fieldParam, readerTypeSpec});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"final \\$T \u2026eldParam, readerTypeSpec)");
        return codeBlock;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026   fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam, CodeBlock fieldParam) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L(($T) $L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L((\\\u2026a, fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        CodeBlock valueCode2 = UtilKt.unwrapOptionalValue$default(typeName, string, false, (Function1)new Function1<CodeBlock, CodeBlock>(marshaller){
            final /* synthetic */ CodeBlock $marshaller;

            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])new Object[]{it, this.$marshaller});
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
            {
                this.$marshaller = codeBlock;
                super(1);
            }
        }, 2, null);
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])new Object[]{writerParam, ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType), fieldParam, valueCode2});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026], fieldParam, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeListItemStatement(TypeName listItemType, CodeBlock marshaller) {
        Function0<CodeBlock> writeScalar$ = new Function0<CodeBlock>(this, listItemType){
            final /* synthetic */ ResponseFieldSpec this$0;
            final /* synthetic */ TypeName $listItemType;

            @NotNull
            public final CodeBlock invoke() {
                String string = (String)com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getSCALAR_LIST_ITEM_WRITE_METHODS$p(ResponseFieldSpec.Companion).get(this.$listItemType);
                if (string == null) {
                    string = "writeString";
                }
                String writeMethod = string;
                CodeBlock codeBlock = CodeBlock.builder().add(UtilKt.isEnum(this.$listItemType, this.this$0.getContext()) ? CodeBlock.of((String)"$L.$L((($L) $L).name());\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, writeMethod, this.$listItemType, com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getOBJECT_VALUE_PARAM$p((Companion)ResponseFieldSpec.Companion).name}) : CodeBlock.of((String)"$L.$L($L);\n", (Object[])new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, writeMethod, com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getOBJECT_VALUE_PARAM$p((Companion)ResponseFieldSpec.Companion).name})).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026    })\n          .build()");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                this.$listItemType = typeName;
                super(0);
            }
        };
        Function0<CodeBlock> writeCustom$ = new Function0<CodeBlock>(this){
            final /* synthetic */ ResponseFieldSpec this$0;

            @NotNull
            public final CodeBlock invoke() {
                ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.this$0.getContext());
                String string = UtilKt.normalizeGraphQlType(this.this$0.getIrField().getType());
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase(locale)");
                String customScalarEnumConst = string3;
                CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeCustom($T.$L, $L)", new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, customScalarEnum, customScalarEnumConst, com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getOBJECT_VALUE_PARAM$p((Companion)ResponseFieldSpec.Companion).name}).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026.name)\n          .build()");
                return codeBlock;
            }
            {
                this.this$0 = responseFieldSpec;
                super(0);
            }
        };
        Function0<CodeBlock> writeObject$ = new Function0<CodeBlock>(listItemType, marshaller){
            final /* synthetic */ TypeName $listItemType;
            final /* synthetic */ CodeBlock $marshaller;

            @NotNull
            public final CodeBlock invoke() {
                CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeObject((($L) $L).$L)", new Object[]{com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getRESPONSE_LIST_ITEM_WRITER_PARAM$p((Companion)ResponseFieldSpec.Companion).name, this.$listItemType, com.apollographql.apollo.compiler.ResponseFieldSpec$Companion.access$getOBJECT_VALUE_PARAM$p((Companion)ResponseFieldSpec.Companion).name, this.$marshaller}).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026aller)\n          .build()");
                return codeBlock;
            }
            {
                this.$listItemType = typeName;
                this.$marshaller = codeBlock;
                super(0);
            }
        };
        return UtilKt.isCustomScalarType(this.irField.getType(), this.context) ? writeCustom$.invoke() : (UtilKt.isScalar(listItemType, this.context) ? writeScalar$.invoke() : writeObject$.invoke());
    }

    private final CodeBlock writeListCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller) {
        TypeName listItemType = UtilKt.listParamType(this.normalizedFieldSpec.type);
        while (UtilKt.isList(listItemType)) {
            listItemType = UtilKt.listParamType(listItemType);
        }
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(ResponseFieldSpec.Companion.getOBJECT_VALUE_PARAM()).addParameter(ResponseFieldSpec.Companion.getRESPONSE_LIST_ITEM_WRITER_PARAM()).addCode(this.writeListItemStatement(listItemType, marshaller)).build()).build();
        Object[] objectArray = new Object[5];
        objectArray[0] = writerParam;
        objectArray[1] = ResponseFieldSpec.Companion.getWRITE_METHODS().get(this.responseFieldType);
        objectArray[2] = fieldParam;
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        objectArray[3] = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        objectArray[4] = listWriterType;
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($L, $L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L(\\$\u2026ec.name), listWriterType)");
        return codeBlock;
    }

    private final CodeBlock writeInlineFragmentCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock.Builder builder = CodeBlock.builder();
        Object[] objectArray = new Object[3];
        objectArray[0] = UtilKt.unwrapOptionalType$default(this.fieldSpec.type, false, 1, null).withoutAnnotations();
        objectArray[1] = "$" + this.fieldSpec.name;
        TypeName typeName = this.fieldSpec.type;
        String string = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fieldSpec.name");
        objectArray[2] = UtilKt.unwrapOptionalValue$default(typeName, string, false, null, 6, null);
        CodeBlock codeBlock = builder.addStatement("final $T $L = $L", objectArray).beginControlFlow("if ($L != null)", new Object[]{"$" + this.fieldSpec.name}).addStatement("$L.$L.marshal($L)", new Object[]{"$" + this.fieldSpec.name, marshaller, writerParam}).endControlFlow().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026olFlow()\n        .build()");
        return codeBlock;
    }

    private final CodeBlock writeFragmentsCode(CodeBlock writerParam, CodeBlock marshaller) {
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])new Object[]{this.fieldSpec.name, marshaller, writerParam});
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$L.\\$L.ma\u2026 marshaller, writerParam)");
        return codeBlock;
    }

    private final ParameterizedTypeName responseFieldObjectReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ObjectReader.class), (TypeName[])new TypeName[]{type});
    }

    private final ParameterizedTypeName conditionalResponseFieldReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ConditionalTypeReader.class), (TypeName[])new TypeName[]{type});
    }

    private final ParameterizedTypeName responseFieldListItemReaderType(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ListReader.class), (TypeName[])new TypeName[]{type});
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock conditionsCodeBlock(Field irField) {
        void initial$iv;
        Condition it;
        Iterable $receiver$iv$iv;
        List list;
        List list2;
        Iterable it2 = list2 = irField.getConditions();
        if (irField.isConditional()) {
            list = it2;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = list;
        it2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Condition)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getKind(), (Object)Condition.Kind.BOOLEAN.getRawValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conditions = (List)destination$iv$iv;
        if (conditions.isEmpty()) {
            CodeBlock codeBlock = CodeBlock.of((String)"$T.<$T>emptyList()", (Object[])new Object[]{Collections.class, ResponseField.Condition.class});
            Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.of(\"\\$T.<\\$T>e\u2026ld.Condition::class.java)");
            return codeBlock;
        }
        $receiver$iv$iv = $receiver$iv = (Iterable)conditions;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            CodeBlock codeBlock = CodeBlock.of((String)"$T.booleanCondition($S, $L)", (Object[])new Object[]{ResponseField.Condition.class, it.getVariableName(), it.getInverted()});
            collection.add(codeBlock);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = CodeBlock.builder();
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void codeBlock;
            void builder;
            int n = index$iv++;
            CodeBlock $i$a$1$map = (CodeBlock)element$iv;
            void $i$f$mapTo = accumulator$iv;
            int index = n;
            accumulator$iv = builder.add("$L", new Object[]{index > 0 ? ", " : ""}).add((CodeBlock)codeBlock);
        }
        it2 = list2 = accumulator$iv;
        CodeBlock codeBlock = CodeBlock.builder().add("$T.<$T>asList(", new Object[]{Arrays.class, ResponseField.Condition.class}).add(it2.build()).add(")", new Object[0]).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder()\n    \u2026d(\")\")\n          .build()");
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"conditions.map {\n      C\u2026\n          .build()\n    }");
        return codeBlock;
    }

    @NotNull
    public final Field getIrField() {
        return this.irField;
    }

    @NotNull
    public final FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    @NotNull
    public final FieldSpec getNormalizedFieldSpec() {
        return this.normalizedFieldSpec;
    }

    @NotNull
    public final ResponseField.Type getResponseFieldType() {
        return this.responseFieldType;
    }

    @NotNull
    public final List<String> getTypeConditions() {
        return this.typeConditions;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    public ResponseFieldSpec(@NotNull Field irField, @NotNull FieldSpec fieldSpec, @NotNull FieldSpec normalizedFieldSpec, @NotNull ResponseField.Type responseFieldType, @NotNull List<String> typeConditions, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)irField, (String)"irField");
        Intrinsics.checkParameterIsNotNull((Object)fieldSpec, (String)"fieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)normalizedFieldSpec, (String)"normalizedFieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)responseFieldType, (String)"responseFieldType");
        Intrinsics.checkParameterIsNotNull(typeConditions, (String)"typeConditions");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.irField = irField;
        this.fieldSpec = fieldSpec;
        this.normalizedFieldSpec = normalizedFieldSpec;
        this.responseFieldType = responseFieldType;
        this.typeConditions = typeConditions;
        this.context = context;
    }

    public /* synthetic */ ResponseFieldSpec(Field field, FieldSpec fieldSpec, FieldSpec fieldSpec2, ResponseField.Type type, List list, CodeGenerationContext codeGenerationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(field, fieldSpec, fieldSpec2, type, list, codeGenerationContext);
    }

    static {
        Companion = new Companion(null);
        FACTORY_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"forInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"forLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"forDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"forBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"forString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"forObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"forList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"forCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"forFragment"), TuplesKt.to((Object)ResponseField.Type.INLINE_FRAGMENT, (Object)"forInlineFragment")});
        READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"readInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"readLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"readString"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"readObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"readList"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"readCustomType"), TuplesKt.to((Object)ResponseField.Type.FRAGMENT, (Object)"readConditional"), TuplesKt.to((Object)ResponseField.Type.INLINE_FRAGMENT, (Object)"readConditional")});
        WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ResponseField.Type.STRING, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.INT, (Object)"writeInt"), TuplesKt.to((Object)ResponseField.Type.LONG, (Object)"writeLong"), TuplesKt.to((Object)ResponseField.Type.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)ResponseField.Type.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)ResponseField.Type.ENUM, (Object)"writeString"), TuplesKt.to((Object)ResponseField.Type.CUSTOM, (Object)"writeCustom"), TuplesKt.to((Object)ResponseField.Type.OBJECT, (Object)"writeObject"), TuplesKt.to((Object)ResponseField.Type.LIST, (Object)"writeList")});
        SCALAR_LIST_ITEM_READ_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"readString"), TuplesKt.to((Object)TypeName.INT, (Object)"readInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"readInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"readLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"readLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"readDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"readDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"readBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"readBoolean")});
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ClassNames.INSTANCE.getSTRING(), (Object)"writeString"), TuplesKt.to((Object)TypeName.INT, (Object)"writeInt"), TuplesKt.to((Object)TypeName.INT.box(), (Object)"writeInt"), TuplesKt.to((Object)TypeName.LONG, (Object)"writeLong"), TuplesKt.to((Object)TypeName.LONG.box(), (Object)"writeLong"), TuplesKt.to((Object)TypeName.DOUBLE, (Object)"writeDouble"), TuplesKt.to((Object)TypeName.DOUBLE.box(), (Object)"writeDouble"), TuplesKt.to((Object)TypeName.BOOLEAN, (Object)"writeBoolean"), TuplesKt.to((Object)TypeName.BOOLEAN.box(), (Object)"writeBoolean")});
        RESPONSE_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.class)), (String)"reader", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.ListItemReader.class)), (String)"listItemReader", (Modifier[])new Modifier[0]).build();
        OBJECT_VALUE_PARAM = ParameterSpec.builder((Type)((Type)((Object)Object.class)), (String)"value", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
        FRAGMENTS_CLASS = ClassName.get((String)"", (String)"Fragments", (String[])new String[0]);
        CONDITIONAL_TYPE_VAR = CONDITIONAL_TYPE_VAR;
    }

    public static final /* synthetic */ ParameterizedTypeName access$responseFieldObjectReaderType(ResponseFieldSpec $this, @NotNull TypeName type) {
        return $this.responseFieldObjectReaderType(type);
    }

    @NotNull
    public static final /* synthetic */ CodeBlock access$readListItemStatement(ResponseFieldSpec $this, @NotNull TypeName rawFieldType) {
        return $this.readListItemStatement(rawFieldType);
    }

    public static final /* synthetic */ ParameterizedTypeName access$responseFieldListItemReaderType(ResponseFieldSpec $this, @NotNull TypeName type) {
        return $this.responseFieldListItemReaderType(type);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000bR\u001c\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001c\u0010\u0019\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R(\u0010\u001d\u001a\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001e0\u001e\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR(\u0010 \u001a\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001e0\u001e\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec$Companion;", "", "()V", "CONDITIONAL_TYPE_VAR", "", "getCONDITIONAL_TYPE_VAR", "()Ljava/lang/String;", "FACTORY_METHODS", "", "Lcom/apollographql/apollo/api/ResponseField$Type;", "getFACTORY_METHODS", "()Ljava/util/Map;", "FRAGMENTS_CLASS", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "getFRAGMENTS_CLASS", "()Lcom/squareup/javapoet/ClassName;", "OBJECT_VALUE_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "getOBJECT_VALUE_PARAM", "()Lcom/squareup/javapoet/ParameterSpec;", "READ_METHODS", "getREAD_METHODS", "RESPONSE_LIST_ITEM_READER_PARAM", "getRESPONSE_LIST_ITEM_READER_PARAM", "RESPONSE_LIST_ITEM_WRITER_PARAM", "getRESPONSE_LIST_ITEM_WRITER_PARAM", "RESPONSE_READER_PARAM", "getRESPONSE_READER_PARAM", "SCALAR_LIST_ITEM_READ_METHODS", "Lcom/squareup/javapoet/TypeName;", "getSCALAR_LIST_ITEM_READ_METHODS", "SCALAR_LIST_ITEM_WRITE_METHODS", "getSCALAR_LIST_ITEM_WRITE_METHODS", "WRITE_METHODS", "getWRITE_METHODS", "apollo-compiler_main"})
    public static final class Companion {
        private final Map<ResponseField.Type, String> getFACTORY_METHODS() {
            return FACTORY_METHODS;
        }

        private final Map<ResponseField.Type, String> getREAD_METHODS() {
            return READ_METHODS;
        }

        private final Map<ResponseField.Type, String> getWRITE_METHODS() {
            return WRITE_METHODS;
        }

        private final Map<TypeName, String> getSCALAR_LIST_ITEM_READ_METHODS() {
            return SCALAR_LIST_ITEM_READ_METHODS;
        }

        private final Map<TypeName, String> getSCALAR_LIST_ITEM_WRITE_METHODS() {
            return SCALAR_LIST_ITEM_WRITE_METHODS;
        }

        private final ParameterSpec getRESPONSE_READER_PARAM() {
            return RESPONSE_READER_PARAM;
        }

        private final ParameterSpec getRESPONSE_LIST_ITEM_READER_PARAM() {
            return RESPONSE_LIST_ITEM_READER_PARAM;
        }

        private final ParameterSpec getOBJECT_VALUE_PARAM() {
            return OBJECT_VALUE_PARAM;
        }

        private final ParameterSpec getRESPONSE_LIST_ITEM_WRITER_PARAM() {
            return RESPONSE_LIST_ITEM_WRITER_PARAM;
        }

        private final ClassName getFRAGMENTS_CLASS() {
            return FRAGMENTS_CLASS;
        }

        private final String getCONDITIONAL_TYPE_VAR() {
            return CONDITIONAL_TYPE_VAR;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Map access$getSCALAR_LIST_ITEM_READ_METHODS$p(Companion $this) {
            return $this.getSCALAR_LIST_ITEM_READ_METHODS();
        }

        @NotNull
        public static final /* synthetic */ Map access$getSCALAR_LIST_ITEM_WRITE_METHODS$p(Companion $this) {
            return $this.getSCALAR_LIST_ITEM_WRITE_METHODS();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

