/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.gradle.internal.FileExtensionsKt;
import com.squareup.moshi.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloDownloadSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "endpointUrl", "Lorg/gradle/api/provider/Property;", "", "getEndpointUrl", "()Lorg/gradle/api/provider/Property;", "headers", "Lorg/gradle/api/provider/MapProperty;", "getHeaders", "()Lorg/gradle/api/provider/MapProperty;", "queryParameters", "getQueryParameters", "schemaFilePath", "getSchemaFilePath", "taskAction", "", "Companion", "apollo-gradle-plugin"})
public abstract class ApolloDownloadSchemaTask
extends DefaultTask {
    @NotNull
    private static final String introspectionQuery;
    public static final Companion Companion;

    @Input
    @NotNull
    public abstract Property<String> getEndpointUrl();

    @Input
    @NotNull
    public abstract Property<String> getSchemaFilePath();

    @Optional
    @Input
    @NotNull
    public abstract MapProperty<String, String> getHeaders();

    @Optional
    @Input
    @NotNull
    public abstract MapProperty<String, String> getQueryParameters();

    @TaskAction
    public final void taskAction() {
        Response response;
        if (!this.getSchemaFilePath().isPresent()) {
            throw (Throwable)new IllegalArgumentException("you need to define schemaFilePath.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JsonWriter writer = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((OutputStream)byteArrayOutputStream)));
        writer.beginObject();
        writer.name("query");
        writer.value(introspectionQuery);
        writer.endObject();
        writer.flush();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])byteArrayOutputStream.toByteArray());
        Request.Builder requestBuilder = new Request.Builder().post(body);
        Iterable $this$forEach$iv = ((Map)this.getHeaders().get()).entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            requestBuilder.addHeader((String)it.getKey(), (String)it.getValue());
        }
        HttpUrl.Builder urlBuilder = HttpUrl.get((String)((String)this.getEndpointUrl().get())).newBuilder();
        Iterable $this$forEach$iv2 = ((Map)this.getQueryParameters().get()).entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            urlBuilder.addQueryParameter((String)it.getKey(), (String)it.getValue());
        }
        requestBuilder.url(urlBuilder.build()).url(urlBuilder.build()).build();
        Response response2 = response = new OkHttpClient().newCall(requestBuilder.build()).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful()) {
            ResponseBody responseBody = response.body();
            throw (Throwable)new Exception("cannot get schema: " + response.code() + ":\n" + (responseBody != null ? responseBody.string() : null));
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        String[] stringArray = new String[1];
        Object object = this.getSchemaFilePath().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"schemaFilePath.get()");
        stringArray[0] = (String)object;
        File file2 = FileExtensionsKt.child(file, stringArray);
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            Intrinsics.throwNpe();
        }
        String string = responseBody.string();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.body()!!.string()");
        FilesKt.writeText$default((File)file2, (String)string, null, (int)2, null);
    }

    public ApolloDownloadSchemaTask() {
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        this.getOutputs().cacheIf((Spec)2.INSTANCE);
    }

    static {
        Companion = new Companion(null);
        introspectionQuery = "query IntrospectionQuery {\n  __schema {\n    queryType { name }\n    mutationType { name }\n    subscriptionType { name }\n    types {\n      ...FullType\n    }\n    directives {\n      name\n      description\n      locations\n      args {\n        ...InputValue\n      }\n    }\n  }\n}\n\nfragment FullType on __Type {\n  kind\n  name\n  description\n  fields(includeDeprecated: true) {\n    name\n    description\n    args {\n      ...InputValue\n    }\n    type {\n      ...TypeRef\n    }\n    isDeprecated\n    deprecationReason\n  }\n  inputFields {\n    ...InputValue\n  }\n  interfaces {\n    ...TypeRef\n  }\n  enumValues(includeDeprecated: true) {\n    name\n    description\n    isDeprecated\n    deprecationReason\n  }\n  possibleTypes {\n    ...TypeRef\n  }\n}\n\nfragment InputValue on __InputValue {\n  name\n  description\n  type { ...TypeRef }\n  defaultValue\n}\n\nfragment TypeRef on __Type {\n  kind\n  name\n  ofType {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n              }\n            }\n          }\n        }\n      }\n    }\n  }\n}";
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloDownloadSchemaTask$Companion;", "", "()V", "introspectionQuery", "", "getIntrospectionQuery", "()Ljava/lang/String;", "apollo-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getIntrospectionQuery() {
            return introspectionQuery;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

