/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.internal.QueryDocumentMinifier;
import com.apollographql.apollo.compiler.ApolloMetadata;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.DefaultPackageNameProvider;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.OperationIdGenerator;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.compiler.OperationTypeSpecBuilder;
import com.apollographql.apollo.compiler.Roots;
import com.apollographql.apollo.compiler.VersionKt;
import com.apollographql.apollo.compiler.codegen.kotlin.GraphQLKompiler;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.CodeGenerationIR;
import com.apollographql.apollo.compiler.ir.CodeGenerator;
import com.apollographql.apollo.compiler.ir.Field;
import com.apollographql.apollo.compiler.ir.Fragment;
import com.apollographql.apollo.compiler.ir.IRBuilder;
import com.apollographql.apollo.compiler.ir.Operation;
import com.apollographql.apollo.compiler.ir.ScalarType;
import com.apollographql.apollo.compiler.ir.SourceLocation;
import com.apollographql.apollo.compiler.ir.TypeDeclaration;
import com.apollographql.apollo.compiler.operationoutput.OperationDescriptor;
import com.apollographql.apollo.compiler.operationoutput.OperationOutputKt;
import com.apollographql.apollo.compiler.parser.error.DocumentParseException;
import com.apollographql.apollo.compiler.parser.error.ParseException;
import com.apollographql.apollo.compiler.parser.graphql.DocumentParseResult;
import com.apollographql.apollo.compiler.parser.graphql.GraphQLDocumentParser;
import com.apollographql.apollo.compiler.parser.introspection.IntrospectionQuery;
import com.apollographql.apollo.compiler.parser.introspection.IntrospectionSchema;
import com.apollographql.apollo.compiler.parser.sdl.GraphSdlSchema;
import com.apollographql.apollo.compiler.parser.sdl.GraphSdlSchemaKt;
import com.apollographql.relocated.com.squareup.javapoet.JavaFile;
import com.apollographql.relocated.com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0004\u001f !\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0013H\u0002J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00140\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0002J:\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0017*\b\u0012\u0004\u0012\u00020\b0\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0019\u001a\u00020\r*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler;", "", "logger", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;", "(Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;)V", "getLogger", "()Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;", "anyClassName", "", "generateKotlinModels", "", "idClassName", "write", "", "args", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$Arguments;", "collectDeprecatedUsages", "", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$DeprecatedUsage;", "Lcom/apollographql/apollo/compiler/parser/graphql/DocumentParseResult;", "Lcom/apollographql/apollo/compiler/ir/Field;", "filePath", "supportedTypeMap", "", "customTypeMap", "writeJavaFiles", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationIR;", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "outputDir", "Ljava/io/File;", "Arguments", "Companion", "DeprecatedUsage", "Logger", "apollo-compiler"})
public final class GraphQLCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String AUTO_GENERATED_FILE = "AUTO-GENERATED FILE. DO NOT MODIFY.\n\nThis class was automatically generated by Apollo GraphQL plugin from the GraphQL queries it found.\nIt should not be modified by hand.\n";
    @NotNull
    private static final Logger NoOpLogger = new Logger(){

        public void warning(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        }
    };

    public GraphQLCompiler(@NotNull Logger logger2) {
        Intrinsics.checkParameterIsNotNull((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    public /* synthetic */ GraphQLCompiler(Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger2 = NoOpLogger;
        }
        this(logger2);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull Arguments args) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv3;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv222;
        Object it;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        FilesKt.deleteRecursively((File)args.getOutputDir());
        args.getOutputDir().mkdirs();
        Roots roots = new Roots((Collection<? extends File>)args.getRootFolders());
        ApolloMetadata metadata = GraphQLCompiler.Companion.collectMetadata(args.getMetadata(), args.getRootProjectDir());
        Companion.SchemaInfo schemaInfo = GraphQLCompiler.Companion.getSchemaInfo(roots, args.getPackageName(), args.getRootPackageName(), args.getSchemaFile(), metadata);
        IntrospectionSchema introspectionSchema = schemaInfo.component1();
        String schemaPackageName = schemaInfo.component2();
        Map<String, String> map = metadata;
        Boolean bl = map == null ? null : Boolean.valueOf(((ApolloMetadata)((Object)map)).getGenerateKotlinModels());
        boolean generateKotlinModels = bl == null ? args.getGenerateKotlinModels() : bl.booleanValue();
        Object object3 = metadata;
        map = object3 == null ? null : ((ApolloMetadata)object3).getCustomTypesMap();
        Map<String, String> userCustomTypesMap = map == null ? args.getCustomTypeMap() : map;
        object3 = args.getRootPackageName();
        String string = args.getPackageName();
        DefaultPackageNameProvider packageNameProvider = new DefaultPackageNameProvider((String)object3, schemaPackageName, roots, string);
        Set<File> files = args.getGraphqlFiles();
        GraphQLCompiler.Companion.checkDuplicateFiles(roots, files);
        DocumentParseResult parseResult = new GraphQLDocumentParser(introspectionSchema, packageNameProvider).parse((Collection<? extends File>)files);
        if (args.getWarnOnDeprecatedUsages()) {
            List<DeprecatedUsage> deprecatedUsages = this.collectDeprecatedUsages(parseResult);
            Iterable $this$forEach$iv = deprecatedUsages;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                it = (DeprecatedUsage)element$iv2;
                boolean bl2 = false;
                int column = ((DeprecatedUsage)it).getSourceLocation().getPosition() + 1;
                this.getLogger().warning("w: " + ((DeprecatedUsage)it).getFilePath() + ':' + ((DeprecatedUsage)it).getSourceLocation().getLine() + ':' + column + ": ApolloGraphQL: Use of deprecated field '" + ((DeprecatedUsage)it).getField().getFieldName() + '\'');
            }
            if (args.getFailOnWarnings()) {
                $this$forEach$iv = deprecatedUsages;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    throw new IllegalStateException("ApolloGraphQL: Warnings found and 'failOnWarnings' is true, aborting.");
                }
            }
        }
        CodeGenerationIR ir = new IRBuilder(introspectionSchema, schemaPackageName, metadata, args.getAlwaysGenerateTypesMatching(), args.getGenerateMetadata()).build(parseResult);
        Iterable $this$map$iv22 = ir.getOperations();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            void it2;
            Operation operation = (Operation)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl3 = false;
            object = new OperationDescriptor(it2.getOperationName(), it2.getPackageName(), it2.getFilePath(), QueryDocumentMinifier.minify(it2.getSourceWithFragments()));
            object2.add(object);
        }
        $this$map$iv22 = (List)destination$iv$iv;
        $i$f$map22 = false;
        boolean $this$mapTo$iv$iv222 = false;
        it = $this$map$iv22;
        boolean bl4 = false;
        Map<String, OperationDescriptor> operationOutput = args.getOperationOutputGenerator().generate((Collection)it);
        boolean $this$map$iv22 = operationOutput.size() == ir.getOperations().size();
        $i$f$map22 = false;
        $this$mapTo$iv$iv222 = false;
        if (!$this$map$iv22) {
            boolean bl5 = false;
            String $this$mapTo$iv$iv222 = StringsKt.trimMargin$default((String)("The number of operation IDs (" + operationOutput.size() + ") should match the number of operations (" + ir.getOperations().size() + ").\n        |Check that all your IDs are unique.\n      "), null, (int)1, null);
            throw (Throwable)new IllegalStateException($this$mapTo$iv$iv222.toString());
        }
        if (args.getOperationOutputFile() != null) {
            FilesKt.writeText$default((File)args.getOperationOutputFile(), (String)OperationOutputKt.toJson(operationOutput, "  "), null, (int)2, null);
        }
        Iterable $i$f$map22 = introspectionSchema.getTypes().values();
        object2 = this;
        boolean $i$f$filter = false;
        void bl5 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IntrospectionSchema.Type it3 = (IntrospectionSchema.Type)element$iv$iv;
            boolean bl6 = false;
            if (!(it3 instanceof IntrospectionSchema.Type.Scalar && ScalarType.Companion.forName(it3.getName()) == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        object = (List)destination$iv$iv2;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv3;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IntrospectionSchema.Type it3 = (IntrospectionSchema.Type)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl7 = false;
            String string2 = it3.getName();
            object.add(string2);
        }
        object = (List)destination$iv$iv2;
        Map<String, String> customTypeMap = super.supportedTypeMap(CollectionsKt.plus((Collection)((Collection)object), (Object)ScalarType.ID.INSTANCE.getName()), userCustomTypesMap, generateKotlinModels);
        if (generateKotlinModels) {
            void $this$mapTo$iv$iv3;
            Object item$iv$iv;
            boolean $this$map$iv3 = args.getUseSemanticNaming();
            boolean bl8 = args.getGenerateAsInternal();
            boolean bl9 = args.getKotlinMultiPlatformProject();
            Iterable $this$map$iv4 = args.getEnumAsSealedClassPatternFilters();
            boolean $i$f$map3 = false;
            item$iv$iv = $this$map$iv4;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it4;
                String string3 = (String)item$iv$iv2;
                object2 = destination$iv$iv3;
                boolean bl10 = false;
                void var28_63 = it4;
                boolean bl11 = false;
                object = new Regex((String)var28_63);
                object2.add(object);
            }
            collection = (List)destination$iv$iv3;
            new GraphQLKompiler(ir, customTypeMap, $this$map$iv3, bl8, operationOutput, bl9, (List<Regex>)collection).write(args.getOutputDir());
        } else {
            CodeGenerationContext context = new CodeGenerationContext(CollectionsKt.emptyList(), ir.getTypeDeclarations(), customTypeMap, operationOutput, args.getNullableValueType(), ir, args.getUseSemanticNaming(), args.getGenerateModelBuilder(), args.getUseJavaBeansSemanticNaming(), args.getSuppressRawTypesWarning(), args.getGenerateVisitorForPolymorphicDatatypes());
            this.writeJavaFiles(ir, context, args.getOutputDir());
        }
        args.getMetadataOutputFile().getParentFile().mkdirs();
        if (args.getGenerateMetadata()) {
            void $this$filterTo$iv$iv2;
            Object object4 = metadata == null ? IntrospectionSchema.Companion.wrap(introspectionSchema) : null;
            String string4 = args.getModuleName();
            collection = SetsKt.plus(ir.getEnumsToGenerate(), (Iterable)ir.getInputObjectsToGenerate());
            Object $this$filter$iv2 = ir.getFragments();
            boolean $i$f$filter2 = false;
            Iterable destination$iv$iv3 = $this$filter$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Fragment it5 = (Fragment)element$iv$iv;
                boolean bl12 = false;
                if (!ir.getFragmentsToGenerate().contains(it5.getFragmentName())) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List $this$map$iv4 = (List)destination$iv$iv4;
            $this$filter$iv2 = args.getCustomTypeMap();
            String string5 = VersionKt.getVERSION();
            object4 = new ApolloMetadata((IntrospectionQuery.Wrapper)object4, $this$map$iv4, (Set<String>)collection, schemaPackageName, string4, generateKotlinModels, string5, (Map<String, String>)$this$filter$iv2);
            boolean bl13 = false;
            boolean bl14 = false;
            Object it6 = object4;
            boolean bl15 = false;
            Object outgoingMetadata = args.getRootProjectDir() != null ? ((ApolloMetadata)it6).withRelativeFragments(args.getRootProjectDir()) : it6;
            ((ApolloMetadata)outgoingMetadata).writeTo(args.getMetadataOutputFile());
        } else {
            FilesKt.writeText$default((File)args.getMetadataOutputFile(), (String)"", null, (int)2, null);
        }
    }

    private final List<DeprecatedUsage> collectDeprecatedUsages(DocumentParseResult $this$collectDeprecatedUsages) {
        Iterable list$iv$iv;
        CodeGenerator it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectDeprecatedUsages.getOperations();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Operation)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.collectDeprecatedUsages(((Operation)it).getFields(), ((Operation)it).getFilePath());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = $this$collectDeprecatedUsages.getFragments();
        Collection collection = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Fragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.collectDeprecatedUsages(((Fragment)it).getFields(), ((Fragment)it).getFilePath());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    private final List<DeprecatedUsage> collectDeprecatedUsages(List<Field> $this$collectDeprecatedUsages, String filePath) {
        boolean bl = false;
        List fieldsToVisit = new ArrayList();
        boolean bl2 = false;
        List deprecatedUsages = new ArrayList();
        fieldsToVisit.addAll((Collection)$this$collectDeprecatedUsages);
        while (true) {
            Collection collection = fieldsToVisit;
            boolean bl3 = false;
            if (!(!collection.isEmpty())) break;
            Field field = (Field)fieldsToVisit.remove(CollectionsKt.getLastIndex((List)fieldsToVisit));
            if (field.getDeprecationReason() != null) {
                deprecatedUsages.add(new DeprecatedUsage(filePath, field.getSourceLocation(), field));
            }
            fieldsToVisit.addAll((Collection)field.getFields());
        }
        return deprecatedUsages;
    }

    private final String idClassName(boolean generateKotlinModels) {
        String string;
        if (generateKotlinModels) {
            string = com.apollographql.relocated.com.squareup.kotlinpoet.ClassNames.get(Reflection.getOrCreateKotlinClass(String.class)).toString();
        } else {
            String string2 = ClassNames.INSTANCE.getSTRING().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"{\n    ClassNames.STRING.toString()\n  }");
            string = string2;
        }
        return string;
    }

    private final String anyClassName(boolean generateKotlinModels) {
        String string;
        if (generateKotlinModels) {
            string = com.apollographql.relocated.com.squareup.kotlinpoet.ClassNames.get(Reflection.getOrCreateKotlinClass(Object.class)).toString();
        } else {
            String string2 = ClassNames.INSTANCE.getOBJECT().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"{\n    ClassNames.OBJECT.toString()\n  }");
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> supportedTypeMap(List<String> $this$supportedTypeMap, Map<String, String> customTypeMap, boolean generateKotlinModels) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $this$supportedTypeMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String userClassName = customTypeMap.get(it);
            String className = userClassName != null ? userClassName : (Intrinsics.areEqual((Object)it, (Object)ScalarType.ID.INSTANCE.getName()) ? this.idClassName(generateKotlinModels) : this.anyClassName(generateKotlinModels));
            Pair pair = TuplesKt.to((Object)it, (Object)className);
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeJavaFiles(CodeGenerationIR $this$writeJavaFiles, CodeGenerationContext context, File outputDir) {
        void $this$mapTo$iv$iv;
        TypeSpec typeSpec;
        Collection $this$forEach$iv;
        CodeGenerator it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$writeJavaFiles.getFragments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (Fragment)element$iv$iv;
            boolean bl = false;
            if (!$this$writeJavaFiles.getFragmentsToGenerate().contains(((Fragment)it).getFragmentName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Fragment it2 = (Fragment)element$iv;
            boolean bl = false;
            typeSpec = CodeGenerator.DefaultImpls.toTypeSpec$default(it2, CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, false, false, false, false, 2047, null), false, 2, null);
            JavaFile.builder(it2.getPackageName(), typeSpec).addFileComment(AUTO_GENERATED_FILE, new Object[0]).build().writeTo(outputDir);
        }
        $this$filter$iv = $this$writeJavaFiles.getTypeDeclarations();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (TypeDeclaration)element$iv$iv;
            boolean bl2 = false;
            boolean bl3 = (Intrinsics.areEqual((Object)((TypeDeclaration)it).getKind(), (Object)TypeDeclaration.Companion.getKIND_INPUT_OBJECT_TYPE()) || Intrinsics.areEqual((Object)((TypeDeclaration)it).getKind(), (Object)TypeDeclaration.Companion.getKIND_ENUM())) && SetsKt.plus($this$writeJavaFiles.getEnumsToGenerate(), (Iterable)$this$writeJavaFiles.getInputObjectsToGenerate()).contains(((TypeDeclaration)it).getName());
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeDeclaration it3 = (TypeDeclaration)element$iv;
            boolean bl4 = false;
            typeSpec = CodeGenerator.DefaultImpls.toTypeSpec$default(it3, CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, false, false, false, false, 2047, null), false, 2, null);
            JavaFile.builder(context.getIr().getTypesPackageName(), typeSpec).addFileComment(AUTO_GENERATED_FILE, new Object[0]).build().writeTo(outputDir);
        }
        $this$forEach$iv = $this$writeJavaFiles.getScalarsToGenerate();
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            TypeSpec typeSpec2 = new CustomEnumTypeSpecBuilder(CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, false, false, false, false, 2047, null), $this$writeJavaFiles.getScalarsToGenerate()).build();
            JavaFile.builder(context.getIr().getTypesPackageName(), typeSpec2).addFileComment(AUTO_GENERATED_FILE, new Object[0]).build().writeTo(outputDir);
        }
        Iterable $this$map$iv = $this$writeJavaFiles.getOperations();
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Operation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            OperationTypeSpecBuilder operationTypeSpecBuilder = new OperationTypeSpecBuilder((Operation)it, $this$writeJavaFiles.getFragments(), context.getUseSemanticNaming());
            collection.add(operationTypeSpecBuilder);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationTypeSpecBuilder it4 = (OperationTypeSpecBuilder)element$iv;
            boolean bl6 = false;
            String packageName = it4.getOperation().getPackageName();
            TypeSpec typeSpec3 = CodeGenerator.DefaultImpls.toTypeSpec$default(it4, CodeGenerationContext.copy$default(context, null, null, null, null, null, null, false, false, false, false, false, 2047, null), false, 2, null);
            JavaFile.builder(packageName, typeSpec3).addFileComment(AUTO_GENERATED_FILE, new Object[0]).build().writeTo(outputDir);
        }
    }

    public GraphQLCompiler() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;", "", "warning", "", "message", "", "apollo-compiler"})
    public static interface Logger {
        public void warning(@NotNull String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$DeprecatedUsage;", "", "filePath", "", "sourceLocation", "Lcom/apollographql/apollo/compiler/ir/SourceLocation;", "field", "Lcom/apollographql/apollo/compiler/ir/Field;", "(Ljava/lang/String;Lcom/apollographql/apollo/compiler/ir/SourceLocation;Lcom/apollographql/apollo/compiler/ir/Field;)V", "getField", "()Lcom/apollographql/apollo/compiler/ir/Field;", "getFilePath", "()Ljava/lang/String;", "getSourceLocation", "()Lcom/apollographql/apollo/compiler/ir/SourceLocation;", "apollo-compiler"})
    private static final class DeprecatedUsage {
        @NotNull
        private final String filePath;
        @NotNull
        private final SourceLocation sourceLocation;
        @NotNull
        private final Field field;

        public DeprecatedUsage(@NotNull String filePath, @NotNull SourceLocation sourceLocation, @NotNull Field field) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)sourceLocation, (String)"sourceLocation");
            Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
            this.filePath = filePath;
            this.sourceLocation = sourceLocation;
            this.field = field;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final SourceLocation getSourceLocation() {
            return this.sourceLocation;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0002J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Companion;", "", "()V", "AUTO_GENERATED_FILE", "", "NoOpLogger", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;", "getNoOpLogger", "()Lcom/apollographql/apollo/compiler/GraphQLCompiler$Logger;", "checkDuplicateFiles", "", "roots", "Lcom/apollographql/apollo/compiler/Roots;", "files", "", "Ljava/io/File;", "collectMetadata", "Lcom/apollographql/apollo/compiler/ApolloMetadata;", "metadata", "", "rootProjectDir", "getSchemaInfo", "Lcom/apollographql/apollo/compiler/GraphQLCompiler$Companion$SchemaInfo;", "packageName", "rootPackageName", "schemaFile", "SchemaInfo", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final ApolloMetadata collectMetadata(List<? extends File> metadata, File rootProjectDir) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = metadata;
            ApolloMetadata.Companion companion = ApolloMetadata.Companion;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ApolloMetadata apolloMetadata;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                ApolloMetadata apolloMetadata2 = ApolloMetadata.Companion.readFrom(it);
                if (apolloMetadata2 == null) {
                    apolloMetadata = null;
                } else {
                    ApolloMetadata apolloMetadata3 = apolloMetadata2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ApolloMetadata it2 = apolloMetadata3;
                    boolean bl5 = false;
                    apolloMetadata = rootProjectDir != null ? it2.withResolvedFragments(rootProjectDir) : it2;
                }
                if (apolloMetadata == null) continue;
                ApolloMetadata apolloMetadata4 = apolloMetadata;
                boolean bl6 = false;
                boolean bl7 = false;
                ApolloMetadata it$iv$iv = apolloMetadata4;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return companion.merge(list);
        }

        private final SchemaInfo getSchemaInfo(Roots roots, String packageName, String rootPackageName, File schemaFile, ApolloMetadata metadata) {
            boolean bl = schemaFile != null || metadata != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "ApolloGraphQL: cannot find schema.[json | sdl]";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = schemaFile == null || metadata == null;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                File file;
                boolean bl5 = false;
                String string = "ApolloGraphQL: You can't define a schema in " + ((file = schemaFile) == null ? null : file.getAbsolutePath()) + " as one is already defined in a dependency. Either remove the schema or the dependency";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (schemaFile != null) {
                String string;
                IntrospectionSchema introspectionSchema;
                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)schemaFile), (Object)"json")) {
                    introspectionSchema = IntrospectionSchema.Companion.invoke(schemaFile);
                } else {
                    IntrospectionSchema introspectionSchema2;
                    try {
                        introspectionSchema2 = GraphSdlSchemaKt.toIntrospectionSchema(GraphSdlSchema.Companion.parse(schemaFile));
                    }
                    catch (ParseException e) {
                        String string2 = schemaFile.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"schemaFile.absolutePath");
                        throw DocumentParseException.Companion.invoke(e, string2);
                    }
                    introspectionSchema = introspectionSchema2;
                }
                IntrospectionSchema introspectionSchema3 = introspectionSchema;
                String string3 = packageName;
                if (string3 == null) {
                    String string4;
                    try {
                        string4 = schemaFile.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"schemaFile.absolutePath");
                        string4 = roots.filePackageName(string4);
                    }
                    catch (IllegalArgumentException e) {
                        string4 = "";
                    }
                    boolean bl6 = false;
                    boolean bl7 = false;
                    String it = string4;
                    boolean bl8 = false;
                    string = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(rootPackageName + '.' + it), (CharSequence)"."), (CharSequence)".");
                } else {
                    string = string3;
                }
                String schemaPackageName = string;
                return new SchemaInfo(introspectionSchema3, schemaPackageName);
            }
            if (metadata != null) {
                Object object = metadata.getSchema();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                IntrospectionSchema introspectionSchema = IntrospectionSchema.Companion.toIntrospectionSchema(((IntrospectionQuery.Wrapper)object).get__schema());
                object = metadata.getSchemaPackageName();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                return new SchemaInfo(introspectionSchema, (String)object);
            }
            throw new IllegalStateException("There should at least be metadata or schemaFile");
        }

        /*
         * WARNING - void declaration
         */
        private final void checkDuplicateFiles(Roots roots, Set<? extends File> files) {
            Object value$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = files;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                File it = (File)element$iv$iv;
                boolean bl = false;
                String string = FilesKt.normalize((File)it).getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.normalize().absolutePath");
                key$iv$iv = TuplesKt.to((Object)roots.filePackageName(string), (Object)FilesKt.getNameWithoutExtension((File)it));
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map map = destination$iv$iv;
            Iterable $this$forEach$iv = map.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List it = (List)element$iv;
                boolean bl = false;
                boolean bl3 = it.size() == 1;
                boolean bl4 = false;
                boolean bl5 = false;
                if (bl3) continue;
                boolean bl6 = false;
                key$iv$iv = it;
                String string = "ApolloGraphQL: duplicate(s) graphql file(s) found:\n";
                boolean $i$f$map = false;
                value$iv$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl7 = false;
                    String string2 = it2.getAbsolutePath();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv2;
                String string3 = Intrinsics.stringPlus((String)string, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
        }

        @NotNull
        public final Logger getNoOpLogger() {
            return NoOpLogger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Companion$SchemaInfo;", "", "introspectionSchema", "Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema;", "schemaPackageName", "", "(Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema;Ljava/lang/String;)V", "getIntrospectionSchema", "()Lcom/apollographql/apollo/compiler/parser/introspection/IntrospectionSchema;", "getSchemaPackageName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-compiler"})
        private static final class SchemaInfo {
            @NotNull
            private final IntrospectionSchema introspectionSchema;
            @NotNull
            private final String schemaPackageName;

            public SchemaInfo(@NotNull IntrospectionSchema introspectionSchema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull((Object)introspectionSchema, (String)"introspectionSchema");
                Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
                this.introspectionSchema = introspectionSchema;
                this.schemaPackageName = schemaPackageName;
            }

            @NotNull
            public final IntrospectionSchema getIntrospectionSchema() {
                return this.introspectionSchema;
            }

            @NotNull
            public final String getSchemaPackageName() {
                return this.schemaPackageName;
            }

            @NotNull
            public final IntrospectionSchema component1() {
                return this.introspectionSchema;
            }

            @NotNull
            public final String component2() {
                return this.schemaPackageName;
            }

            @NotNull
            public final SchemaInfo copy(@NotNull IntrospectionSchema introspectionSchema, @NotNull String schemaPackageName) {
                Intrinsics.checkParameterIsNotNull((Object)introspectionSchema, (String)"introspectionSchema");
                Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
                return new SchemaInfo(introspectionSchema, schemaPackageName);
            }

            public static /* synthetic */ SchemaInfo copy$default(SchemaInfo schemaInfo, IntrospectionSchema introspectionSchema, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    introspectionSchema = schemaInfo.introspectionSchema;
                }
                if ((n & 2) != 0) {
                    string = schemaInfo.schemaPackageName;
                }
                return schemaInfo.copy(introspectionSchema, string);
            }

            @NotNull
            public String toString() {
                return "SchemaInfo(introspectionSchema=" + this.introspectionSchema + ", schemaPackageName=" + this.schemaPackageName + ')';
            }

            public int hashCode() {
                int result = this.introspectionSchema.hashCode();
                result = result * 31 + this.schemaPackageName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SchemaInfo)) {
                    return false;
                }
                SchemaInfo schemaInfo = (SchemaInfo)other;
                if (!Intrinsics.areEqual((Object)this.introspectionSchema, (Object)schemaInfo.introspectionSchema)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.schemaPackageName, (Object)schemaInfo.schemaPackageName);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\bG\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00bd\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u000f\u0012\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\b\b\u0002\u0010\u001f\u001a\u00020 \u0012\b\b\u0002\u0010!\u001a\u00020\u000f\u0012\b\b\u0002\u0010\"\u001a\u00020\u000f\u0012\b\b\u0002\u0010#\u001a\u00020\u000f\u0012\b\b\u0002\u0010$\u001a\u00020\u000f\u00a2\u0006\u0002\u0010%J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010J\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010L\u001a\u00020\u0013H\u00c6\u0003J\t\u0010M\u001a\u00020\u000bH\u00c6\u0003J\t\u0010N\u001a\u00020\u000fH\u00c6\u0003J\u0015\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0017H\u00c6\u0003J\t\u0010P\u001a\u00020\u000fH\u00c6\u0003J\t\u0010Q\u001a\u00020\u000fH\u00c6\u0003J\t\u0010R\u001a\u00020\u000fH\u00c6\u0003J\t\u0010S\u001a\u00020\u000fH\u00c6\u0003J\u000f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010V\u001a\u00020\u000fH\u00c6\u0003J\u000f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u00c6\u0003J\t\u0010X\u001a\u00020 H\u00c6\u0003J\t\u0010Y\u001a\u00020\u000fH\u00c6\u0003J\t\u0010Z\u001a\u00020\u000fH\u00c6\u0003J\t\u0010[\u001a\u00020\u000fH\u00c6\u0003J\t\u0010\\\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010]\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010^\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010`\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010c\u001a\u00020\u000fH\u00c6\u0003J\u00cb\u0002\u0010d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\u000f2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\u000f2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u000f2\b\b\u0002\u0010\"\u001a\u00020\u000f2\b\b\u0002\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010$\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010e\u001a\u00020\u000f2\b\u0010f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010g\u001a\u00020hH\u00d6\u0001J\t\u0010i\u001a\u00020\u000bH\u00d6\u0001R\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010'R\u0011\u0010\u001b\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0019\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010,R\u0011\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,R\u0011\u0010!\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010,R\u0011\u0010$\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010,R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010'R\u0011\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010,R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00107R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00107R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00109R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00105R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00109R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00107R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00107R\u0011\u0010#\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010,R\u0011\u0010\"\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010,R\u0011\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010,R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010,\u00a8\u0006j"}, d2={"Lcom/apollographql/apollo/compiler/GraphQLCompiler$Arguments;", "", "rootFolders", "", "Ljava/io/File;", "graphqlFiles", "", "schemaFile", "outputDir", "metadata", "moduleName", "", "rootProjectDir", "metadataOutputFile", "generateMetadata", "", "alwaysGenerateTypesMatching", "operationOutputFile", "operationOutputGenerator", "Lcom/apollographql/apollo/compiler/OperationOutputGenerator;", "rootPackageName", "generateKotlinModels", "customTypeMap", "", "useSemanticNaming", "generateAsInternal", "warnOnDeprecatedUsages", "failOnWarnings", "packageName", "kotlinMultiPlatformProject", "enumAsSealedClassPatternFilters", "nullableValueType", "Lcom/apollographql/apollo/compiler/NullableValueType;", "generateModelBuilder", "useJavaBeansSemanticNaming", "suppressRawTypesWarning", "generateVisitorForPolymorphicDatatypes", "(Ljava/util/List;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/lang/String;Ljava/io/File;Ljava/io/File;ZLjava/util/Set;Ljava/io/File;Lcom/apollographql/apollo/compiler/OperationOutputGenerator;Ljava/lang/String;ZLjava/util/Map;ZZZZLjava/lang/String;ZLjava/util/Set;Lcom/apollographql/apollo/compiler/NullableValueType;ZZZZ)V", "getAlwaysGenerateTypesMatching", "()Ljava/util/Set;", "getCustomTypeMap", "()Ljava/util/Map;", "getEnumAsSealedClassPatternFilters", "getFailOnWarnings", "()Z", "getGenerateAsInternal", "getGenerateKotlinModels", "getGenerateMetadata", "getGenerateModelBuilder", "getGenerateVisitorForPolymorphicDatatypes", "getGraphqlFiles", "getKotlinMultiPlatformProject", "getMetadata", "()Ljava/util/List;", "getMetadataOutputFile", "()Ljava/io/File;", "getModuleName", "()Ljava/lang/String;", "getNullableValueType", "()Lcom/apollographql/apollo/compiler/NullableValueType;", "getOperationOutputFile", "getOperationOutputGenerator", "()Lcom/apollographql/apollo/compiler/OperationOutputGenerator;", "getOutputDir", "getPackageName", "getRootFolders", "getRootPackageName", "getRootProjectDir", "getSchemaFile", "getSuppressRawTypesWarning", "getUseJavaBeansSemanticNaming", "getUseSemanticNaming", "getWarnOnDeprecatedUsages", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "apollo-compiler"})
    public static final class Arguments {
        @NotNull
        private final List<File> rootFolders;
        @NotNull
        private final Set<File> graphqlFiles;
        @Nullable
        private final File schemaFile;
        @NotNull
        private final File outputDir;
        @NotNull
        private final List<File> metadata;
        @NotNull
        private final String moduleName;
        @Nullable
        private final File rootProjectDir;
        @NotNull
        private final File metadataOutputFile;
        private final boolean generateMetadata;
        @Nullable
        private final Set<String> alwaysGenerateTypesMatching;
        @Nullable
        private final File operationOutputFile;
        @NotNull
        private final OperationOutputGenerator operationOutputGenerator;
        @NotNull
        private final String rootPackageName;
        private final boolean generateKotlinModels;
        @NotNull
        private final Map<String, String> customTypeMap;
        private final boolean useSemanticNaming;
        private final boolean generateAsInternal;
        private final boolean warnOnDeprecatedUsages;
        private final boolean failOnWarnings;
        @Nullable
        private final String packageName;
        private final boolean kotlinMultiPlatformProject;
        @NotNull
        private final Set<String> enumAsSealedClassPatternFilters;
        @NotNull
        private final NullableValueType nullableValueType;
        private final boolean generateModelBuilder;
        private final boolean useJavaBeansSemanticNaming;
        private final boolean suppressRawTypesWarning;
        private final boolean generateVisitorForPolymorphicDatatypes;

        public Arguments(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata, @NotNull String moduleName, @Nullable File rootProjectDir, @NotNull File metadataOutputFile, boolean generateMetadata, @Nullable Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customTypeMap, boolean useSemanticNaming, boolean generateAsInternal, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @Nullable String packageName, boolean kotlinMultiPlatformProject, @NotNull Set<String> enumAsSealedClassPatternFilters, @NotNull NullableValueType nullableValueType, boolean generateModelBuilder, boolean useJavaBeansSemanticNaming, boolean suppressRawTypesWarning, boolean generateVisitorForPolymorphicDatatypes) {
            Intrinsics.checkParameterIsNotNull(rootFolders, (String)"rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, (String)"graphqlFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)metadataOutputFile, (String)"metadataOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, (String)"enumAsSealedClassPatternFilters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            this.rootFolders = rootFolders;
            this.graphqlFiles = graphqlFiles;
            this.schemaFile = schemaFile;
            this.outputDir = outputDir;
            this.metadata = metadata;
            this.moduleName = moduleName;
            this.rootProjectDir = rootProjectDir;
            this.metadataOutputFile = metadataOutputFile;
            this.generateMetadata = generateMetadata;
            this.alwaysGenerateTypesMatching = alwaysGenerateTypesMatching;
            this.operationOutputFile = operationOutputFile;
            this.operationOutputGenerator = operationOutputGenerator;
            this.rootPackageName = rootPackageName;
            this.generateKotlinModels = generateKotlinModels;
            this.customTypeMap = customTypeMap;
            this.useSemanticNaming = useSemanticNaming;
            this.generateAsInternal = generateAsInternal;
            this.warnOnDeprecatedUsages = warnOnDeprecatedUsages;
            this.failOnWarnings = failOnWarnings;
            this.packageName = packageName;
            this.kotlinMultiPlatformProject = kotlinMultiPlatformProject;
            this.enumAsSealedClassPatternFilters = enumAsSealedClassPatternFilters;
            this.nullableValueType = nullableValueType;
            this.generateModelBuilder = generateModelBuilder;
            this.useJavaBeansSemanticNaming = useJavaBeansSemanticNaming;
            this.suppressRawTypesWarning = suppressRawTypesWarning;
            this.generateVisitorForPolymorphicDatatypes = generateVisitorForPolymorphicDatatypes;
        }

        public /* synthetic */ Arguments(List list, Set set, File file, File file2, List list2, String string, File file3, File file4, boolean bl, Set set2, File file5, OperationOutputGenerator operationOutputGenerator, String string2, boolean bl2, Map map, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string3, boolean bl7, Set set3, NullableValueType nullableValueType, boolean bl8, boolean bl9, boolean bl10, boolean bl11, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                string = "?";
            }
            if ((n & 0x40) != 0) {
                file3 = null;
            }
            if ((n & 0x100) != 0) {
                bl = false;
            }
            if ((n & 0x200) != 0) {
                set2 = null;
            }
            if ((n & 0x400) != 0) {
                file5 = null;
            }
            if ((n & 0x800) != 0) {
                operationOutputGenerator = new OperationOutputGenerator.DefaultOperationOuputGenerator(new OperationIdGenerator.Sha256());
            }
            if ((n & 0x1000) != 0) {
                string2 = "";
            }
            if ((n & 0x2000) != 0) {
                bl2 = false;
            }
            if ((n & 0x4000) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x8000) != 0) {
                bl3 = true;
            }
            if ((n & 0x10000) != 0) {
                bl4 = false;
            }
            if ((n & 0x20000) != 0) {
                bl5 = true;
            }
            if ((n & 0x40000) != 0) {
                bl6 = false;
            }
            if ((n & 0x80000) != 0) {
                string3 = null;
            }
            if ((n & 0x100000) != 0) {
                bl7 = false;
            }
            if ((n & 0x200000) != 0) {
                set3 = SetsKt.emptySet();
            }
            if ((n & 0x400000) != 0) {
                nullableValueType = NullableValueType.ANNOTATED;
            }
            if ((n & 0x800000) != 0) {
                bl8 = false;
            }
            if ((n & 0x1000000) != 0) {
                bl9 = false;
            }
            if ((n & 0x2000000) != 0) {
                bl10 = false;
            }
            if ((n & 0x4000000) != 0) {
                bl11 = false;
            }
            this(list, set, file, file2, list2, string, file3, file4, bl, set2, file5, operationOutputGenerator, string2, bl2, map, bl3, bl4, bl5, bl6, string3, bl7, set3, nullableValueType, bl8, bl9, bl10, bl11);
        }

        @NotNull
        public final List<File> getRootFolders() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> getGraphqlFiles() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File getSchemaFile() {
            return this.schemaFile;
        }

        @NotNull
        public final File getOutputDir() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> getMetadata() {
            return this.metadata;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @Nullable
        public final File getRootProjectDir() {
            return this.rootProjectDir;
        }

        @NotNull
        public final File getMetadataOutputFile() {
            return this.metadataOutputFile;
        }

        public final boolean getGenerateMetadata() {
            return this.generateMetadata;
        }

        @Nullable
        public final Set<String> getAlwaysGenerateTypesMatching() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File getOperationOutputFile() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator getOperationOutputGenerator() {
            return this.operationOutputGenerator;
        }

        @NotNull
        public final String getRootPackageName() {
            return this.rootPackageName;
        }

        public final boolean getGenerateKotlinModels() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> getCustomTypeMap() {
            return this.customTypeMap;
        }

        public final boolean getUseSemanticNaming() {
            return this.useSemanticNaming;
        }

        public final boolean getGenerateAsInternal() {
            return this.generateAsInternal;
        }

        public final boolean getWarnOnDeprecatedUsages() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public final boolean getKotlinMultiPlatformProject() {
            return this.kotlinMultiPlatformProject;
        }

        @NotNull
        public final Set<String> getEnumAsSealedClassPatternFilters() {
            return this.enumAsSealedClassPatternFilters;
        }

        @NotNull
        public final NullableValueType getNullableValueType() {
            return this.nullableValueType;
        }

        public final boolean getGenerateModelBuilder() {
            return this.generateModelBuilder;
        }

        public final boolean getUseJavaBeansSemanticNaming() {
            return this.useJavaBeansSemanticNaming;
        }

        public final boolean getSuppressRawTypesWarning() {
            return this.suppressRawTypesWarning;
        }

        public final boolean getGenerateVisitorForPolymorphicDatatypes() {
            return this.generateVisitorForPolymorphicDatatypes;
        }

        @NotNull
        public final List<File> component1() {
            return this.rootFolders;
        }

        @NotNull
        public final Set<File> component2() {
            return this.graphqlFiles;
        }

        @Nullable
        public final File component3() {
            return this.schemaFile;
        }

        @NotNull
        public final File component4() {
            return this.outputDir;
        }

        @NotNull
        public final List<File> component5() {
            return this.metadata;
        }

        @NotNull
        public final String component6() {
            return this.moduleName;
        }

        @Nullable
        public final File component7() {
            return this.rootProjectDir;
        }

        @NotNull
        public final File component8() {
            return this.metadataOutputFile;
        }

        public final boolean component9() {
            return this.generateMetadata;
        }

        @Nullable
        public final Set<String> component10() {
            return this.alwaysGenerateTypesMatching;
        }

        @Nullable
        public final File component11() {
            return this.operationOutputFile;
        }

        @NotNull
        public final OperationOutputGenerator component12() {
            return this.operationOutputGenerator;
        }

        @NotNull
        public final String component13() {
            return this.rootPackageName;
        }

        public final boolean component14() {
            return this.generateKotlinModels;
        }

        @NotNull
        public final Map<String, String> component15() {
            return this.customTypeMap;
        }

        public final boolean component16() {
            return this.useSemanticNaming;
        }

        public final boolean component17() {
            return this.generateAsInternal;
        }

        public final boolean component18() {
            return this.warnOnDeprecatedUsages;
        }

        public final boolean component19() {
            return this.failOnWarnings;
        }

        @Nullable
        public final String component20() {
            return this.packageName;
        }

        public final boolean component21() {
            return this.kotlinMultiPlatformProject;
        }

        @NotNull
        public final Set<String> component22() {
            return this.enumAsSealedClassPatternFilters;
        }

        @NotNull
        public final NullableValueType component23() {
            return this.nullableValueType;
        }

        public final boolean component24() {
            return this.generateModelBuilder;
        }

        public final boolean component25() {
            return this.useJavaBeansSemanticNaming;
        }

        public final boolean component26() {
            return this.suppressRawTypesWarning;
        }

        public final boolean component27() {
            return this.generateVisitorForPolymorphicDatatypes;
        }

        @NotNull
        public final Arguments copy(@NotNull List<? extends File> rootFolders, @NotNull Set<? extends File> graphqlFiles, @Nullable File schemaFile, @NotNull File outputDir, @NotNull List<? extends File> metadata, @NotNull String moduleName, @Nullable File rootProjectDir, @NotNull File metadataOutputFile, boolean generateMetadata, @Nullable Set<String> alwaysGenerateTypesMatching, @Nullable File operationOutputFile, @NotNull OperationOutputGenerator operationOutputGenerator, @NotNull String rootPackageName, boolean generateKotlinModels, @NotNull Map<String, String> customTypeMap, boolean useSemanticNaming, boolean generateAsInternal, boolean warnOnDeprecatedUsages, boolean failOnWarnings, @Nullable String packageName, boolean kotlinMultiPlatformProject, @NotNull Set<String> enumAsSealedClassPatternFilters, @NotNull NullableValueType nullableValueType, boolean generateModelBuilder, boolean useJavaBeansSemanticNaming, boolean suppressRawTypesWarning, boolean generateVisitorForPolymorphicDatatypes) {
            Intrinsics.checkParameterIsNotNull(rootFolders, (String)"rootFolders");
            Intrinsics.checkParameterIsNotNull(graphqlFiles, (String)"graphqlFiles");
            Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
            Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            Intrinsics.checkParameterIsNotNull((Object)metadataOutputFile, (String)"metadataOutputFile");
            Intrinsics.checkParameterIsNotNull((Object)operationOutputGenerator, (String)"operationOutputGenerator");
            Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
            Intrinsics.checkParameterIsNotNull(customTypeMap, (String)"customTypeMap");
            Intrinsics.checkParameterIsNotNull(enumAsSealedClassPatternFilters, (String)"enumAsSealedClassPatternFilters");
            Intrinsics.checkParameterIsNotNull((Object)((Object)nullableValueType), (String)"nullableValueType");
            return new Arguments(rootFolders, graphqlFiles, schemaFile, outputDir, metadata, moduleName, rootProjectDir, metadataOutputFile, generateMetadata, alwaysGenerateTypesMatching, operationOutputFile, operationOutputGenerator, rootPackageName, generateKotlinModels, customTypeMap, useSemanticNaming, generateAsInternal, warnOnDeprecatedUsages, failOnWarnings, packageName, kotlinMultiPlatformProject, enumAsSealedClassPatternFilters, nullableValueType, generateModelBuilder, useJavaBeansSemanticNaming, suppressRawTypesWarning, generateVisitorForPolymorphicDatatypes);
        }

        public static /* synthetic */ Arguments copy$default(Arguments arguments2, List list, Set set, File file, File file2, List list2, String string, File file3, File file4, boolean bl, Set set2, File file5, OperationOutputGenerator operationOutputGenerator, String string2, boolean bl2, Map map, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string3, boolean bl7, Set set3, NullableValueType nullableValueType, boolean bl8, boolean bl9, boolean bl10, boolean bl11, int n, Object object) {
            if ((n & 1) != 0) {
                list = arguments2.rootFolders;
            }
            if ((n & 2) != 0) {
                set = arguments2.graphqlFiles;
            }
            if ((n & 4) != 0) {
                file = arguments2.schemaFile;
            }
            if ((n & 8) != 0) {
                file2 = arguments2.outputDir;
            }
            if ((n & 0x10) != 0) {
                list2 = arguments2.metadata;
            }
            if ((n & 0x20) != 0) {
                string = arguments2.moduleName;
            }
            if ((n & 0x40) != 0) {
                file3 = arguments2.rootProjectDir;
            }
            if ((n & 0x80) != 0) {
                file4 = arguments2.metadataOutputFile;
            }
            if ((n & 0x100) != 0) {
                bl = arguments2.generateMetadata;
            }
            if ((n & 0x200) != 0) {
                set2 = arguments2.alwaysGenerateTypesMatching;
            }
            if ((n & 0x400) != 0) {
                file5 = arguments2.operationOutputFile;
            }
            if ((n & 0x800) != 0) {
                operationOutputGenerator = arguments2.operationOutputGenerator;
            }
            if ((n & 0x1000) != 0) {
                string2 = arguments2.rootPackageName;
            }
            if ((n & 0x2000) != 0) {
                bl2 = arguments2.generateKotlinModels;
            }
            if ((n & 0x4000) != 0) {
                map = arguments2.customTypeMap;
            }
            if ((n & 0x8000) != 0) {
                bl3 = arguments2.useSemanticNaming;
            }
            if ((n & 0x10000) != 0) {
                bl4 = arguments2.generateAsInternal;
            }
            if ((n & 0x20000) != 0) {
                bl5 = arguments2.warnOnDeprecatedUsages;
            }
            if ((n & 0x40000) != 0) {
                bl6 = arguments2.failOnWarnings;
            }
            if ((n & 0x80000) != 0) {
                string3 = arguments2.packageName;
            }
            if ((n & 0x100000) != 0) {
                bl7 = arguments2.kotlinMultiPlatformProject;
            }
            if ((n & 0x200000) != 0) {
                set3 = arguments2.enumAsSealedClassPatternFilters;
            }
            if ((n & 0x400000) != 0) {
                nullableValueType = arguments2.nullableValueType;
            }
            if ((n & 0x800000) != 0) {
                bl8 = arguments2.generateModelBuilder;
            }
            if ((n & 0x1000000) != 0) {
                bl9 = arguments2.useJavaBeansSemanticNaming;
            }
            if ((n & 0x2000000) != 0) {
                bl10 = arguments2.suppressRawTypesWarning;
            }
            if ((n & 0x4000000) != 0) {
                bl11 = arguments2.generateVisitorForPolymorphicDatatypes;
            }
            return arguments2.copy(list, set, file, file2, list2, string, file3, file4, bl, set2, file5, operationOutputGenerator, string2, bl2, map, bl3, bl4, bl5, bl6, string3, bl7, set3, nullableValueType, bl8, bl9, bl10, bl11);
        }

        @NotNull
        public String toString() {
            return "Arguments(rootFolders=" + this.rootFolders + ", graphqlFiles=" + this.graphqlFiles + ", schemaFile=" + this.schemaFile + ", outputDir=" + this.outputDir + ", metadata=" + this.metadata + ", moduleName=" + this.moduleName + ", rootProjectDir=" + this.rootProjectDir + ", metadataOutputFile=" + this.metadataOutputFile + ", generateMetadata=" + this.generateMetadata + ", alwaysGenerateTypesMatching=" + this.alwaysGenerateTypesMatching + ", operationOutputFile=" + this.operationOutputFile + ", operationOutputGenerator=" + this.operationOutputGenerator + ", rootPackageName=" + this.rootPackageName + ", generateKotlinModels=" + this.generateKotlinModels + ", customTypeMap=" + this.customTypeMap + ", useSemanticNaming=" + this.useSemanticNaming + ", generateAsInternal=" + this.generateAsInternal + ", warnOnDeprecatedUsages=" + this.warnOnDeprecatedUsages + ", failOnWarnings=" + this.failOnWarnings + ", packageName=" + this.packageName + ", kotlinMultiPlatformProject=" + this.kotlinMultiPlatformProject + ", enumAsSealedClassPatternFilters=" + this.enumAsSealedClassPatternFilters + ", nullableValueType=" + (Object)((Object)this.nullableValueType) + ", generateModelBuilder=" + this.generateModelBuilder + ", useJavaBeansSemanticNaming=" + this.useJavaBeansSemanticNaming + ", suppressRawTypesWarning=" + this.suppressRawTypesWarning + ", generateVisitorForPolymorphicDatatypes=" + this.generateVisitorForPolymorphicDatatypes + ')';
        }

        public int hashCode() {
            int result = ((Object)this.rootFolders).hashCode();
            result = result * 31 + ((Object)this.graphqlFiles).hashCode();
            result = result * 31 + (this.schemaFile == null ? 0 : this.schemaFile.hashCode());
            result = result * 31 + this.outputDir.hashCode();
            result = result * 31 + ((Object)this.metadata).hashCode();
            result = result * 31 + this.moduleName.hashCode();
            result = result * 31 + (this.rootProjectDir == null ? 0 : this.rootProjectDir.hashCode());
            result = result * 31 + this.metadataOutputFile.hashCode();
            int n = this.generateMetadata ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.alwaysGenerateTypesMatching == null ? 0 : ((Object)this.alwaysGenerateTypesMatching).hashCode());
            result = result * 31 + (this.operationOutputFile == null ? 0 : this.operationOutputFile.hashCode());
            result = result * 31 + this.operationOutputGenerator.hashCode();
            result = result * 31 + this.rootPackageName.hashCode();
            int n2 = this.generateKotlinModels ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + ((Object)this.customTypeMap).hashCode();
            int n3 = this.useSemanticNaming ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.generateAsInternal ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            int n5 = this.warnOnDeprecatedUsages ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            result = result * 31 + n5;
            int n6 = this.failOnWarnings ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            result = result * 31 + n6;
            result = result * 31 + (this.packageName == null ? 0 : this.packageName.hashCode());
            int n7 = this.kotlinMultiPlatformProject ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            result = result * 31 + n7;
            result = result * 31 + ((Object)this.enumAsSealedClassPatternFilters).hashCode();
            result = result * 31 + this.nullableValueType.hashCode();
            int n8 = this.generateModelBuilder ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            result = result * 31 + n8;
            int n9 = this.useJavaBeansSemanticNaming ? 1 : 0;
            if (n9 != 0) {
                n9 = 1;
            }
            result = result * 31 + n9;
            int n10 = this.suppressRawTypesWarning ? 1 : 0;
            if (n10 != 0) {
                n10 = 1;
            }
            result = result * 31 + n10;
            int n11 = this.generateVisitorForPolymorphicDatatypes ? 1 : 0;
            if (n11 != 0) {
                n11 = 1;
            }
            result = result * 31 + n11;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Arguments)) {
                return false;
            }
            Arguments arguments2 = (Arguments)other;
            if (!Intrinsics.areEqual(this.rootFolders, arguments2.rootFolders)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.graphqlFiles, arguments2.graphqlFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.schemaFile, (Object)arguments2.schemaFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputDir, (Object)arguments2.outputDir)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.metadata, arguments2.metadata)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moduleName, (Object)arguments2.moduleName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rootProjectDir, (Object)arguments2.rootProjectDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metadataOutputFile, (Object)arguments2.metadataOutputFile)) {
                return false;
            }
            if (this.generateMetadata != arguments2.generateMetadata) {
                return false;
            }
            if (!Intrinsics.areEqual(this.alwaysGenerateTypesMatching, arguments2.alwaysGenerateTypesMatching)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputFile, (Object)arguments2.operationOutputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operationOutputGenerator, (Object)arguments2.operationOutputGenerator)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rootPackageName, (Object)arguments2.rootPackageName)) {
                return false;
            }
            if (this.generateKotlinModels != arguments2.generateKotlinModels) {
                return false;
            }
            if (!Intrinsics.areEqual(this.customTypeMap, arguments2.customTypeMap)) {
                return false;
            }
            if (this.useSemanticNaming != arguments2.useSemanticNaming) {
                return false;
            }
            if (this.generateAsInternal != arguments2.generateAsInternal) {
                return false;
            }
            if (this.warnOnDeprecatedUsages != arguments2.warnOnDeprecatedUsages) {
                return false;
            }
            if (this.failOnWarnings != arguments2.failOnWarnings) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.packageName, (Object)arguments2.packageName)) {
                return false;
            }
            if (this.kotlinMultiPlatformProject != arguments2.kotlinMultiPlatformProject) {
                return false;
            }
            if (!Intrinsics.areEqual(this.enumAsSealedClassPatternFilters, arguments2.enumAsSealedClassPatternFilters)) {
                return false;
            }
            if (this.nullableValueType != arguments2.nullableValueType) {
                return false;
            }
            if (this.generateModelBuilder != arguments2.generateModelBuilder) {
                return false;
            }
            if (this.useJavaBeansSemanticNaming != arguments2.useJavaBeansSemanticNaming) {
                return false;
            }
            if (this.suppressRawTypesWarning != arguments2.suppressRawTypesWarning) {
                return false;
            }
            return this.generateVisitorForPolymorphicDatatypes == arguments2.generateVisitorForPolymorphicDatatypes;
        }
    }
}

