/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.compiler.Annotations;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.TestUtilsKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.ScalarType;
import com.apollographql.relocated.com.squareup.javapoet.AnnotationSpec;
import com.apollographql.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.relocated.com.squareup.javapoet.TypeName;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo/compiler/JavaTypeResolver;", "", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "packageName", "", "deprecated", "", "(Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;Ljava/lang/String;Z)V", "resolve", "Lcom/apollographql/relocated/com/squareup/javapoet/TypeName;", "typeName", "isOptional", "nullableValueType", "Lcom/apollographql/apollo/compiler/NullableValueType;", "supportsAnnotations", "apollo-compiler"})
public final class JavaTypeResolver {
    @NotNull
    private final CodeGenerationContext context;
    @NotNull
    private final String packageName;
    private final boolean deprecated;

    public JavaTypeResolver(@NotNull CodeGenerationContext context, @NotNull String packageName, boolean deprecated) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        this.context = context;
        this.packageName = packageName;
        this.deprecated = deprecated;
    }

    public /* synthetic */ JavaTypeResolver(CodeGenerationContext codeGenerationContext, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(codeGenerationContext, string, bl);
    }

    @NotNull
    public final TypeName resolve(@NotNull String typeName, boolean isOptional, @Nullable NullableValueType nullableValueType, boolean supportsAnnotations) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
        String normalizedTypeName = StringsKt.removeSuffix((String)typeName, (CharSequence)"!");
        boolean isList = StringsKt.startsWith$default((CharSequence)normalizedTypeName, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)normalizedTypeName, (char)']', (boolean)false, (int)2, null);
        String customScalarType = this.context.getCustomTypeMap().get(normalizedTypeName);
        Object javaType = isList ? ClassNames.INSTANCE.parameterizedListOf(JavaTypeResolver.resolve$default(this, StringsKt.removeSurrounding((String)normalizedTypeName, (CharSequence)"[", (CharSequence)"]"), false, null, false, 4, null)) : (Intrinsics.areEqual((Object)normalizedTypeName, (Object)ScalarType.STRING.INSTANCE.getName()) ? (Object)ClassNames.INSTANCE.getSTRING() : (Intrinsics.areEqual((Object)normalizedTypeName, (Object)ScalarType.INT.INSTANCE.getName()) ? (isOptional ? TypeName.INT.box() : TypeName.INT) : (Intrinsics.areEqual((Object)normalizedTypeName, (Object)ScalarType.BOOLEAN.INSTANCE.getName()) ? (isOptional ? TypeName.BOOLEAN.box() : TypeName.BOOLEAN) : (Intrinsics.areEqual((Object)normalizedTypeName, (Object)ScalarType.FLOAT.INSTANCE.getName()) ? (isOptional ? TypeName.DOUBLE.box() : TypeName.DOUBLE) : (customScalarType != null ? (TypeName)TestUtilsKt.toJavaType(customScalarType) : (TypeName)ClassName.get(this.packageName, StringsKt.capitalize((String)normalizedTypeName), new String[0]))))));
        if (!supportsAnnotations) {
            Object object2 = javaType;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"{\n        // Adding an annotation to a primitive type will crash in javapoet's TypeName.box()\n        // The underlying issue is that the annotation should be on the field name and not on the type name but it is a more\n        // complex issue. Don't add the annotation for now if the type is used in a context where annotations do not make sense.\n        // See https://github.com/apollographql/apollo-android/issues/2660\n        // See https://github.com/apollographql/apollo-android/issues/2246\n        javaType\n      }");
            object = object2;
        } else if (((TypeName)javaType).isPrimitive()) {
            Object object3;
            Object object4 = javaType;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object4;
            boolean bl3 = false;
            if (this.deprecated) {
                AnnotationSpec[] annotationSpecArray = new AnnotationSpec[]{Annotations.INSTANCE.getDEPRECATED()};
                object3 = ((TypeName)it).annotated(annotationSpecArray);
            } else {
                object3 = it;
            }
            Object object5 = object3;
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"{\n        javaType.let { if (deprecated) it.annotated(Annotations.DEPRECATED) else it }\n      }");
            object = object5;
        } else if (isOptional) {
            Object object6;
            TypeName typeName2;
            NullableValueType nullableValueType2 = nullableValueType;
            Object object7 = nullableValueType2 == null ? this.context.getNullableValueType() : nullableValueType2;
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object7).ordinal()];
            switch (n) {
                case 1: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"javaType");
                    typeName2 = ClassNames.INSTANCE.parameterizedOptional((TypeName)javaType);
                    break;
                }
                case 2: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"javaType");
                    typeName2 = ClassNames.INSTANCE.parameterizedGuavaOptional((TypeName)javaType);
                    break;
                }
                case 3: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"javaType");
                    typeName2 = ClassNames.INSTANCE.parameterizedJavaOptional((TypeName)javaType);
                    break;
                }
                case 4: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaType, (String)"javaType");
                    typeName2 = ClassNames.INSTANCE.parameterizedInputType((TypeName)javaType);
                    break;
                }
                default: {
                    AnnotationSpec[] annotationSpecArray = new AnnotationSpec[]{Annotations.INSTANCE.getNULLABLE()};
                    typeName2 = ((TypeName)javaType).annotated(annotationSpecArray);
                }
            }
            object7 = typeName2;
            n = 0;
            boolean bl = false;
            Object it = object7;
            boolean bl4 = false;
            if (this.deprecated) {
                AnnotationSpec[] annotationSpecArray = new AnnotationSpec[]{Annotations.INSTANCE.getDEPRECATED()};
                object6 = ((TypeName)it).annotated(annotationSpecArray);
            } else {
                object6 = it;
            }
            Object object8 = object6;
            Intrinsics.checkExpressionValueIsNotNull((Object)object8, (String)"{\n        when (nullableValueType ?: context.nullableValueType) {\n          NullableValueType.APOLLO_OPTIONAL -> parameterizedOptional(javaType)\n          NullableValueType.GUAVA_OPTIONAL -> parameterizedGuavaOptional(javaType)\n          NullableValueType.JAVA_OPTIONAL -> parameterizedJavaOptional(javaType)\n          NullableValueType.INPUT_TYPE -> parameterizedInputType(javaType)\n          else -> javaType.annotated(Annotations.NULLABLE)\n        }.let {\n          if (deprecated) it.annotated(Annotations.DEPRECATED) else it\n        }\n      }");
            object = object8;
        } else {
            Object object9;
            Object object10 = new AnnotationSpec[]{Annotations.INSTANCE.getNONNULL()};
            object10 = ((TypeName)javaType).annotated((AnnotationSpec[])object10);
            boolean bl = false;
            boolean bl5 = false;
            Object it = object10;
            boolean bl6 = false;
            if (this.deprecated) {
                AnnotationSpec[] annotationSpecArray = new AnnotationSpec[]{Annotations.INSTANCE.getDEPRECATED()};
                object9 = ((TypeName)it).annotated(annotationSpecArray);
            } else {
                object9 = it;
            }
            Object object11 = object9;
            Intrinsics.checkExpressionValueIsNotNull((Object)object11, (String)"{\n        javaType.annotated(Annotations.NONNULL).let {\n          if (deprecated) it.annotated(Annotations.DEPRECATED) else it\n        }\n      }");
            object = object11;
        }
        return object;
    }

    public static /* synthetic */ TypeName resolve$default(JavaTypeResolver javaTypeResolver, String string, boolean bl, NullableValueType nullableValueType, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl3 = bl = !StringsKt.endsWith$default((String)string, (String)"!", (boolean)false, (int)2, null);
        }
        if ((n & 4) != 0) {
            nullableValueType = null;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return javaTypeResolver.resolve(string, bl, nullableValueType, bl2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NullableValueType.values().length];
            nArray[NullableValueType.APOLLO_OPTIONAL.ordinal()] = 1;
            nArray[NullableValueType.GUAVA_OPTIONAL.ordinal()] = 2;
            nArray[NullableValueType.JAVA_OPTIONAL.ordinal()] = 3;
            nArray[NullableValueType.INPUT_TYPE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

