/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.StringSegment;
import com.ibm.icu.impl.number.CustomSymbolCurrency;
import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.Grouper;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import com.ibm.icu.impl.number.RoundingUtils;
import com.ibm.icu.impl.number.parse.AffixMatcher;
import com.ibm.icu.impl.number.parse.CurrencyMatcher;
import com.ibm.icu.impl.number.parse.CurrencyTrieMatcher;
import com.ibm.icu.impl.number.parse.DecimalMatcher;
import com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import com.ibm.icu.impl.number.parse.InfinityMatcher;
import com.ibm.icu.impl.number.parse.MatcherFactory;
import com.ibm.icu.impl.number.parse.MinusSignMatcher;
import com.ibm.icu.impl.number.parse.MultiplierHandler;
import com.ibm.icu.impl.number.parse.NanMatcher;
import com.ibm.icu.impl.number.parse.NumberParseMatcher;
import com.ibm.icu.impl.number.parse.PaddingMatcher;
import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.PercentMatcher;
import com.ibm.icu.impl.number.parse.PermilleMatcher;
import com.ibm.icu.impl.number.parse.PlusSignMatcher;
import com.ibm.icu.impl.number.parse.RequireAffixMatcher;
import com.ibm.icu.impl.number.parse.RequireCurrencyMatcher;
import com.ibm.icu.impl.number.parse.RequireDecimalSeparatorMatcher;
import com.ibm.icu.impl.number.parse.RequireExponentMatcher;
import com.ibm.icu.impl.number.parse.RequireNumberMatcher;
import com.ibm.icu.impl.number.parse.ScientificMatcher;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class NumberParserImpl {
    private final int parseFlags;
    private final List<NumberParseMatcher> matchers = new ArrayList<NumberParseMatcher>();
    private final List<UnicodeSet> leadCodePointses;
    private Comparator<ParsedNumber> comparator;
    private boolean frozen;

    @Deprecated
    public static NumberParserImpl removeMeWhenMerged(ULocale locale, String pattern, int parseFlags) {
        NumberParserImpl parser2 = new NumberParserImpl(parseFlags);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        IgnorablesMatcher ignorables = IgnorablesMatcher.DEFAULT;
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = Currency.getInstance("USD");
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.newGenerate(patternInfo, parser2, factory2, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale, patternInfo);
        parser2.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        parser2.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        parser2.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser2.freeze();
        return parser2;
    }

    @Deprecated
    public static NumberParserImpl createParserFromPattern(ULocale locale, String pattern, boolean strictGrouping) {
        int parseFlags = 4225;
        if (strictGrouping) {
            parseFlags |= 8;
        }
        NumberParserImpl parser2 = new NumberParserImpl(parseFlags);
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        IgnorablesMatcher ignorables = IgnorablesMatcher.DEFAULT;
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = Currency.getInstance("USD");
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        PatternStringParser.ParsedPatternInfo patternInfo = PatternStringParser.parseToPatternInfo(pattern);
        AffixMatcher.newGenerate(patternInfo, parser2, factory2, ignorables, parseFlags);
        Grouper grouper = Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO).withLocaleData(locale, patternInfo);
        parser2.addMatcher(ignorables);
        parser2.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        parser2.addMatcher(MinusSignMatcher.getInstance(symbols, false));
        parser2.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
        parser2.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        parser2.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        parser2.addMatcher(new RequireNumberMatcher());
        parser2.freeze();
        return parser2;
    }

    public static Number parseStatic(String input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        NumberParserImpl parser2 = NumberParserImpl.createParserFromProperties(properties, symbols, false, false);
        ParsedNumber result = new ParsedNumber();
        parser2.parse(input, true, result);
        if (result.success()) {
            ppos.setIndex(result.charEnd);
            return result.getNumber();
        }
        ppos.setErrorIndex(result.charEnd);
        return null;
    }

    public static CurrencyAmount parseStaticCurrency(String input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        NumberParserImpl parser2 = NumberParserImpl.createParserFromProperties(properties, symbols, true, false);
        ParsedNumber result = new ParsedNumber();
        parser2.parse(input, true, result);
        if (result.success()) {
            Currency currency;
            ppos.setIndex(result.charEnd);
            if (result.currencyCode != null) {
                currency = Currency.getInstance(result.currencyCode);
            } else {
                assert (0 != (result.flags & 0x10));
                currency = CustomSymbolCurrency.resolve(properties.getCurrency(), symbols.getULocale(), symbols);
            }
            return new CurrencyAmount(result.getNumber(), currency);
        }
        ppos.setErrorIndex(result.charEnd);
        return null;
    }

    public static NumberParserImpl createDefaultParserForLocale(ULocale loc, boolean optimize) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(loc);
        DecimalFormatProperties properties = PatternStringParser.parseToProperties("0");
        return NumberParserImpl.createParserFromProperties(properties, symbols, false, optimize);
    }

    public static NumberParserImpl createParserFromProperties(DecimalFormatProperties properties, DecimalFormatSymbols symbols, boolean parseCurrency, boolean optimize) {
        ULocale locale = symbols.getULocale();
        PropertiesAffixPatternProvider patternInfo = new PropertiesAffixPatternProvider(properties);
        Currency currency = CustomSymbolCurrency.resolve(properties.getCurrency(), locale, symbols);
        boolean isStrict = properties.getParseMode() == ParseMode.STRICT;
        Grouper grouper = Grouper.forProperties(properties);
        int parseFlags = 0;
        parseFlags |= 0x800;
        if (!properties.getParseCaseSensitive()) {
            parseFlags |= 1;
        }
        if (properties.getParseIntegerOnly()) {
            parseFlags |= 0x10;
        }
        if (properties.getSignAlwaysShown()) {
            parseFlags |= 0x400;
        }
        if (isStrict) {
            parseFlags |= 8;
            parseFlags |= 4;
            parseFlags |= 0x100;
            parseFlags |= 0x200;
        } else {
            parseFlags |= 0x80;
        }
        if (grouper.getPrimary() <= 0) {
            parseFlags |= 0x20;
        }
        if (parseCurrency || patternInfo.hasCurrencySign()) {
            parseFlags |= 2;
        }
        if (optimize) {
            parseFlags |= 0x1000;
        }
        IgnorablesMatcher ignorables = isStrict ? IgnorablesMatcher.STRICT : IgnorablesMatcher.DEFAULT;
        NumberParserImpl parser2 = new NumberParserImpl(parseFlags);
        MatcherFactory factory2 = new MatcherFactory();
        factory2.currency = currency;
        factory2.symbols = symbols;
        factory2.ignorables = ignorables;
        factory2.locale = locale;
        AffixMatcher.newGenerate(patternInfo, parser2, factory2, ignorables, parseFlags);
        if (parseCurrency || patternInfo.hasCurrencySign()) {
            parser2.addMatcher(CurrencyMatcher.getInstance(currency, locale));
            parser2.addMatcher(CurrencyTrieMatcher.getInstance(locale));
        }
        if (!isStrict) {
            parser2.addMatcher(PlusSignMatcher.getInstance(symbols, false));
            parser2.addMatcher(MinusSignMatcher.getInstance(symbols, false));
            parser2.addMatcher(NanMatcher.getInstance(symbols, parseFlags));
            parser2.addMatcher(PercentMatcher.getInstance(symbols));
            parser2.addMatcher(PermilleMatcher.getInstance(symbols));
        }
        parser2.addMatcher(InfinityMatcher.getInstance(symbols));
        String padString = properties.getPadString();
        if (padString != null && !ignorables.getSet().contains(padString)) {
            parser2.addMatcher(PaddingMatcher.getInstance(padString));
        }
        parser2.addMatcher(ignorables);
        parser2.addMatcher(DecimalMatcher.getInstance(symbols, grouper, parseFlags));
        if (!properties.getParseNoExponent()) {
            parser2.addMatcher(ScientificMatcher.getInstance(symbols, grouper));
        }
        parser2.addMatcher(new RequireNumberMatcher());
        if (isStrict) {
            parser2.addMatcher(new RequireAffixMatcher());
        }
        if (isStrict && properties.getMinimumExponentDigits() > 0) {
            parser2.addMatcher(new RequireExponentMatcher());
        }
        if (parseCurrency) {
            parser2.addMatcher(new RequireCurrencyMatcher());
        }
        if (properties.getDecimalPatternMatchRequired()) {
            boolean patternHasDecimalSeparator = properties.getDecimalSeparatorAlwaysShown() || properties.getMaximumFractionDigits() != 0;
            parser2.addMatcher(RequireDecimalSeparatorMatcher.getInstance(patternHasDecimalSeparator));
        }
        if (properties.getMultiplier() != null) {
            parser2.addMatcher(new MultiplierHandler(properties.getMultiplier(), RoundingUtils.getMathContextOr34Digits(properties)));
        }
        parser2.freeze();
        return parser2;
    }

    public NumberParserImpl(int parseFlags) {
        this.leadCodePointses = 0 != (parseFlags & 0x1000) ? new ArrayList<UnicodeSet>() : null;
        this.comparator = ParsedNumber.COMPARATOR;
        this.parseFlags = parseFlags;
        this.frozen = false;
    }

    public void addMatcher(NumberParseMatcher matcher) {
        assert (!this.frozen);
        this.matchers.add(matcher);
        if (this.leadCodePointses != null) {
            this.addLeadCodePointsForMatcher(matcher);
        }
    }

    public void addMatchers(Collection<? extends NumberParseMatcher> matchers) {
        assert (!this.frozen);
        this.matchers.addAll(matchers);
        if (this.leadCodePointses != null) {
            for (NumberParseMatcher numberParseMatcher : matchers) {
                this.addLeadCodePointsForMatcher(numberParseMatcher);
            }
        }
    }

    private void addLeadCodePointsForMatcher(NumberParseMatcher matcher) {
        UnicodeSet leadCodePoints = matcher.getLeadCodePoints();
        assert (leadCodePoints.isFrozen());
        if (0 != (this.parseFlags & 1)) {
            leadCodePoints = leadCodePoints.cloneAsThawed().closeOver(4).freeze();
        }
        this.leadCodePointses.add(leadCodePoints);
    }

    public void setComparator(Comparator<ParsedNumber> comparator) {
        assert (!this.frozen);
        this.comparator = comparator;
    }

    public void freeze() {
        this.frozen = true;
    }

    public void parse(String input, boolean greedy, ParsedNumber result) {
        this.parse(input, 0, greedy, result);
    }

    public void parse(String input, int start, boolean greedy, ParsedNumber result) {
        assert (this.frozen);
        assert (start >= 0 && start < input.length());
        StringSegment segment = new StringSegment(input, 0 != (this.parseFlags & 1));
        segment.adjustOffset(start);
        if (greedy) {
            this.parseGreedyRecursive(segment, result);
        } else {
            this.parseLongestRecursive(segment, result);
        }
        for (NumberParseMatcher matcher : this.matchers) {
            matcher.postProcess(result);
        }
    }

    private void parseGreedyRecursive(StringSegment segment, ParsedNumber result) {
        if (segment.length() == 0) {
            return;
        }
        int initialOffset = segment.getOffset();
        int leadCp = segment.getCodePoint();
        for (int i = 0; i < this.matchers.size(); ++i) {
            if (this.leadCodePointses != null && !this.leadCodePointses.get(i).contains(leadCp)) continue;
            NumberParseMatcher matcher = this.matchers.get(i);
            matcher.match(segment, result);
            if (segment.getOffset() == initialOffset) continue;
            this.parseGreedyRecursive(segment, result);
            segment.setOffset(initialOffset);
            return;
        }
    }

    private void parseLongestRecursive(StringSegment segment, ParsedNumber result) {
        if (segment.length() == 0) {
            return;
        }
        ParsedNumber initial = new ParsedNumber();
        initial.copyFrom(result);
        ParsedNumber candidate = new ParsedNumber();
        int initialOffset = segment.getOffset();
        block0: for (int i = 0; i < this.matchers.size(); ++i) {
            NumberParseMatcher matcher = this.matchers.get(i);
            int charsToConsume = 0;
            while (charsToConsume < segment.length()) {
                charsToConsume += Character.charCount(Character.codePointAt(segment, charsToConsume));
                candidate.copyFrom(initial);
                segment.setLength(charsToConsume);
                boolean maybeMore = matcher.match(segment, candidate);
                segment.resetLength();
                if (segment.getOffset() - initialOffset == charsToConsume) {
                    this.parseLongestRecursive(segment, candidate);
                    if (this.comparator.compare(candidate, result) > 0) {
                        result.copyFrom(candidate);
                    }
                }
                segment.setOffset(initialOffset);
                if (maybeMore) continue;
                continue block0;
            }
        }
    }

    public String toString() {
        return "<NumberParserImpl matchers=" + this.matchers.toString() + ">";
    }

    public static enum ParseMode {
        LENIENT,
        STRICT;

    }
}

