/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.Scalars;
import graphql.VisibleForTesting;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.InputValueWithState;
import graphql.schema.PropertyDataFetcherHelper;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.util.FpKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class ValuesResolver {
    public Map<String, Object> coerceVariableValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> rawVariables) throws CoercingParseValueException, NonNullableValueCoercedAsNullException {
        return this.externalValueToInternalValueForVariables(schema, variableDefinitions, rawVariables);
    }

    public Map<String, NormalizedInputValue> getNormalizedVariableValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> rawVariables) {
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            String variableName = variableDefinition.getName();
            GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
            Assert.assertTrue(variableType instanceof GraphQLInputType);
            Value defaultValue = variableDefinition.getDefaultValue();
            boolean hasValue = rawVariables.containsKey(variableName);
            Object value = rawVariables.get(variableName);
            if (!hasValue && defaultValue != null) {
                result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), defaultValue));
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(variableType) && (!hasValue || value == null)) {
                return (Map)Assert.assertShouldNeverHappen("variable values are expected to be valid", new Object[0]);
            }
            if (!hasValue) continue;
            if (value == null) {
                result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), null));
                continue;
            }
            Object literal = this.externalValueToLiteral(fieldVisibility, value, (GraphQLInputType)variableType, ValueMode.NORMALIZED);
            result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), literal));
        }
        return result;
    }

    public Map<String, Object> getArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments2, Map<String, Object> coercedVariables) {
        GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().fieldVisibility(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY).build();
        return this.getArgumentValuesImpl(codeRegistry, argumentTypes, arguments2, coercedVariables);
    }

    public Map<String, NormalizedInputValue> getNormalizedArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments2, Map<String, NormalizedInputValue> normalizedVariables) {
        GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().fieldVisibility(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY).build();
        if (argumentTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        Map<String, Argument> argumentMap = this.argumentMap(arguments2);
        for (GraphQLArgument argumentDefinition : argumentTypes) {
            String argumentName = argumentDefinition.getName();
            Argument argument = argumentMap.get(argumentName);
            if (argument == null || ValuesResolver.isVariableAbsent(argument.getValue(), normalizedVariables)) continue;
            GraphQLInputType argumentType = argumentDefinition.getType();
            Object value = this.literalToNormalizedValue(codeRegistry.getFieldVisibility(), argumentType, argument.getValue(), normalizedVariables);
            result.put(argumentName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(argumentType), value));
        }
        return result;
    }

    public Map<String, Object> getArgumentValues(GraphQLCodeRegistry codeRegistry, List<GraphQLArgument> argumentTypes, List<Argument> arguments2, Map<String, Object> coercedVariables) {
        return this.getArgumentValuesImpl(codeRegistry, argumentTypes, arguments2, coercedVariables);
    }

    public static Value<?> valueToLiteral(InputValueWithState inputValueWithState, GraphQLType type) {
        return ValuesResolver.valueToLiteral(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY, inputValueWithState, type);
    }

    public static Value<?> valueToLiteral(@NotNull GraphqlFieldVisibility fieldVisibility, @NotNull InputValueWithState inputValueWithState, @NotNull GraphQLType type) {
        return (Value)ValuesResolver.valueToLiteral(fieldVisibility, inputValueWithState, type, ValueMode.LITERAL);
    }

    private static Object valueToLiteral(GraphqlFieldVisibility fieldVisibility, InputValueWithState inputValueWithState, GraphQLType type, ValueMode valueMode) {
        if (inputValueWithState.isInternal()) {
            if (valueMode == ValueMode.NORMALIZED) {
                return Assert.assertShouldNeverHappen("can't infer normalized structure", new Object[0]);
            }
            return ValuesResolver.valueToLiteralLegacy(inputValueWithState.getValue(), type);
        }
        if (inputValueWithState.isLiteral()) {
            return inputValueWithState.getValue();
        }
        if (inputValueWithState.isExternal()) {
            return new ValuesResolver().externalValueToLiteral(fieldVisibility, inputValueWithState.getValue(), (GraphQLInputType)type, valueMode);
        }
        return Assert.assertShouldNeverHappen("unexpected value state " + inputValueWithState, new Object[0]);
    }

    public static Object externalValueToInternalValue(GraphqlFieldVisibility fieldVisibility, Object externalValue, GraphQLInputType type) {
        return new ValuesResolver().externalValueToInternalValue(fieldVisibility, type, externalValue);
    }

    public static Object valueToInternalValue(InputValueWithState inputValueWithState, GraphQLType type) throws CoercingParseValueException, CoercingParseLiteralException {
        DefaultGraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        if (inputValueWithState.isInternal()) {
            return inputValueWithState.getValue();
        }
        if (inputValueWithState.isLiteral()) {
            return new ValuesResolver().literalToInternalValue(fieldVisibility, type, (Value)inputValueWithState.getValue(), ImmutableKit.emptyMap());
        }
        if (inputValueWithState.isExternal()) {
            return new ValuesResolver().externalValueToInternalValue(fieldVisibility, type, inputValueWithState.getValue());
        }
        return Assert.assertShouldNeverHappen("unexpected value state " + inputValueWithState, new Object[0]);
    }

    @Nullable
    public static <T> T getInputValueImpl(GraphQLInputType inputType, InputValueWithState inputValue) {
        if (inputValue.isNotSet()) {
            return null;
        }
        return (T)ValuesResolver.valueToInternalValue(inputValue, inputType);
    }

    private Object externalValueToLiteral(GraphqlFieldVisibility fieldVisibility, @Nullable Object value, GraphQLInputType type, ValueMode valueMode) {
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return this.externalValueToLiteral(fieldVisibility, value, (GraphQLInputType)GraphQLTypeUtil.unwrapNonNull(type), valueMode);
        }
        if (type instanceof GraphQLScalarType) {
            return this.externalValueToLiteralForScalar((GraphQLScalarType)type, value);
        }
        if (type instanceof GraphQLEnumType) {
            return this.externalValueToLiteralForEnum((GraphQLEnumType)type, value);
        }
        if (type instanceof GraphQLList) {
            return this.externalValueToLiteralForList(fieldVisibility, (GraphQLList)type, value, valueMode);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.externalValueToLiteralForObject(fieldVisibility, (GraphQLInputObjectType)type, value, valueMode);
        }
        return Assert.assertShouldNeverHappen("unexpected type %s", type);
    }

    private Value externalValueToLiteralForScalar(GraphQLScalarType scalarType, Object value) {
        return scalarType.getCoercing().valueToLiteral(value);
    }

    private Value externalValueToLiteralForEnum(GraphQLEnumType enumType, Object value) {
        return enumType.valueToLiteral(value);
    }

    private Object externalValueToLiteralForList(GraphqlFieldVisibility fieldVisibility, GraphQLList listType, Object value, ValueMode valueMode) {
        GraphQLInputType wrappedType = (GraphQLInputType)listType.getWrappedType();
        List<Value> result = FpKit.toListOrSingletonList(value).stream().map(val -> this.externalValueToLiteral(fieldVisibility, val, wrappedType, valueMode)).collect(Collectors.toList());
        if (valueMode == ValueMode.NORMALIZED) {
            return result;
        }
        return ArrayValue.newArrayValue().values(result).build();
    }

    private Object externalValueToLiteralForObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType inputObjectType, Object inputValue, ValueMode valueMode) {
        Assert.assertTrue(inputValue instanceof Map, () -> "Expect Map as input");
        Map inputMap = (Map)inputValue;
        List<GraphQLInputObjectField> fieldDefinitions = fieldVisibility.getFieldDefinitions(inputObjectType);
        LinkedHashMap<String, NormalizedInputValue> normalizedResult = new LinkedHashMap<String, NormalizedInputValue>();
        ImmutableList.Builder objectFields = ImmutableList.builder();
        for (GraphQLInputObjectField inputFieldDefinition : fieldDefinitions) {
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            boolean hasValue = inputMap.containsKey(fieldName);
            Object fieldValue = inputMap.getOrDefault(fieldName, null);
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Value<?> defaultValueLiteral = ValuesResolver.valueToLiteral(fieldVisibility, inputFieldDefinition.getInputFieldDefaultValue(), fieldType);
                if (valueMode == ValueMode.LITERAL) {
                    normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), defaultValueLiteral));
                    continue;
                }
                objectFields.add(ObjectField.newObjectField().name(fieldName).value(defaultValueLiteral).build());
                continue;
            }
            if (!hasValue) continue;
            if (fieldValue == null) {
                if (valueMode == ValueMode.NORMALIZED) {
                    normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), null));
                    continue;
                }
                objectFields.add(ObjectField.newObjectField().name(fieldName).value(NullValue.newNullValue().build()).build());
                continue;
            }
            Object literal = this.externalValueToLiteral(fieldVisibility, fieldValue, fieldType, valueMode);
            if (valueMode == ValueMode.NORMALIZED) {
                normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), literal));
                continue;
            }
            objectFields.add(ObjectField.newObjectField().name(fieldName).value((Value)literal).build());
        }
        if (valueMode == ValueMode.NORMALIZED) {
            return normalizedResult;
        }
        return ObjectValue.newObjectValue().objectFields((List<ObjectField>)((Object)objectFields.build())).build();
    }

    private Map<String, Object> externalValueToInternalValueForVariables(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> rawVariables) {
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            String variableName = variableDefinition.getName();
            GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
            Assert.assertTrue(variableType instanceof GraphQLInputType);
            Value defaultValue = variableDefinition.getDefaultValue();
            boolean hasValue = rawVariables.containsKey(variableName);
            Object value = rawVariables.get(variableName);
            if (!hasValue && defaultValue != null) {
                Object coercedDefaultValue = this.literalToInternalValue(fieldVisibility, variableType, defaultValue, Collections.emptyMap());
                coercedValues.put(variableName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(variableType) && (!hasValue || value == null)) {
                throw new NonNullableValueCoercedAsNullException(variableDefinition, variableType);
            }
            if (!hasValue) continue;
            if (value == null) {
                coercedValues.put(variableName, null);
                continue;
            }
            Object coercedValue = this.externalValueToInternalValue(fieldVisibility, variableType, value);
            coercedValues.put(variableName, coercedValue);
        }
        return coercedValues;
    }

    private Map<String, Object> getArgumentValuesImpl(GraphQLCodeRegistry codeRegistry, List<GraphQLArgument> argumentTypes, List<Argument> arguments2, Map<String, Object> coercedVariables) {
        if (argumentTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        Map<String, Argument> argumentMap = this.argumentMap(arguments2);
        for (GraphQLArgument argumentDefinition : argumentTypes) {
            Object value;
            Value argumentValue;
            GraphQLInputType argumentType = argumentDefinition.getType();
            String argumentName = argumentDefinition.getName();
            Argument argument = argumentMap.get(argumentName);
            InputValueWithState defaultValue = argumentDefinition.getArgumentDefaultValue();
            boolean hasValue = argument != null;
            Value value2 = argumentValue = argument != null ? argument.getValue() : null;
            if (argumentValue instanceof VariableReference) {
                String variableName = ((VariableReference)argumentValue).getName();
                hasValue = coercedVariables.containsKey(variableName);
                value = coercedVariables.get(variableName);
            } else {
                value = argumentValue;
            }
            if (!hasValue && argumentDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = this.defaultValueToInternalValue(codeRegistry.getFieldVisibility(), defaultValue, argumentType);
                coercedValues.put(argumentName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(argumentType) && (!hasValue || this.isNullValue(value))) {
                throw new RuntimeException();
            }
            if (!hasValue) continue;
            if (this.isNullValue(value)) {
                coercedValues.put(argumentName, value);
                continue;
            }
            if (argumentValue instanceof VariableReference) {
                coercedValues.put(argumentName, value);
                continue;
            }
            value = this.literalToInternalValue(codeRegistry.getFieldVisibility(), argumentType, argument.getValue(), coercedVariables);
            coercedValues.put(argumentName, value);
        }
        return coercedValues;
    }

    private Map<String, Argument> argumentMap(List<Argument> arguments2) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>(arguments2.size());
        for (Argument argument : arguments2) {
            result.put(argument.getName(), argument);
        }
        return result;
    }

    private Object externalValueToInternalValue(GraphqlFieldVisibility fieldVisibility, GraphQLType graphQLType, Object value) throws NonNullableValueCoercedAsNullException, CoercingParseValueException {
        try {
            if (GraphQLTypeUtil.isNonNull(graphQLType)) {
                Object returnValue = this.externalValueToInternalValue(fieldVisibility, GraphQLTypeUtil.unwrapOne(graphQLType), value);
                if (returnValue == null) {
                    throw new NonNullableValueCoercedAsNullException("", ImmutableKit.emptyList(), graphQLType);
                }
                return returnValue;
            }
            if (value == null) {
                return null;
            }
            if (graphQLType instanceof GraphQLScalarType) {
                return this.externalValueToInternalValueForScalar((GraphQLScalarType)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLEnumType) {
                return this.externalValueToInternalValueForEnum((GraphQLEnumType)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLList) {
                return this.externalValueToInternalValueForList(fieldVisibility, (GraphQLList)graphQLType, value);
            }
            if (graphQLType instanceof GraphQLInputObjectType) {
                if (value instanceof Map) {
                    return this.externalValueToInternalValueForObject(fieldVisibility, (GraphQLInputObjectType)graphQLType, (Map)value);
                }
                throw ((CoercingParseValueException.Builder)CoercingParseValueException.newCoercingParseValueException().message("Expected type 'Map' but was '" + value.getClass().getSimpleName() + "'. Variables for input objects must be an instance of type 'Map'.")).build();
            }
            return Assert.assertShouldNeverHappen("unhandled type %s", graphQLType);
        }
        catch (CoercingParseValueException e) {
            if (e.getLocations() != null) {
                throw e;
            }
            CoercingParseValueException.Builder builder = CoercingParseValueException.newCoercingParseValueException();
            throw ((CoercingParseValueException.Builder)((CoercingParseValueException.Builder)((CoercingParseValueException.Builder)builder.message("invalid value : " + e.getMessage())).extensions(e.getExtensions())).cause(e.getCause())).build();
        }
    }

    private Object externalValueToInternalValueForObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType inputObjectType, Map<String, Object> inputMap) throws NonNullableValueCoercedAsNullException, CoercingParseValueException {
        List<GraphQLInputObjectField> fieldDefinitions = fieldVisibility.getFieldDefinitions(inputObjectType);
        ImmutableList<String> fieldNames = ImmutableKit.map(fieldDefinitions, GraphQLInputObjectField::getName);
        for (String providedFieldName : inputMap.keySet()) {
            if (fieldNames.contains(providedFieldName)) continue;
            throw new InputMapDefinesTooManyFieldsException(inputObjectType, providedFieldName);
        }
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (GraphQLInputObjectField inputFieldDefinition : fieldDefinitions) {
            Object fieldValue;
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            InputValueWithState defaultValue = inputFieldDefinition.getInputFieldDefaultValue();
            boolean hasValue = inputMap.containsKey(fieldName);
            Object value = fieldValue = inputMap.getOrDefault(fieldName, null);
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = this.defaultValueToInternalValue(fieldVisibility, defaultValue, fieldType);
                coercedValues.put(fieldName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(fieldType) && (!hasValue || value == null)) {
                throw new NonNullableValueCoercedAsNullException(fieldName, ImmutableKit.emptyList(), (GraphQLType)fieldType);
            }
            if (!hasValue) continue;
            if (value == null) {
                coercedValues.put(fieldName, null);
                continue;
            }
            value = this.externalValueToInternalValue(fieldVisibility, fieldType, value);
            coercedValues.put(fieldName, value);
        }
        return coercedValues;
    }

    private Object externalValueToInternalValueForScalar(GraphQLScalarType graphQLScalarType, Object value) throws CoercingParseValueException {
        return graphQLScalarType.getCoercing().parseValue(value);
    }

    private Object externalValueToInternalValueForEnum(GraphQLEnumType graphQLEnumType, Object value) throws CoercingParseValueException {
        return graphQLEnumType.parseValue(value);
    }

    private List externalValueToInternalValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList graphQLList, Object value) throws CoercingParseValueException, NonNullableValueCoercedAsNullException {
        GraphQLType wrappedType = graphQLList.getWrappedType();
        return FpKit.toListOrSingletonList(value).stream().map(val -> this.externalValueToInternalValue(fieldVisibility, wrappedType, val)).collect(Collectors.toList());
    }

    public Object literalToNormalizedValue(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, Map<String, NormalizedInputValue> normalizedVariables) {
        if (inputValue instanceof VariableReference) {
            String varName = ((VariableReference)inputValue).getName();
            return normalizedVariables.get(varName).getValue();
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return inputValue;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return this.literalToNormalizedValue(fieldVisibility, GraphQLTypeUtil.unwrapOne(type), inputValue, normalizedVariables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.literalToNormalizedValueForInputObject(fieldVisibility, (GraphQLInputObjectType)type, (ObjectValue)inputValue, normalizedVariables);
        }
        if (type instanceof GraphQLEnumType) {
            return inputValue;
        }
        if (GraphQLTypeUtil.isList(type)) {
            return this.literalToNormalizedValueForList(fieldVisibility, (GraphQLList)type, inputValue, normalizedVariables);
        }
        return null;
    }

    private Object literalToNormalizedValueForInputObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType type, ObjectValue inputObjectLiteral, Map<String, NormalizedInputValue> normalizedVariables) {
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        for (ObjectField field : inputObjectLiteral.getObjectFields()) {
            if (ValuesResolver.isVariableAbsent(field.getValue(), normalizedVariables)) continue;
            GraphQLInputType fieldType = type.getField(field.getName()).getType();
            Object fieldValue = this.literalToNormalizedValue(fieldVisibility, fieldType, field.getValue(), normalizedVariables);
            result.put(field.getName(), new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), fieldValue));
        }
        return result;
    }

    private List<Object> literalToNormalizedValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList type, Value value, Map<String, NormalizedInputValue> normalizedVariables) {
        if (value instanceof ArrayValue) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value valueInArray : ((ArrayValue)value).getValues()) {
                result.add(this.literalToNormalizedValue(fieldVisibility, type.getWrappedType(), valueInArray, normalizedVariables));
            }
            return result;
        }
        return Collections.singletonList(this.literalToNormalizedValue(fieldVisibility, type.getWrappedType(), value, normalizedVariables));
    }

    public Object literalToInternalValue(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, Map<String, Object> coercedVariables) {
        if (inputValue instanceof VariableReference) {
            Object variableValue = coercedVariables.get(((VariableReference)inputValue).getName());
            return variableValue;
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return this.literalToInternalValueForScalar(inputValue, (GraphQLScalarType)type, coercedVariables);
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return this.literalToInternalValue(fieldVisibility, GraphQLTypeUtil.unwrapOne(type), inputValue, coercedVariables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.literalToInternalValueForInputObject(fieldVisibility, (GraphQLInputObjectType)type, (ObjectValue)inputValue, coercedVariables);
        }
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).parseLiteral(inputValue);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return this.literalToInternalValueForList(fieldVisibility, (GraphQLList)type, inputValue, coercedVariables);
        }
        return null;
    }

    private Object literalToInternalValueForScalar(Value inputValue, GraphQLScalarType scalarType, Map<String, Object> variables) {
        return scalarType.getCoercing().parseLiteral(inputValue, variables);
    }

    private Object literalToInternalValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList graphQLList, Value value, Map<String, Object> coercedVariables) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value singleValue : arrayValue.getValues()) {
                result.add(this.literalToInternalValue(fieldVisibility, graphQLList.getWrappedType(), singleValue, coercedVariables));
            }
            return result;
        }
        return Collections.singletonList(this.literalToInternalValue(fieldVisibility, graphQLList.getWrappedType(), value, coercedVariables));
    }

    private Object literalToInternalValueForInputObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType type, ObjectValue inputValue, Map<String, Object> coercedVariables) {
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        Map<String, ObjectField> inputFieldsByName = this.mapObjectValueFieldsByName(inputValue);
        List<GraphQLInputObjectField> inputFieldTypes = fieldVisibility.getFieldDefinitions(type);
        for (GraphQLInputObjectField inputFieldDefinition : inputFieldTypes) {
            Object value;
            Value fieldValue;
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            ObjectField field = inputFieldsByName.get(fieldName);
            boolean hasValue = field != null;
            Value value2 = fieldValue = field != null ? field.getValue() : null;
            if (fieldValue instanceof VariableReference) {
                String variableName = ((VariableReference)fieldValue).getName();
                hasValue = coercedVariables.containsKey(variableName);
                value = coercedVariables.get(variableName);
            } else {
                value = fieldValue;
            }
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = this.defaultValueToInternalValue(fieldVisibility, inputFieldDefinition.getInputFieldDefaultValue(), fieldType);
                coercedValues.put(fieldName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(fieldType) && (!hasValue || this.isNullValue(value))) {
                return Assert.assertShouldNeverHappen("Should have been validated before", new Object[0]);
            }
            if (!hasValue) continue;
            if (this.isNullValue(value)) {
                coercedValues.put(fieldName, value);
                continue;
            }
            if (fieldValue instanceof VariableReference) {
                coercedValues.put(fieldName, value);
                continue;
            }
            value = this.literalToInternalValue(fieldVisibility, fieldType, fieldValue, coercedVariables);
            coercedValues.put(fieldName, value);
        }
        return coercedValues;
    }

    private boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof NormalizedInputValue)) {
            return false;
        }
        return ((NormalizedInputValue)value).getValue() == null;
    }

    private Map<String, ObjectField> mapObjectValueFieldsByName(ObjectValue inputValue) {
        LinkedHashMap<String, ObjectField> inputValueFieldsByName = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : inputValue.getObjectFields()) {
            inputValueFieldsByName.put(objectField.getName(), objectField);
        }
        return inputValueFieldsByName;
    }

    private Object defaultValueToInternalValue(GraphqlFieldVisibility fieldVisibility, InputValueWithState defaultValue, GraphQLInputType type) {
        if (defaultValue.isInternal()) {
            return defaultValue.getValue();
        }
        if (defaultValue.isLiteral()) {
            return this.literalToInternalValue(fieldVisibility, type, (Value)defaultValue.getValue(), Collections.emptyMap());
        }
        if (defaultValue.isExternal()) {
            return this.externalValueToInternalValue(fieldVisibility, type, defaultValue.getValue());
        }
        return Assert.assertShouldNeverHappen();
    }

    @VisibleForTesting
    static Value<?> valueToLiteralLegacy(Object value, GraphQLType type) {
        Assert.assertTrue(!(value instanceof Value), () -> "Unexpected literal " + value);
        if (value == null) {
            return null;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ValuesResolver.handleNonNullLegacy(value, (GraphQLNonNull)type);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ValuesResolver.handleListLegacy(value, (GraphQLList)type);
        }
        if (type instanceof GraphQLInputObjectType) {
            return ValuesResolver.handleInputObjectLegacy(value, (GraphQLInputObjectType)type);
        }
        if (!(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType)) {
            throw new AssertException("Must provide Input Type, cannot use: " + type.getClass());
        }
        Object serialized = ValuesResolver.serializeLegacy(type, value);
        if (ValuesResolver.isNullishLegacy(serialized)) {
            return null;
        }
        if (serialized instanceof Boolean) {
            return BooleanValue.newBooleanValue().value((Boolean)serialized).build();
        }
        String stringValue = serialized.toString();
        if (serialized instanceof Number) {
            return ValuesResolver.handleNumberLegacy(stringValue);
        }
        if (serialized instanceof String) {
            if (type instanceof GraphQLEnumType) {
                return EnumValue.newEnumValue().name(stringValue).build();
            }
            if (type == Scalars.GraphQLID && stringValue.matches("^[0-9]+$")) {
                return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
            }
            return StringValue.newStringValue().value(stringValue).build();
        }
        throw new AssertException("'Cannot convert value to AST: " + serialized);
    }

    private static Value<?> handleInputObjectLegacy(Object javaValue, GraphQLInputObjectType type) {
        List<GraphQLInputObjectField> fields2 = type.getFields();
        ArrayList<ObjectField> fieldNodes = new ArrayList<ObjectField>();
        fields2.forEach(field -> {
            GraphQLInputType fieldType;
            String fieldName = field.getName();
            Object fieldValueObj = PropertyDataFetcherHelper.getPropertyValue(fieldName, javaValue, fieldType = field.getType());
            Value<?> nodeValue = ValuesResolver.valueToLiteralLegacy(fieldValueObj, fieldType);
            if (nodeValue != null) {
                fieldNodes.add(ObjectField.newObjectField().name(fieldName).value(nodeValue).build());
            }
        });
        return ObjectValue.newObjectValue().objectFields(fieldNodes).build();
    }

    private static Value<?> handleNumberLegacy(String stringValue) {
        if (stringValue.matches("^[0-9]+$")) {
            return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
        }
        return FloatValue.newFloatValue().value(new BigDecimal(stringValue)).build();
    }

    private static Value<?> handleListLegacy(Object value, GraphQLList type) {
        GraphQLType itemType = type.getWrappedType();
        if (FpKit.isIterable(value)) {
            List<Value> valuesNodes = FpKit.toListOrSingletonList(value).stream().map(item -> ValuesResolver.valueToLiteralLegacy(item, itemType)).collect(Collectors.toList());
            return ArrayValue.newArrayValue().values(valuesNodes).build();
        }
        return ValuesResolver.valueToLiteralLegacy(value, itemType);
    }

    private static Value<?> handleNonNullLegacy(Object _value, GraphQLNonNull type) {
        GraphQLType wrappedType = type.getWrappedType();
        return ValuesResolver.valueToLiteralLegacy(_value, wrappedType);
    }

    private static Object serializeLegacy(GraphQLType type, Object value) {
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().serialize(value);
        }
        return ((GraphQLEnumType)type).serialize(value);
    }

    private static boolean isNullishLegacy(Object serialized) {
        if (serialized instanceof Number) {
            return Double.isNaN(((Number)serialized).doubleValue());
        }
        return serialized == null;
    }

    private static boolean isVariableAbsent(Value value, Map<String, NormalizedInputValue> variables) {
        if (value instanceof VariableReference) {
            VariableReference varRef = (VariableReference)value;
            return !variables.containsKey(varRef.getName());
        }
        return false;
    }

    public static enum ValueMode {
        LITERAL,
        NORMALIZED;

    }
}

