/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio;

import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.ByteString;
import com.apollographql.relocated.okio.ForwardingSource;
import com.apollographql.relocated.okio.Segment;
import com.apollographql.relocated.okio.Source;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u0011\u0010\u0010\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/apollographql/relocated/okio/HashingSource;", "Lcom/apollographql/relocated/okio/ForwardingSource;", "Lcom/apollographql/relocated/okio/Source;", "source", "digest", "Ljava/security/MessageDigest;", "(Lokio/Source;Ljava/security/MessageDigest;)V", "algorithm", "", "(Lokio/Source;Ljava/lang/String;)V", "mac", "Ljavax/crypto/Mac;", "(Lokio/Source;Ljavax/crypto/Mac;)V", "key", "Lcom/apollographql/relocated/okio/ByteString;", "(Lokio/Source;Lokio/ByteString;Ljava/lang/String;)V", "hash", "()Lokio/ByteString;", "messageDigest", "-deprecated_hash", "read", "", "sink", "Lcom/apollographql/relocated/okio/Buffer;", "byteCount", "Companion", "com.apollographql.relocated.okio"})
public final class HashingSource
extends ForwardingSource
implements Source {
    private final MessageDigest messageDigest;
    private final Mac mac;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        long result = super.read(sink2, byteCount);
        if (result != -1L) {
            long offset;
            long start = sink2.size() - result;
            Segment segment = sink2.head;
            Intrinsics.checkNotNull((Object)segment);
            Segment s2 = segment;
            for (offset = sink2.size(); offset > start; offset -= (long)(s2.limit - s2.pos)) {
                Intrinsics.checkNotNull((Object)s2.prev);
            }
            while (offset < sink2.size()) {
                int pos = (int)((long)s2.pos + start - offset);
                if (this.messageDigest != null) {
                    this.messageDigest.update(s2.data, pos, s2.limit - pos);
                } else {
                    Mac mac = this.mac;
                    Intrinsics.checkNotNull((Object)mac);
                    mac.update(s2.data, pos, s2.limit - pos);
                }
                start = offset += (long)(s2.limit - s2.pos);
                Intrinsics.checkNotNull((Object)s2.next);
            }
        }
        return result;
    }

    @JvmName(name="hash")
    @NotNull
    public final ByteString hash() {
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull((Object)mac);
            byArray = mac.doFinal();
        }
        byte[] result = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return new ByteString(result);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="hash"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    @NotNull
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    public HashingSource(@NotNull Source source2, @NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super(source2);
        this.messageDigest = digest;
        this.mac = null;
    }

    public HashingSource(@NotNull Source source2, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"MessageDigest.getInstance(algorithm)");
        this(source2, messageDigest);
    }

    public HashingSource(@NotNull Source source2, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(source2);
        this.mac = mac;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSource(@NotNull Source source2, @NotNull ByteString key, @NotNull String algorithm) {
        Source source3;
        HashingSource hashingSource;
        Mac mac;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Source source4 = source2;
        HashingSource hashingSource2 = this;
        try {
            void $this$apply;
            mac = Mac.getInstance(algorithm);
            boolean bl = false;
            boolean bl2 = false;
            Mac mac2 = mac;
            Source source5 = source4;
            HashingSource hashingSource3 = hashingSource2;
            boolean bl3 = false;
            $this$apply.init(new SecretKeySpec(key.toByteArray(), algorithm));
            Unit unit = Unit.INSTANCE;
            hashingSource = hashingSource3;
            source3 = source5;
        }
        catch (InvalidKeyException invalidKeyException) {
            void e;
            HashingSource hashingSource4 = hashingSource2;
            Source source6 = source4;
            throw (Throwable)new IllegalArgumentException((Throwable)e);
        }
        Mac mac3 = mac;
        Intrinsics.checkNotNullExpressionValue((Object)mac3, (String)"try {\n      Mac.getInsta\u2026rgumentException(e)\n    }");
        hashingSource(source3, mac3);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource md5(@NotNull Source source2) {
        return Companion.md5(source2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha1(@NotNull Source source2) {
        return Companion.sha1(source2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha256(@NotNull Source source2) {
        return Companion.sha256(source2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource sha512(@NotNull Source source2) {
        return Companion.sha512(source2);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha1(@NotNull Source source2, @NotNull ByteString key) {
        return Companion.hmacSha1(source2, key);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha256(@NotNull Source source2, @NotNull ByteString key) {
        return Companion.hmacSha256(source2, key);
    }

    @JvmStatic
    @NotNull
    public static final HashingSource hmacSha512(@NotNull Source source2, @NotNull ByteString key) {
        return Companion.hmacSha512(source2, key);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/relocated/okio/HashingSource$Companion;", "", "()V", "hmacSha1", "Lcom/apollographql/relocated/okio/HashingSource;", "source", "Lcom/apollographql/relocated/okio/Source;", "key", "Lcom/apollographql/relocated/okio/ByteString;", "hmacSha256", "hmacSha512", "md5", "sha1", "sha256", "sha512", "com.apollographql.relocated.okio"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final HashingSource md5(@NotNull Source source2) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource(source2, "MD5");
        }

        @JvmStatic
        @NotNull
        public final HashingSource sha1(@NotNull Source source2) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource(source2, "SHA-1");
        }

        @JvmStatic
        @NotNull
        public final HashingSource sha256(@NotNull Source source2) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource(source2, "SHA-256");
        }

        @JvmStatic
        @NotNull
        public final HashingSource sha512(@NotNull Source source2) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            return new HashingSource(source2, "SHA-512");
        }

        @JvmStatic
        @NotNull
        public final HashingSource hmacSha1(@NotNull Source source2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource(source2, key, "HmacSHA1");
        }

        @JvmStatic
        @NotNull
        public final HashingSource hmacSha256(@NotNull Source source2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource(source2, key, "HmacSHA256");
        }

        @JvmStatic
        @NotNull
        public final HashingSource hmacSha512(@NotNull Source source2, @NotNull ByteString key) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSource(source2, key, "HmacSHA512");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

