/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import java.util.concurrent.CompletableFuture;

@PublicApi
public class AsyncSerialExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncSerialExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncSerialExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        ExecutionStrategyInstrumentationContext executionStrategyCtx = instrumentation.beginExecutionStrategy(instrumentationParameters);
        MergedSelectionSet fields2 = parameters.getFields();
        ImmutableList<String> fieldNames = ImmutableList.copyOf(fields2.keySet());
        CompletableFuture resultsFuture = Async.eachSequentially(fieldNames, (fieldName, index, prevResults) -> {
            MergedField currentField = fields2.getSubField((String)fieldName);
            ResultPath fieldPath = parameters.getPath().segment(AsyncSerialExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.field(currentField).path(fieldPath));
            return this.resolveField(executionContext, newParameters);
        });
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        executionStrategyCtx.onDispatched(overallResult);
        resultsFuture.whenComplete(this.handleResults(executionContext, fieldNames, overallResult));
        overallResult.whenComplete(executionStrategyCtx::onCompleted);
        return overallResult;
    }
}

