/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.ResultPath;
import java.util.function.Consumer;

@PublicApi
public class ExecutionStrategyParameters {
    private final ExecutionStepInfo executionStepInfo;
    private final Object source;
    private final Object localContext;
    private final MergedSelectionSet fields;
    private final NonNullableFieldValidator nonNullableFieldValidator;
    private final ResultPath path;
    private final MergedField currentField;
    private final int listSize;
    private final int currentListIndex;
    private final ExecutionStrategyParameters parent;

    private ExecutionStrategyParameters(ExecutionStepInfo executionStepInfo, Object source2, Object localContext, MergedSelectionSet fields2, NonNullableFieldValidator nonNullableFieldValidator, ResultPath path, MergedField currentField, int listSize, int currentListIndex, ExecutionStrategyParameters parent) {
        this.executionStepInfo = Assert.assertNotNull(executionStepInfo, () -> "executionStepInfo is null");
        this.localContext = localContext;
        this.fields = Assert.assertNotNull(fields2, () -> "fields is null");
        this.source = source2;
        this.nonNullableFieldValidator = nonNullableFieldValidator;
        this.path = path;
        this.currentField = currentField;
        this.listSize = listSize;
        this.currentListIndex = currentListIndex;
        this.parent = parent;
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public Object getSource() {
        return this.source;
    }

    public MergedSelectionSet getFields() {
        return this.fields;
    }

    public NonNullableFieldValidator getNonNullFieldValidator() {
        return this.nonNullableFieldValidator;
    }

    public ResultPath getPath() {
        return this.path;
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getCurrentListIndex() {
        return this.currentListIndex;
    }

    public ExecutionStrategyParameters getParent() {
        return this.parent;
    }

    public MergedField getField() {
        return this.currentField;
    }

    public ExecutionStrategyParameters transform(Consumer<Builder> builderConsumer) {
        Builder builder = ExecutionStrategyParameters.newParameters(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return String.format("ExecutionStrategyParameters { path=%s, executionStepInfo=%s, source=%s, fields=%s }", this.path, this.executionStepInfo, this.source, this.fields);
    }

    public static Builder newParameters() {
        return new Builder();
    }

    public static Builder newParameters(ExecutionStrategyParameters oldParameters) {
        return new Builder(oldParameters);
    }

    public static class Builder {
        ExecutionStepInfo executionStepInfo;
        Object source;
        Object localContext;
        MergedSelectionSet fields;
        NonNullableFieldValidator nonNullableFieldValidator;
        ResultPath path = ResultPath.rootPath();
        MergedField currentField;
        int listSize;
        int currentListIndex;
        ExecutionStrategyParameters parent;

        private Builder() {
        }

        private Builder(ExecutionStrategyParameters oldParameters) {
            this.executionStepInfo = oldParameters.executionStepInfo;
            this.source = oldParameters.source;
            this.localContext = oldParameters.localContext;
            this.fields = oldParameters.fields;
            this.nonNullableFieldValidator = oldParameters.nonNullableFieldValidator;
            this.currentField = oldParameters.currentField;
            this.path = oldParameters.path;
            this.parent = oldParameters.parent;
            this.listSize = oldParameters.listSize;
            this.currentListIndex = oldParameters.currentListIndex;
        }

        public Builder executionStepInfo(ExecutionStepInfo executionStepInfo) {
            this.executionStepInfo = executionStepInfo;
            return this;
        }

        public Builder executionStepInfo(ExecutionStepInfo.Builder executionStepInfoBuilder) {
            this.executionStepInfo = executionStepInfoBuilder.build();
            return this;
        }

        public Builder fields(MergedSelectionSet fields2) {
            this.fields = fields2;
            return this;
        }

        public Builder field(MergedField currentField) {
            this.currentField = currentField;
            return this;
        }

        public Builder source(Object source2) {
            this.source = source2;
            return this;
        }

        public Builder localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public Builder nonNullFieldValidator(NonNullableFieldValidator nonNullableFieldValidator) {
            this.nonNullableFieldValidator = Assert.assertNotNull(nonNullableFieldValidator, () -> "requires a NonNullValidator");
            return this;
        }

        public Builder path(ResultPath path) {
            this.path = path;
            return this;
        }

        public Builder listSize(int listSize) {
            this.listSize = listSize;
            return this;
        }

        public Builder currentListIndex(int currentListIndex) {
            this.currentListIndex = currentListIndex;
            return this;
        }

        public Builder parent(ExecutionStrategyParameters parent) {
            this.parent = parent;
            return this;
        }

        public ExecutionStrategyParameters build() {
            return new ExecutionStrategyParameters(this.executionStepInfo, this.source, this.localContext, this.fields, this.nonNullableFieldValidator, this.path, this.currentField, this.listSize, this.currentListIndex, this.parent);
        }
    }
}

