/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.Mutable;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.Argument;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
@Mutable
public class ExecutableNormalizedField {
    private final String alias;
    private final ImmutableMap<String, NormalizedInputValue> normalizedArguments;
    private final LinkedHashMap<String, Object> resolvedArguments;
    private final ImmutableList<Argument> astArguments;
    private final LinkedHashSet<String> objectTypeNames;
    private final ArrayList<ExecutableNormalizedField> children;
    private ExecutableNormalizedField parent;
    private final String fieldName;
    private final int level;

    private ExecutableNormalizedField(Builder builder) {
        this.alias = builder.alias;
        this.resolvedArguments = builder.resolvedArguments;
        this.normalizedArguments = builder.normalizedArguments;
        this.astArguments = builder.astArguments;
        this.objectTypeNames = builder.objectTypeNames;
        this.fieldName = Assert.assertNotNull(builder.fieldName);
        this.children = builder.children;
        this.level = builder.level;
        this.parent = builder.parent;
    }

    public boolean isConditional(GraphQLSchema schema) {
        if (this.parent == null) {
            return false;
        }
        return this.objectTypeNames.size() > 1 || GraphQLTypeUtil.unwrapAll(this.parent.getType(schema)) != this.getOneObjectType(schema);
    }

    public GraphQLOutputType getType(GraphQLSchema schema) {
        return this.getOneFieldDefinition(schema).getType();
    }

    public GraphQLFieldDefinition getOneFieldDefinition(GraphQLSchema schema) {
        GraphQLFieldDefinition introspectionField = ExecutableNormalizedField.resolveIntrospectionField(this.fieldName, schema);
        if (introspectionField != null) {
            return introspectionField;
        }
        GraphQLObjectType type = (GraphQLObjectType)Assert.assertNotNull(schema.getType((String)this.objectTypeNames.iterator().next()));
        GraphQLFieldDefinition fieldDefinition = Assert.assertNotNull(type.getField(this.fieldName), () -> String.format("no field %s found for type %s", this.fieldName, this.objectTypeNames.iterator().next()));
        return fieldDefinition;
    }

    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLSchema schema) {
        GraphQLFieldDefinition fieldDefinition = ExecutableNormalizedField.resolveIntrospectionField(this.fieldName, schema);
        if (fieldDefinition != null) {
            return ImmutableList.of(fieldDefinition);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String objectTypeName : this.objectTypeNames) {
            GraphQLObjectType type = (GraphQLObjectType)Assert.assertNotNull(schema.getType(objectTypeName));
            builder.add(Assert.assertNotNull(type.getField(this.fieldName), () -> String.format("no field %s found for type %s", this.fieldName, this.objectTypeNames.iterator().next())));
        }
        return builder.build();
    }

    private static GraphQLFieldDefinition resolveIntrospectionField(String fieldName, GraphQLSchema schema) {
        if (fieldName.equals(schema.getIntrospectionTypenameFieldDefinition().getName())) {
            return schema.getIntrospectionTypenameFieldDefinition();
        }
        if (fieldName.equals(schema.getIntrospectionSchemaFieldDefinition().getName())) {
            return schema.getIntrospectionSchemaFieldDefinition();
        }
        if (fieldName.equals(schema.getIntrospectionTypeFieldDefinition().getName())) {
            return schema.getIntrospectionTypeFieldDefinition();
        }
        return null;
    }

    public void addObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.addAll(objectTypeNames);
    }

    public void setObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.clear();
        this.objectTypeNames.addAll(objectTypeNames);
    }

    public void addChild(ExecutableNormalizedField executableNormalizedField) {
        this.children.add(executableNormalizedField);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public String getName() {
        return this.getFieldName();
    }

    public String getResultKey() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public ImmutableList<Argument> getAstArguments() {
        return this.astArguments;
    }

    public NormalizedInputValue getNormalizedArgument(String name) {
        return this.normalizedArguments.get(name);
    }

    public ImmutableMap<String, NormalizedInputValue> getNormalizedArguments() {
        return this.normalizedArguments;
    }

    public LinkedHashMap<String, Object> getResolvedArguments() {
        return this.resolvedArguments;
    }

    public static Builder newNormalizedField() {
        return new Builder();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ExecutableNormalizedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public Set<String> getObjectTypeNames() {
        return this.objectTypeNames;
    }

    public String getSingleObjectTypeName() {
        return (String)this.objectTypeNames.iterator().next();
    }

    public GraphQLObjectType getOneObjectType(GraphQLSchema schema) {
        return (GraphQLObjectType)schema.getType((String)this.objectTypeNames.iterator().next());
    }

    public String printDetails() {
        StringBuilder result = new StringBuilder();
        if (this.getAlias() != null) {
            result.append(this.getAlias()).append(": ");
        }
        return result + this.objectTypeNamesToString() + "." + this.fieldName;
    }

    public String objectTypeNamesToString() {
        if (this.objectTypeNames.size() == 1) {
            return (String)this.objectTypeNames.iterator().next();
        }
        return this.objectTypeNames.toString();
    }

    public List<String> getListOfResultKeys() {
        LinkedList<String> list = new LinkedList<String>();
        ExecutableNormalizedField current = this;
        while (current != null) {
            list.addFirst(current.getResultKey());
            current = current.parent;
        }
        return list;
    }

    public List<ExecutableNormalizedField> getChildren() {
        return this.children;
    }

    public List<ExecutableNormalizedField> getChildrenWithSameResultKey(String resultKey) {
        return FpKit.filterList(this.children, child -> child.getResultKey().equals(resultKey));
    }

    public int getLevel() {
        return this.level;
    }

    public ExecutableNormalizedField getParent() {
        return this.parent;
    }

    public void replaceParent(ExecutableNormalizedField newParent) {
        this.parent = newParent;
    }

    public String toString() {
        return "NormalizedField{" + this.objectTypeNamesToString() + "." + this.fieldName + ", alias=" + this.alias + ", level=" + this.level + ", children=" + this.children.stream().map(ExecutableNormalizedField::toString).collect(Collectors.joining("\n")) + '}';
    }

    public List<ExecutableNormalizedField> getChildren(int includingRelativeLevel) {
        ArrayList<ExecutableNormalizedField> result = new ArrayList<ExecutableNormalizedField>();
        Assert.assertTrue(includingRelativeLevel >= 1, () -> "relative level must be >= 1");
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, result::add, 1, includingRelativeLevel));
        return result;
    }

    public void traverseSubTree(Consumer<ExecutableNormalizedField> consumer) {
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, 1, Integer.MAX_VALUE));
    }

    private void traverseImpl(ExecutableNormalizedField root, Consumer<ExecutableNormalizedField> consumer, int curRelativeLevel, int abortAfter) {
        if (curRelativeLevel > abortAfter) {
            return;
        }
        consumer.accept(root);
        root.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, curRelativeLevel + 1, abortAfter));
    }

    public static class Builder {
        private LinkedHashSet<String> objectTypeNames = new LinkedHashSet();
        private String fieldName;
        private ArrayList<ExecutableNormalizedField> children = new ArrayList();
        private int level;
        private ExecutableNormalizedField parent;
        private String alias;
        private ImmutableMap<String, NormalizedInputValue> normalizedArguments = ImmutableKit.emptyMap();
        private LinkedHashMap<String, Object> resolvedArguments = new LinkedHashMap();
        private ImmutableList<Argument> astArguments = ImmutableKit.emptyList();

        private Builder() {
        }

        private Builder(ExecutableNormalizedField existing) {
            this.alias = existing.alias;
            this.normalizedArguments = existing.normalizedArguments;
            this.astArguments = existing.astArguments;
            this.resolvedArguments = existing.resolvedArguments;
            this.objectTypeNames = new LinkedHashSet<String>(existing.getObjectTypeNames());
            this.fieldName = existing.getFieldName();
            this.children = new ArrayList(existing.children);
            this.level = existing.getLevel();
            this.parent = existing.getParent();
        }

        public Builder clearObjectTypesNames() {
            this.objectTypeNames.clear();
            return this;
        }

        public Builder objectTypeNames(List<String> objectTypeNames) {
            this.objectTypeNames.addAll(objectTypeNames);
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder normalizedArguments(@Nullable Map<String, NormalizedInputValue> arguments2) {
            this.normalizedArguments = arguments2 == null ? ImmutableKit.emptyMap() : ImmutableMap.copyOf(arguments2);
            return this;
        }

        public Builder resolvedArguments(@Nullable Map<String, Object> arguments2) {
            this.resolvedArguments = arguments2 == null ? new LinkedHashMap() : new LinkedHashMap<String, Object>(arguments2);
            return this;
        }

        public Builder astArguments(@NotNull List<Argument> astArguments) {
            this.astArguments = ImmutableList.copyOf(astArguments);
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder children(List<ExecutableNormalizedField> children) {
            this.children.clear();
            this.children.addAll(children);
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder parent(ExecutableNormalizedField parent) {
            this.parent = parent;
            return this;
        }

        public ExecutableNormalizedField build() {
            return new ExecutableNormalizedField(this);
        }
    }
}

