/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class ExecutableNormalizedOperationToAstCompiler {
    public static Document compileToDocument(OperationDefinition.Operation operationKind, String operationName, List<ExecutableNormalizedField> topLevelFields) {
        List<Selection<?>> selections = ExecutableNormalizedOperationToAstCompiler.selectionsForNormalizedFields(topLevelFields);
        SelectionSet selectionSet = new SelectionSet(selections);
        return Document.newDocument().definition(OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind).selectionSet(selectionSet).build()).build();
    }

    private static List<Selection<?>> selectionsForNormalizedFields(List<ExecutableNormalizedField> executableNormalizedFields) {
        ImmutableList.Builder result = ImmutableList.builder();
        LinkedHashMap<String, List> overallGroupedFields = new LinkedHashMap<String, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            Map<String, List<Field>> groupFieldsForChild = ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(nf);
            groupFieldsForChild.forEach((objectTypeName, fields2) -> {
                List fieldList = overallGroupedFields.computeIfAbsent((String)objectTypeName, ignored -> new ArrayList());
                fieldList.addAll(fields2);
            });
        }
        overallGroupedFields.forEach((objectTypeName, fields2) -> {
            TypeName typeName = TypeName.newTypeName(objectTypeName).build();
            InlineFragment inlineFragment = InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields2)).build();
            result.add(inlineFragment);
        });
        return result.build();
    }

    private static Map<String, List<Field>> selectionForNormalizedField(ExecutableNormalizedField executableNormalizedField) {
        LinkedHashMap<String, List<Field>> groupedFields = new LinkedHashMap<String, List<Field>>();
        for (String objectTypeName : executableNormalizedField.getObjectTypeNames()) {
            List<Selection<?>> subSelections = ExecutableNormalizedOperationToAstCompiler.selectionsForNormalizedFields(executableNormalizedField.getChildren());
            SelectionSet selectionSet = null;
            if (subSelections.size() > 0) {
                selectionSet = SelectionSet.newSelectionSet().selections(subSelections).build();
            }
            List<Argument> arguments2 = ExecutableNormalizedOperationToAstCompiler.createArguments(executableNormalizedField);
            Field field = Field.newField().name(executableNormalizedField.getFieldName()).alias(executableNormalizedField.getAlias()).selectionSet(selectionSet).arguments(arguments2).build();
            groupedFields.computeIfAbsent(objectTypeName, ignored -> new ArrayList()).add(field);
        }
        return groupedFields;
    }

    private static SelectionSet selectionSet(List<Field> fields2) {
        return SelectionSet.newSelectionSet().selections(fields2).build();
    }

    private static List<Argument> createArguments(ExecutableNormalizedField executableNormalizedField) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap<String, NormalizedInputValue> normalizedArguments = executableNormalizedField.getNormalizedArguments();
        for (String argName : normalizedArguments.keySet()) {
            Argument argument = Argument.newArgument().name(argName).value(ExecutableNormalizedOperationToAstCompiler.argValue(normalizedArguments.get(argName).getValue())).build();
            result.add(argument);
        }
        return result.build();
    }

    private static Value<?> argValue(Object value) {
        if (value instanceof List) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            arrayValue.values(ImmutableKit.map((List)value, ExecutableNormalizedOperationToAstCompiler::argValue));
            return arrayValue.build();
        }
        if (value instanceof Map) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            Map map = (Map)value;
            for (String fieldName : map.keySet()) {
                Value<?> fieldValue = ExecutableNormalizedOperationToAstCompiler.argValue(((NormalizedInputValue)map.get(fieldName)).getValue());
                objectValue.objectField(ObjectField.newObjectField().name(fieldName).value(fieldValue).build());
            }
            return objectValue.build();
        }
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        return (Value)value;
    }
}

