/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphqlTypeComparatorEnvironment;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.GraphqlTypeComparators;
import graphql.util.FpKit;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Internal
public abstract class GraphqlTypeBuilder {
    protected String name;
    protected String description;
    protected GraphqlTypeComparatorRegistry comparatorRegistry = GraphqlTypeComparatorRegistry.AS_IS_REGISTRY;

    GraphqlTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    GraphqlTypeBuilder description(String description2) {
        this.description = description2;
        return this;
    }

    GraphqlTypeBuilder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
        this.comparatorRegistry = comparatorRegistry;
        return this;
    }

    <T extends GraphQLSchemaElement> List<T> sort(Map<String, T> types, Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLSchemaElement> elementType) {
        return this.sort(FpKit.valuesToList(types), parentType, elementType);
    }

    <T extends GraphQLSchemaElement> List<T> sort(List<T> types, Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLSchemaElement> elementType) {
        Comparator<? super GraphQLSchemaElement> comparator = GraphqlTypeBuilder.getComparatorImpl(this.comparatorRegistry, parentType, elementType);
        return ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(comparator, types));
    }

    Comparator<? super GraphQLSchemaElement> getComparator(Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLNamedSchemaElement> elementType) {
        return GraphqlTypeBuilder.getComparatorImpl(this.comparatorRegistry, parentType, elementType);
    }

    private static Comparator<? super GraphQLSchemaElement> getComparatorImpl(GraphqlTypeComparatorRegistry comparatorRegistry, Class<? extends GraphQLSchemaElement> parentType, Class<? extends GraphQLSchemaElement> elementType) {
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(parentType).elementType(elementType).build();
        return comparatorRegistry.getComparator(environment);
    }
}

