/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.com.squareup.moshi.adapters;

import com.apollographql.relocated.com.squareup.moshi.JsonAdapter;
import com.apollographql.relocated.com.squareup.moshi.JsonReader;
import com.apollographql.relocated.com.squareup.moshi.JsonWriter;
import com.apollographql.relocated.com.squareup.moshi.adapters.Iso8601Utils;
import java.io.IOException;
import java.util.Date;

public final class Rfc3339DateJsonAdapter
extends JsonAdapter<Date> {
    @Override
    public synchronized Date fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Date)reader.nextNull();
        }
        String string = reader.nextString();
        return Iso8601Utils.parse(string);
    }

    @Override
    public synchronized void toJson(JsonWriter writer, Date value) throws IOException {
        if (value == null) {
            writer.nullValue();
        } else {
            String string = Iso8601Utils.format(value);
            writer.value(string);
        }
    }
}

