/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloSubscriptionCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.internal.CallState;
import com.apollographql.apollo.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class RealApolloSubscriptionCall<T>
implements ApolloSubscriptionCall<T> {
    private final Subscription<?, T, ?> subscription;
    private final SubscriptionManager subscriptionManager;
    private final AtomicReference<CallState> state = new AtomicReference<CallState>(CallState.IDLE);
    private SubscriptionManagerCallback<T> subscriptionCallback;

    public RealApolloSubscriptionCall(Subscription<?, T, ?> subscription, SubscriptionManager subscriptionManager) {
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull ApolloSubscriptionCall.Callback<T> callback) throws ApolloCanceledException {
        Utils.checkNotNull(callback, (Object)"callback == null");
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.ACTIVE);
                    this.subscriptionCallback = new SubscriptionManagerCallback<T>(callback, this);
                    this.subscriptionManager.subscribe(this.subscription, this.subscriptionCallback);
                    break;
                }
                case CANCELED: {
                    throw new ApolloCanceledException("Call is cancelled.");
                }
                case TERMINATED: 
                case ACTIVE: {
                    throw new IllegalStateException("Already Executed");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case IDLE: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case ACTIVE: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                        this.subscriptionCallback.release();
                    }
                }
                case CANCELED: 
                case TERMINATED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    @Override
    public ApolloSubscriptionCall<T> clone() {
        return new RealApolloSubscriptionCall<T>(this.subscription, this.subscriptionManager);
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        RealApolloSubscriptionCall realApolloSubscriptionCall = this;
        synchronized (realApolloSubscriptionCall) {
            switch (this.state.get()) {
                case ACTIVE: {
                    this.state.set(CallState.TERMINATED);
                    this.subscriptionCallback.release();
                    break;
                }
                case CANCELED: {
                    break;
                }
                case IDLE: 
                case TERMINATED: {
                    throw new IllegalStateException(CallState.IllegalStateMessage.forCurrentState(this.state.get()).expected(CallState.ACTIVE, CallState.CANCELED));
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
        }
    }

    private static final class SubscriptionManagerCallback<T>
    implements SubscriptionManager.Callback<T> {
        private ApolloSubscriptionCall.Callback<T> originalCallback;
        private RealApolloSubscriptionCall<T> delegate;

        SubscriptionManagerCallback(ApolloSubscriptionCall.Callback<T> originalCallback, RealApolloSubscriptionCall<T> delegate) {
            this.originalCallback = originalCallback;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(@NotNull Response<T> response) {
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onResponse(response);
            }
        }

        @Override
        public void onError(@NotNull ApolloSubscriptionException error) {
            RealApolloSubscriptionCall<T> delegate;
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onFailure(error);
            }
            if ((delegate = this.delegate) != null) {
                ((RealApolloSubscriptionCall)delegate).terminate();
            }
        }

        @Override
        public void onNetworkError(@NotNull Throwable t) {
            RealApolloSubscriptionCall<T> delegate;
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onFailure(new ApolloNetworkException("Subscription failed", t));
            }
            if ((delegate = this.delegate) != null) {
                ((RealApolloSubscriptionCall)delegate).terminate();
            }
        }

        @Override
        public void onCompleted() {
            RealApolloSubscriptionCall<T> delegate;
            ApolloSubscriptionCall.Callback<T> callback = this.originalCallback;
            if (callback != null) {
                callback.onCompleted();
            }
            if ((delegate = this.delegate) != null) {
                ((RealApolloSubscriptionCall)delegate).terminate();
            }
        }

        void release() {
            this.originalCallback = null;
            this.delegate = null;
        }
    }
}

