/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public final class CacheAndNetworkFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheAndNetworkInterceptor();
    }

    private static final class CacheAndNetworkInterceptor
    implements ApolloInterceptor {
        private Optional<ApolloInterceptor.InterceptorResponse> cacheResponse = Optional.absent();
        private Optional<ApolloInterceptor.InterceptorResponse> networkResponse = Optional.absent();
        private Optional<ApolloException> cacheException = Optional.absent();
        private Optional<ApolloException> networkException = Optional.absent();
        private boolean dispatchedCacheResult;
        private ApolloInterceptor.CallBack originalCallback;
        private volatile boolean disposed;

        private CacheAndNetworkInterceptor() {
        }

        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
            if (this.disposed) {
                return;
            }
            this.originalCallback = callBack;
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    CacheAndNetworkInterceptor.this.handleCacheResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    CacheAndNetworkInterceptor.this.handleCacheError(e);
                }

                @Override
                public void onCompleted() {
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
            ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
            chain.proceedAsync(networkRequest, dispatcher, new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    CacheAndNetworkInterceptor.this.handleNetworkResponse(response);
                }

                @Override
                public void onFailure(@NotNull ApolloException e) {
                    CacheAndNetworkInterceptor.this.handleNetworkError(e);
                }

                @Override
                public void onCompleted() {
                }

                @Override
                public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                    callBack.onFetch(sourceType);
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        synchronized void handleNetworkResponse(ApolloInterceptor.InterceptorResponse response) {
            this.networkResponse = Optional.of((Object)response);
            this.dispatch();
        }

        synchronized void handleNetworkError(ApolloException exception) {
            this.networkException = Optional.of((Object)exception);
            this.dispatch();
        }

        synchronized void handleCacheResponse(ApolloInterceptor.InterceptorResponse response) {
            this.cacheResponse = Optional.of((Object)response);
            this.dispatch();
        }

        synchronized void handleCacheError(ApolloException exception) {
            this.cacheException = Optional.of((Object)exception);
            this.dispatch();
        }

        private synchronized void dispatch() {
            if (this.disposed) {
                return;
            }
            if (!this.dispatchedCacheResult) {
                if (this.cacheResponse.isPresent()) {
                    this.originalCallback.onResponse((ApolloInterceptor.InterceptorResponse)this.cacheResponse.get());
                    this.dispatchedCacheResult = true;
                } else if (this.cacheException.isPresent()) {
                    this.dispatchedCacheResult = true;
                }
            }
            if (this.dispatchedCacheResult) {
                if (this.networkResponse.isPresent()) {
                    this.originalCallback.onResponse((ApolloInterceptor.InterceptorResponse)this.networkResponse.get());
                    this.originalCallback.onCompleted();
                } else if (this.networkException.isPresent()) {
                    if (this.cacheException.isPresent()) {
                        this.originalCallback.onFailure((ApolloException)this.networkException.get());
                    } else {
                        this.originalCallback.onCompleted();
                    }
                }
            }
        }
    }
}

