/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.InputFieldWriter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloLogger;
import com.apollographql.apollo.internal.json.InputFieldJsonWriter;
import com.apollographql.apollo.internal.json.JsonWriter;
import com.apollographql.apollo.response.ScalarTypeAdapters;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApolloServerInterceptor
implements ApolloInterceptor {
    static final String HEADER_ACCEPT_TYPE = "Accept";
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_APOLLO_OPERATION_ID = "X-APOLLO-OPERATION-ID";
    static final String HEADER_APOLLO_OPERATION_NAME = "X-APOLLO-OPERATION-NAME";
    static final String ACCEPT_TYPE = "application/json";
    static final String CONTENT_TYPE = "application/json";
    static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final Optional<HttpCachePolicy.Policy> cachePolicy;
    final boolean prefetch;
    final ApolloLogger logger;
    final ScalarTypeAdapters scalarTypeAdapters;
    volatile Call httpCall;
    volatile boolean disposed;

    public ApolloServerInterceptor(@NotNull HttpUrl serverUrl, @NotNull Call.Factory httpCallFactory, @Nullable HttpCachePolicy.Policy cachePolicy, boolean prefetch, @NotNull ScalarTypeAdapters scalarTypeAdapters, @NotNull ApolloLogger logger) {
        this.serverUrl = (HttpUrl)Utils.checkNotNull((Object)serverUrl, (Object)"serverUrl == null");
        this.httpCallFactory = (Call.Factory)Utils.checkNotNull((Object)httpCallFactory, (Object)"httpCallFactory == null");
        this.cachePolicy = Optional.fromNullable((Object)cachePolicy);
        this.prefetch = prefetch;
        this.scalarTypeAdapters = (ScalarTypeAdapters)Utils.checkNotNull((Object)scalarTypeAdapters, (Object)"scalarTypeAdapters == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                callBack.onFetch(ApolloInterceptor.FetchSourceType.NETWORK);
                try {
                    ApolloServerInterceptor.this.httpCall = ApolloServerInterceptor.this.httpCall(request.operation, request.cacheHeaders, request.sendQueryDocument);
                }
                catch (IOException e) {
                    ApolloServerInterceptor.this.logger.e((Throwable)e, "Failed to prepare http call for operation %s", new Object[]{request.operation.name().name()});
                    callBack.onFailure(new ApolloNetworkException("Failed to prepare http call", e));
                    return;
                }
                ApolloServerInterceptor.this.httpCall.enqueue(new Callback(){

                    public void onFailure(@NotNull Call call, @NotNull IOException e) {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        ApolloServerInterceptor.this.logger.e((Throwable)e, "Failed to execute http call for operation %s", new Object[]{request.operation.name().name()});
                        callBack.onFailure(new ApolloNetworkException("Failed to execute http call", e));
                    }

                    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                        if (ApolloServerInterceptor.this.disposed) {
                            return;
                        }
                        callBack.onResponse(new ApolloInterceptor.InterceptorResponse(response));
                        callBack.onCompleted();
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
        Call httpCall = this.httpCall;
        if (httpCall != null) {
            httpCall.cancel();
        }
        this.httpCall = null;
    }

    Call httpCall(Operation operation, CacheHeaders cacheHeaders, boolean writeQueryDocument) throws IOException {
        RequestBody requestBody = RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)ApolloServerInterceptor.httpRequestBody(operation, this.scalarTypeAdapters, writeQueryDocument));
        Request.Builder requestBuilder = new Request.Builder().url(this.serverUrl).post(requestBody).header(HEADER_ACCEPT_TYPE, "application/json").header(HEADER_CONTENT_TYPE, "application/json").header(HEADER_APOLLO_OPERATION_ID, operation.operationId()).header(HEADER_APOLLO_OPERATION_NAME, operation.name().name()).tag((Object)operation.operationId());
        if (this.cachePolicy.isPresent()) {
            HttpCachePolicy.Policy cachePolicy = (HttpCachePolicy.Policy)this.cachePolicy.get();
            boolean skipCacheHttpResponse = "true".equalsIgnoreCase(cacheHeaders.headerValue("do-not-store"));
            String cacheKey = ApolloServerInterceptor.httpRequestBody(operation, this.scalarTypeAdapters, true).md5().hex();
            requestBuilder = requestBuilder.header("X-APOLLO-CACHE-KEY", cacheKey).header("X-APOLLO-CACHE-FETCH-STRATEGY", cachePolicy.fetchStrategy.name()).header("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(cachePolicy.expireTimeoutMs())).header("X-APOLLO-EXPIRE-AFTER-READ", Boolean.toString(cachePolicy.expireAfterRead)).header("X-APOLLO-PREFETCH", Boolean.toString(this.prefetch)).header("X-APOLLO-CACHE-DO-NOT-STORE", Boolean.toString(skipCacheHttpResponse));
        }
        return this.httpCallFactory.newCall(requestBuilder.build());
    }

    static ByteString httpRequestBody(Operation operation, ScalarTypeAdapters scalarTypeAdapters, boolean writeQueryDocument) throws IOException {
        Buffer buffer = new Buffer();
        JsonWriter jsonWriter = JsonWriter.of((BufferedSink)buffer);
        jsonWriter.setSerializeNulls(true);
        jsonWriter.beginObject();
        jsonWriter.name("operationName").value(operation.name().name());
        jsonWriter.name("variables").beginObject();
        operation.variables().marshaller().marshal((InputFieldWriter)new InputFieldJsonWriter(jsonWriter, scalarTypeAdapters));
        jsonWriter.endObject();
        jsonWriter.name("extensions").beginObject().name("persistedQuery").beginObject().name("version").value(1L).name("sha256Hash").value(operation.operationId()).endObject().endObject();
        if (writeQueryDocument) {
            jsonWriter.name("query").value(operation.queryDocument().replaceAll("\\n", ""));
        }
        jsonWriter.endObject();
        jsonWriter.close();
        return buffer.readByteString();
    }
}

