/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.subscription;

import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.subscription.OnSubscriptionManagerStateChangeListener;
import com.apollographql.apollo.subscription.SubscriptionManagerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J2\u0010\u0011\u001a\u00020\b\"\u0004\b\u0000\u0010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u0012\u0012\u0002\b\u00030\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo/internal/subscription/NoOpSubscriptionManager;", "Lcom/apollographql/apollo/internal/subscription/SubscriptionManager;", "()V", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "addOnStateChangeListener", "", "onStateChangeListener", "Lcom/apollographql/apollo/subscription/OnSubscriptionManagerStateChangeListener;", "getState", "Lcom/apollographql/apollo/subscription/SubscriptionManagerState;", "reconnect", "removeOnStateChangeListener", "start", "stop", "subscribe", "T", "subscription", "Lcom/apollographql/apollo/api/Subscription;", "callback", "Lcom/apollographql/apollo/internal/subscription/SubscriptionManager$Callback;", "unsubscribe", "apollo-runtime"})
public final class NoOpSubscriptionManager
implements SubscriptionManager {
    @NotNull
    private final String errorMessage;

    public NoOpSubscriptionManager() {
        this.errorMessage = "No `SubscriptionTransport.Factory` found, please add one to your `ApolloClient` with `ApolloClient.Builder.subscriptionTransportFactory`";
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public <T> void subscribe(@NotNull Subscription<?, T, ?> subscription, @NotNull SubscriptionManager.Callback<T> callback) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        throw new IllegalStateException(this.errorMessage);
    }

    @Override
    public void unsubscribe(@NotNull Subscription<?, ?, ?> subscription) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        throw new IllegalStateException(this.errorMessage);
    }

    @Override
    public void start() {
        throw new IllegalStateException(this.errorMessage);
    }

    @Override
    public void stop() {
        throw new IllegalStateException(this.errorMessage);
    }

    @Override
    public void reconnect() {
    }

    @Override
    @NotNull
    public SubscriptionManagerState getState() {
        return SubscriptionManagerState.DISCONNECTED;
    }

    @Override
    public void addOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)onStateChangeListener, (String)"onStateChangeListener");
        throw new IllegalStateException(this.errorMessage);
    }

    @Override
    public void removeOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)onStateChangeListener, (String)"onStateChangeListener");
        throw new IllegalStateException(this.errorMessage);
    }
}

