/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.adapter;

import com.apollographql.apollo3.api.Adapter;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.api.json.JsonWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/apollographql/apollo3/adapter/JavaOffsetDateTimeAdapter;", "Lcom/apollographql/apollo3/api/Adapter;", "Ljava/time/OffsetDateTime;", "()V", "fromJson", "reader", "Lcom/apollographql/apollo3/api/json/JsonReader;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "toJson", "", "writer", "Lcom/apollographql/apollo3/api/json/JsonWriter;", "value", "apollo-adapters"})
public final class JavaOffsetDateTimeAdapter
implements Adapter<OffsetDateTime> {
    @NotNull
    public static final JavaOffsetDateTimeAdapter INSTANCE = new JavaOffsetDateTimeAdapter();

    private JavaOffsetDateTimeAdapter() {
    }

    @NotNull
    public OffsetDateTime fromJson(@NotNull JsonReader reader, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        String string = reader.nextString();
        Intrinsics.checkNotNull((Object)string);
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(string);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"parse(reader.nextString()!!)");
        return offsetDateTime;
    }

    public void toJson(@NotNull JsonWriter writer, @NotNull CustomScalarAdapters customScalarAdapters, @NotNull OffsetDateTime value) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.format(DateTimeFor\u2026ter.ISO_OFFSET_DATE_TIME)");
        writer.value(string);
    }
}

