/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api;

import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.exception.ApolloException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001aBY\b\u0002\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019R\u0014\u0010\t\u001a\u0004\u0018\u00018\u00008\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0011\u0010\u0014\u001a\u00028\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00060\u0005j\u0002`\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "", "requestUuid", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "data", "errors", "", "Lcom/apollographql/apollo3/api/Error;", "extensions", "", "", "executionContext", "Lcom/apollographql/apollo3/api/ExecutionContext;", "(Ljava/util/UUID;Lcom/apollographql/apollo3/api/Operation;Lcom/apollographql/apollo3/api/Operation$Data;Ljava/util/List;Ljava/util/Map;Lcom/apollographql/apollo3/api/ExecutionContext;)V", "Lcom/apollographql/apollo3/api/Operation$Data;", "dataAssertNoErrors", "()Lcom/apollographql/apollo3/api/Operation$Data;", "hasErrors", "", "newBuilder", "Lcom/apollographql/apollo3/api/ApolloResponse$Builder;", "Builder", "apollo-api"})
public final class ApolloResponse<D extends Operation.Data> {
    @JvmField
    @NotNull
    public final UUID requestUuid;
    @JvmField
    @NotNull
    public final Operation<D> operation;
    @JvmField
    @Nullable
    public final D data;
    @JvmField
    @Nullable
    public final List<Error> errors;
    @JvmField
    @NotNull
    public final Map<String, Object> extensions;
    @JvmField
    @NotNull
    public final ExecutionContext executionContext;

    private ApolloResponse(UUID requestUuid, Operation<D> operation, D data, List<Error> errors, Map<String, ? extends Object> extensions, ExecutionContext executionContext) {
        this.requestUuid = requestUuid;
        this.operation = operation;
        this.data = data;
        this.errors = errors;
        this.extensions = extensions;
        this.executionContext = executionContext;
    }

    @JvmName(name="dataAssertNoErrors")
    @NotNull
    public final D dataAssertNoErrors() {
        if (this.hasErrors()) {
            throw new ApolloException(Intrinsics.stringPlus((String)"The response has errors: ", this.errors), null, 2, null);
        }
        D d = this.data;
        if (d == null) {
            throw new ApolloException("The server did not return any data", null, 2, null);
        }
        return d;
    }

    public final boolean hasErrors() {
        Collection collection = this.errors;
        return !(collection == null || collection.isEmpty());
    }

    @NotNull
    public final Builder<D> newBuilder() {
        return new Builder<D>(this.operation, this.requestUuid, this.data).errors(this.errors).extensions(this.extensions).addExecutionContext(this.executionContext);
    }

    public /* synthetic */ ApolloResponse(UUID requestUuid, Operation operation, Operation.Data data, List errors, Map extensions, ExecutionContext executionContext, DefaultConstructorMarker $constructor_marker) {
        this(requestUuid, operation, data, errors, extensions, executionContext);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0012J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bR\u0012\u0010\t\u001a\u0004\u0018\u00018\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/api/ApolloResponse$Builder;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "", "operation", "Lcom/apollographql/apollo3/api/Operation;", "requestUuid", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "data", "(Lcom/apollographql/apollo3/api/Operation;Ljava/util/UUID;Lcom/apollographql/apollo3/api/Operation$Data;)V", "Lcom/apollographql/apollo3/api/Operation$Data;", "errors", "", "Lcom/apollographql/apollo3/api/Error;", "executionContext", "Lcom/apollographql/apollo3/api/ExecutionContext;", "extensions", "", "", "addExecutionContext", "build", "Lcom/apollographql/apollo3/api/ApolloResponse;", "apollo-api"})
    public static final class Builder<D extends Operation.Data> {
        @NotNull
        private final Operation<D> operation;
        @NotNull
        private UUID requestUuid;
        @Nullable
        private final D data;
        @NotNull
        private ExecutionContext executionContext;
        @Nullable
        private List<Error> errors;
        @Nullable
        private Map<String, ? extends Object> extensions;

        public Builder(@NotNull Operation<D> operation, @NotNull UUID requestUuid, @Nullable D data) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)requestUuid, (String)"requestUuid");
            this.operation = operation;
            this.requestUuid = requestUuid;
            this.data = data;
            this.executionContext = ExecutionContext.Empty;
        }

        @NotNull
        public final Builder<D> addExecutionContext(@NotNull ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Builder $this$addExecutionContext_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$addExecutionContext_u24lambda_u2d0.executionContext = $this$addExecutionContext_u24lambda_u2d0.executionContext.plus(executionContext);
            return builder;
        }

        @NotNull
        public final Builder<D> errors(@Nullable List<Error> errors) {
            Builder builder;
            Builder $this$errors_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$errors_u24lambda_u2d1.errors = errors;
            return builder;
        }

        @NotNull
        public final Builder<D> extensions(@Nullable Map<String, ? extends Object> extensions) {
            Builder builder;
            Builder $this$extensions_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$extensions_u24lambda_u2d2.extensions = extensions;
            return builder;
        }

        @NotNull
        public final Builder<D> requestUuid(@NotNull UUID requestUuid) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)requestUuid, (String)"requestUuid");
            Builder $this$requestUuid_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$requestUuid_u24lambda_u2d3.requestUuid = requestUuid;
            return builder;
        }

        @NotNull
        public final ApolloResponse<D> build() {
            Operation<D> operation = this.operation;
            UUID uUID = this.requestUuid;
            D d = this.data;
            ExecutionContext executionContext = this.executionContext;
            Map map = this.extensions;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            List<Error> list = this.errors;
            return new ApolloResponse(uUID, operation, (Operation.Data)d, list, map2, executionContext, null);
        }
    }
}

