/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.http;

import com.apollographql.apollo3.api.http.HttpBody;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/api/http/ByteStringHttpBody;", "Lcom/apollographql/apollo3/api/http/HttpBody;", "contentType", "", "string", "(Ljava/lang/String;Ljava/lang/String;)V", "byteString", "Lokio/ByteString;", "(Ljava/lang/String;Lokio/ByteString;)V", "contentLength", "", "getContentLength", "()J", "getContentType", "()Ljava/lang/String;", "writeTo", "", "bufferedSink", "Lokio/BufferedSink;", "apollo-api"})
public final class ByteStringHttpBody
implements HttpBody {
    @NotNull
    private final String contentType;
    @NotNull
    private final ByteString byteString;

    public ByteStringHttpBody(@NotNull String contentType, @NotNull ByteString byteString) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        this.contentType = contentType;
        this.byteString = byteString;
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    public ByteStringHttpBody(@NotNull String contentType, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this(contentType, ByteString.Companion.encodeUtf8(string));
    }

    @Override
    public long getContentLength() {
        return this.byteString.size();
    }

    @Override
    public void writeTo(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"bufferedSink");
        bufferedSink.write(this.byteString);
    }
}

