/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast;

import com.apollographql.apollo3.ast.Host_jvmKt;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.SourceLocationKt;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \f2\u00060\u0001j\u0002`\u0002:\u0001\fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/apollographql/apollo3/ast/SourceAwareException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "", "sourceLocation", "Lcom/apollographql/apollo3/ast/SourceLocation;", "(Ljava/lang/String;Lcom/apollographql/apollo3/ast/SourceLocation;)V", "getError", "()Ljava/lang/String;", "getSourceLocation", "()Lcom/apollographql/apollo3/ast/SourceLocation;", "Companion", "apollo-ast"})
public class SourceAwareException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String error;
    @Nullable
    private final SourceLocation sourceLocation;

    public SourceAwareException(@NotNull String error, @Nullable SourceLocation sourceLocation) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super(SourceAwareException.Companion.preview(error, sourceLocation));
        this.error = error;
        this.sourceLocation = sourceLocation;
    }

    @NotNull
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u001a\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/ast/SourceAwareException$Companion;", "", "()V", "formatForIdea", "", "sourceLocation", "Lcom/apollographql/apollo3/ast/SourceLocation;", "description", "preview", "error", "apollo-ast"})
    public static final class Companion {
        private Companion() {
        }

        private final String formatForIdea(SourceLocation sourceLocation, String description) {
            return "e: " + SourceLocationKt.pretty(sourceLocation) + ": " + description;
        }

        private final String preview(String error, SourceLocation sourceLocation) {
            String string;
            SourceLocation sourceLocation2 = sourceLocation;
            if ((sourceLocation2 != null ? sourceLocation2.getFilePath() : null) != null && sourceLocation.getLine() >= 1 && sourceLocation.getColumn() >= 1) {
                String string2;
                String filePath = sourceLocation.getFilePath();
                try {
                    string2 = Okio.buffer((Source)Host_jvmKt.getHOST_FILESYSTEM().source(Path.Companion.get$default((Path.Companion)Path.Companion, (String)filePath, (boolean)false, (int)1, null))).readUtf8();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read GraphQL file `" + this + '`', e);
                }
                String document = string2;
                List documentLines = StringsKt.lines((CharSequence)document);
                Companion companion = this;
                StringBuilder stringBuilder = new StringBuilder().append("\n----------------------------------------------------\n");
                boolean bl = false;
                String prefix = sourceLocation.getLine() - 2 >= 0 ? "" + '[' + (sourceLocation.getLine() - 1) + "]:" + (String)documentLines.get(sourceLocation.getLine() - 2) : "";
                String body = "\n[" + sourceLocation.getLine() + "]:" + (String)documentLines.get(sourceLocation.getLine() - 1) + '\n';
                String postfix = sourceLocation.getLine() < documentLines.size() ? "" + '[' + (sourceLocation.getLine() + 1) + "]:" + (String)documentLines.get(sourceLocation.getLine()) : "";
                string = stringBuilder.append(prefix + body + postfix).append("\n----------------------------------------------------").toString();
            } else {
                string = "";
            }
            String preview = string;
            return this.formatForIdea(sourceLocation, error + preview);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

