/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.DeprecatedUsage;
import com.apollographql.apollo3.ast.GQLBooleanValue;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValue;
import com.apollographql.apollo3.ast.GQLEnumValueDefinition;
import com.apollographql.apollo3.ast.GQLFloatValue;
import com.apollographql.apollo3.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLInputValueDefinition;
import com.apollographql.apollo3.ast.GQLIntValue;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLListValue;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectField;
import com.apollographql.apollo3.ast.GQLObjectValue;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqldirectiveKt;
import com.apollographql.apollo3.ast.GqlenumvaluedefinitionKt;
import com.apollographql.apollo3.ast.GqlnodeKt;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.OtherValidationIssue;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.VariableUsage;
import com.apollographql.apollo3.ast.internal.DefaultValidationScope;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a@\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a0\u0010\u0010\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"constContextError", "Lcom/apollographql/apollo3/ast/Issue;", "Lcom/apollographql/apollo3/ast/VariableUsage;", "validateAndCoerceValue", "Lcom/apollographql/apollo3/ast/GQLValue;", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "value", "expectedType", "Lcom/apollographql/apollo3/ast/GQLType;", "hasLocationDefaultValue", "", "isOneOfInputField", "registerVariableUsage", "Lkotlin/Function1;", "", "registerIssue", "validateAndCoerceInputObject", "expectedTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLInputObjectTypeDefinition;", "validateAndCoerceEnum", "enumTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLEnumTypeDefinition;", "validateAndCoerceScalar", "Lcom/apollographql/apollo3/ast/GQLNamedType;", "apollo-ast"})
@SourceDebugExtension(value={"SMAP\nInputValueValidationScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputValueValidationScope.kt\ncom/apollographql/apollo3/ast/internal/InputValueValidationScopeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1557#2:314\n1628#2,3:315\n1863#2:318\n295#2,2:319\n1864#2:321\n1611#2,9:322\n1863#2:331\n295#2,2:332\n1864#2:335\n1620#2:336\n295#2,2:337\n1#3:334\n*S KotlinDebug\n*F\n+ 1 InputValueValidationScope.kt\ncom/apollographql/apollo3/ast/internal/InputValueValidationScopeKt\n*L\n88#1:314\n88#1:315,3\n150#1:318\n151#1:319,2\n150#1:321\n174#1:322,9\n174#1:331\n175#1:332,2\n174#1:335\n174#1:336\n248#1:337,2\n174#1:334\n*E\n"})
public final class InputValueValidationScopeKt {
    @NotNull
    public static final Issue constContextError(@NotNull VariableUsage $this$constContextError) {
        Intrinsics.checkNotNullParameter((Object)$this$constContextError, (String)"<this>");
        return new OtherValidationIssue("Variable '" + $this$constContextError.getVariable().getName() + "' used in non-variable context", $this$constContextError.getVariable().getSourceLocation());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GQLValue validateAndCoerceValue(@NotNull ValidationScope $this$validateAndCoerceValue, @NotNull GQLValue value, @NotNull GQLType expectedType, boolean hasLocationDefaultValue, boolean isOneOfInputField, @NotNull Function1<? super VariableUsage, Unit> registerVariableUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$validateAndCoerceValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter(registerVariableUsage, (String)"registerVariableUsage");
        if (value instanceof GQLVariableValue) {
            registerVariableUsage.invoke((Object)new VariableUsage((GQLVariableValue)value, expectedType, hasLocationDefaultValue, isOneOfInputField));
            return value;
        }
        if (value instanceof GQLNullValue) {
            if (expectedType instanceof GQLNonNullType) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceValue, value, expectedType);
                return value;
            }
            return value;
        }
        GQLType gQLType = expectedType;
        if (gQLType instanceof GQLNonNullType) {
            GQLType gQLType2 = ((GQLNonNullType)expectedType).getType();
            return InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceValue, value, gQLType2, hasLocationDefaultValue, isOneOfInputField, registerVariableUsage);
        }
        if (gQLType instanceof GQLListType) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            GQLListValue coercedValue = !(value instanceof GQLListValue) ? new GQLListValue(value.getSourceLocation(), CollectionsKt.listOf((Object)value)) : (GQLListValue)value;
            Iterable iterable = coercedValue.getValues();
            SourceLocation sourceLocation = null;
            boolean $i$f$map = false;
            void var10_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GQLValue gQLValue = (GQLValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceValue, (GQLValue)it, ((GQLListType)expectedType).getType(), false, isOneOfInputField, registerVariableUsage));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 1;
            List list = (List)destination$iv$iv;
            SourceLocation sourceLocation2 = sourceLocation;
            return new GQLListValue(sourceLocation2, list, n, defaultConstructorMarker);
        }
        if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition expectedTypeDefinition = $this$validateAndCoerceValue.getTypeDefinitions().get(((GQLNamedType)expectedType).getName());
            if (expectedTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                return InputValueValidationScopeKt.validateAndCoerceInputObject($this$validateAndCoerceValue, value, (GQLInputObjectTypeDefinition)expectedTypeDefinition, registerVariableUsage);
            }
            if (expectedTypeDefinition instanceof GQLScalarTypeDefinition) {
                if (!((GQLScalarTypeDefinition)expectedTypeDefinition).isBuiltIn()) {
                    return value;
                }
                return InputValueValidationScopeKt.validateAndCoerceScalar($this$validateAndCoerceValue, value, (GQLNamedType)expectedType);
            }
            if (expectedTypeDefinition instanceof GQLEnumTypeDefinition) {
                return InputValueValidationScopeKt.validateAndCoerceEnum($this$validateAndCoerceValue, value, (GQLEnumTypeDefinition)expectedTypeDefinition);
            }
            if (expectedTypeDefinition == null) {
                $this$validateAndCoerceValue.registerIssue("Unknown type '" + GqltypeKt.pretty(expectedType) + "' for input value", value.getSourceLocation());
                return value;
            }
            $this$validateAndCoerceValue.registerIssue("Value cannot be of non-input type " + GqltypeKt.pretty(expectedType), value.getSourceLocation());
            return value;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final void registerIssue(ValidationScope $this$registerIssue, GQLValue value, GQLType expectedType) {
        $this$registerIssue.registerIssue("Value `" + GqlnodeKt.toUtf8$default(value, null, 1, null) + "` cannot be used in position expecting `" + GqltypeKt.pretty(expectedType) + '`', value.getSourceLocation());
    }

    /*
     * WARNING - void declaration
     */
    private static final GQLValue validateAndCoerceInputObject(ValidationScope $this$validateAndCoerceInputObject, GQLValue value, GQLInputObjectTypeDefinition expectedTypeDefinition, Function1<? super VariableUsage, Unit> registerVariableUsage) {
        void $this$mapNotNullTo$iv$iv;
        Object field;
        GQLNamedType expectedType = new GQLNamedType(null, expectedTypeDefinition.getName(), 1, null);
        if (!(value instanceof GQLObjectValue)) {
            InputValueValidationScopeKt.registerIssue($this$validateAndCoerceInputObject, value, expectedType);
            return value;
        }
        Iterable $this$forEach$iv = ((GQLObjectValue)value).getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            block16: {
                field = (GQLObjectField)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = expectedTypeDefinition.getInputFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLInputValueDefinition it = (GQLInputValueDefinition)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)((GQLObjectField)field).getName())) continue;
                    v0 = element$iv2;
                    break block16;
                }
                v0 = null;
            }
            if (v0 != null) continue;
            $this$validateAndCoerceInputObject.registerIssue("Field '" + ((GQLObjectField)field).getName() + "' is not an input field of type '" + GqltypeKt.pretty(expectedType) + '\'', ((GQLObjectField)field).getSourceLocation());
        }
        boolean isOneOfInputObject = GqldirectiveKt.findOneOf(expectedTypeDefinition.getDirectives());
        if (isOneOfInputObject) {
            if (((GQLObjectValue)value).getFields().size() != 1) {
                $this$validateAndCoerceInputObject.registerIssue("Exactly one field must be supplied to the OneOf input object `" + GqltypeKt.pretty(expectedType) + '`', ((GQLObjectValue)value).getSourceLocation());
            } else {
                GQLObjectField valueField = (GQLObjectField)CollectionsKt.first(((GQLObjectValue)value).getFields());
                if (valueField.getValue() instanceof GQLNullValue) {
                    $this$validateAndCoerceInputObject.registerIssue("The field `" + valueField.getName() + "` supplied to the OneOf input object `" + GqltypeKt.pretty(expectedType) + "` must not be null", ((GQLObjectValue)value).getSourceLocation());
                }
            }
        }
        Iterable $this$mapNotNull$iv = expectedTypeDefinition.getInputFields();
        boolean $i$f$mapNotNull = false;
        field = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GQLObjectField gQLObjectField;
            Object v1;
            GQLInputValueDefinition inputValueDefinition;
            block17: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                inputValueDefinition = (GQLInputValueDefinition)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = ((GQLObjectValue)value).getFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    GQLObjectField it = (GQLObjectField)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)inputValueDefinition.getName())) continue;
                    v1 = element$iv;
                    break block17;
                }
                v1 = null;
            }
            GQLObjectField field2 = v1;
            if (field2 == null) {
                if (inputValueDefinition.getDefaultValue() != null) {
                    DefaultValidationScope ignoreIssuesScope = new DefaultValidationScope($this$validateAndCoerceInputObject.getTypeDefinitions(), $this$validateAndCoerceInputObject.getDirectiveDefinitions(), null, $this$validateAndCoerceInputObject.getForeignNames());
                    gQLObjectField = new GQLObjectField(null, inputValueDefinition.getName(), InputValueValidationScopeKt.validateAndCoerceValue(ignoreIssuesScope, inputValueDefinition.getDefaultValue(), inputValueDefinition.getType(), false, false, registerVariableUsage), 1, null);
                } else if (inputValueDefinition.getType() instanceof GQLNonNullType) {
                    $this$validateAndCoerceInputObject.registerIssue("No value passed for required inputField `" + inputValueDefinition.getName() + '`', ((GQLObjectValue)value).getSourceLocation());
                    gQLObjectField = null;
                } else {
                    gQLObjectField = null;
                }
            } else {
                if (GqldirectiveKt.findDeprecationReason(inputValueDefinition.getDirectives()) != null) {
                    $this$validateAndCoerceInputObject.getIssues().add(new DeprecatedUsage("Use of deprecated input field `" + inputValueDefinition.getName() + '`', field2.getSourceLocation()));
                }
                gQLObjectField = new GQLObjectField(null, field2.getName(), InputValueValidationScopeKt.validateAndCoerceValue($this$validateAndCoerceInputObject, field2.getValue(), inputValueDefinition.getType(), inputValueDefinition.getDefaultValue() != null, isOneOfInputObject, registerVariableUsage), 1, null);
            }
            if (gQLObjectField == null) continue;
            GQLObjectField it$iv$iv = gQLObjectField;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inputFields = (List)destination$iv$iv;
        return new GQLObjectValue(null, inputFields, 1, null);
    }

    private static final GQLValue validateAndCoerceEnum(ValidationScope $this$validateAndCoerceEnum, GQLValue value, GQLEnumTypeDefinition enumTypeDefinition) {
        Object v0;
        block5: {
            GQLNamedType expectedType = new GQLNamedType(null, enumTypeDefinition.getName(), 1, null);
            if (!(value instanceof GQLEnumValue)) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceEnum, value, expectedType);
                return value;
            }
            Iterable $this$firstOrNull$iv = enumTypeDefinition.getEnumValues();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLEnumValueDefinition it = (GQLEnumValueDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)((GQLEnumValue)value).getValue())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        GQLEnumValueDefinition enumValue = v0;
        if (enumValue == null) {
            $this$validateAndCoerceEnum.registerIssue("Cannot find enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', ((GQLEnumValue)value).getSourceLocation());
        } else if (GqlenumvaluedefinitionKt.isDeprecated(enumValue)) {
            $this$validateAndCoerceEnum.getIssues().add(new DeprecatedUsage("Use of deprecated enum value `" + ((GQLEnumValue)value).getValue() + "` of type `" + enumTypeDefinition.getName() + '`', ((GQLEnumValue)value).getSourceLocation()));
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private static final GQLValue validateAndCoerceScalar(ValidationScope $this$validateAndCoerceScalar, GQLValue value, GQLNamedType expectedType) {
        block21: {
            block19: {
                block20: {
                    block18: {
                        var3_3 = expectedType.getName();
                        switch (var3_3.hashCode()) {
                            case 67973692: {
                                if (var3_3.equals("Float")) break;
                                ** break;
                            }
                            case -1808118735: {
                                if (!var3_3.equals("String")) {
                                    ** break;
                                }
                                break block18;
                            }
                            case 2331: {
                                if (!var3_3.equals("ID")) {
                                    ** break;
                                }
                                break block19;
                            }
                            case 1729365000: {
                                if (!var3_3.equals("Boolean")) {
                                    ** break;
                                }
                                break block20;
                            }
                            case 73679: {
                                if (!var3_3.equals("Int")) ** break;
                                if (!(value instanceof GQLIntValue)) {
                                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                                }
                                v0 = value;
                                break block21;
                            }
                        }
                        var4_4 = value;
                        if (var4_4 instanceof GQLFloatValue) {
                            v0 = value;
                        } else if (var4_4 instanceof GQLIntValue) {
                            v0 = new GQLFloatValue(null, ((GQLIntValue)value).getValue(), 1, null);
                        } else {
                            InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                            v0 = value;
                        }
                        break block21;
                    }
                    if (!(value instanceof GQLStringValue)) {
                        InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                    }
                    v0 = value;
                    break block21;
                }
                if (!(value instanceof GQLBooleanValue)) {
                    InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
                }
                v0 = value;
                break block21;
            }
            if (!(value instanceof GQLStringValue) && !(value instanceof GQLIntValue)) {
                InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
            }
            v0 = value;
            break block21;
lbl49:
            // 6 sources

            InputValueValidationScopeKt.registerIssue($this$validateAndCoerceScalar, value, expectedType);
            v0 = value;
        }
        return v0;
    }
}

