/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.ast.internal;

import com.apollographql.apollo3.ast.GQLArgument;
import com.apollographql.apollo3.ast.GQLArguments;
import com.apollographql.apollo3.ast.GQLBooleanValue;
import com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.ast.GQLDirective;
import com.apollographql.apollo3.ast.GQLDirectiveDefinition;
import com.apollographql.apollo3.ast.GQLDocument;
import com.apollographql.apollo3.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo3.ast.GQLEnumValue;
import com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.ast.GQLFieldDefinition;
import com.apollographql.apollo3.ast.GQLFloatValue;
import com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.ast.GQLIntValue;
import com.apollographql.apollo3.ast.GQLListType;
import com.apollographql.apollo3.ast.GQLListValue;
import com.apollographql.apollo3.ast.GQLNamedType;
import com.apollographql.apollo3.ast.GQLNonNullType;
import com.apollographql.apollo3.ast.GQLNullValue;
import com.apollographql.apollo3.ast.GQLObjectField;
import com.apollographql.apollo3.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo3.ast.GQLObjectValue;
import com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.ast.GQLSelectionSet;
import com.apollographql.apollo3.ast.GQLStringValue;
import com.apollographql.apollo3.ast.GQLType;
import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GQLValue;
import com.apollographql.apollo3.ast.GQLVariableDefinition;
import com.apollographql.apollo3.ast.GQLVariableValue;
import com.apollographql.apollo3.ast.GqldirectiveKt;
import com.apollographql.apollo3.ast.GqlfieldKt;
import com.apollographql.apollo3.ast.GqloperationdefinitionKt;
import com.apollographql.apollo3.ast.GqltypeKt;
import com.apollographql.apollo3.ast.GqltypedefinitionKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.ValidationDetails;
import com.apollographql.apollo3.ast.VariableReference;
import com.apollographql.apollo3.ast.internal.ValidationCommonKt;
import com.apollographql.apollo3.ast.internal.ValidationScope;
import com.apollographql.apollo3.ast.internal.VariableReferencesScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001MB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J$\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0018\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0016\u00103\u001a\u00020\u001a2\f\u00104\u001a\b\u0012\u0004\u0012\u0002010\"H\u0002J\u0018\u00105\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u00107\u001a\u00020\bJ\u0010\u00108\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0018\u00109\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010;\u001a\u00020<J\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u00107\u001a\u00020\bJ\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010?\u001a\u00020@J\u0018\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00100\"*\b\u0012\u0004\u0012\u00020\b0\"H\u0002J\u0018\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100\"*\b\u0012\u0004\u0012\u00020@0\"H\u0002J\u0012\u0010C\u001a\b\u0012\u0004\u0012\u0002010\"*\u00020DH\u0002J\u0012\u0010C\u001a\b\u0012\u0004\u0012\u0002010\"*\u00020EH\u0002J\u001a\u0010C\u001a\b\u0012\u0004\u0012\u0002010\"*\u00020F2\u0006\u0010G\u001a\u00020\u0007H\u0002J*\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002HJ\u0012\u0004\u0012\u0002HJ0I0\"\"\u0004\b\u0000\u0010J*\b\u0012\u0004\u0012\u0002HJ0\"H\u0002J\u0014\u0010:\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010K\u001a\u00020\u0014H\u0002J\f\u0010:\u001a\u00020\u001a*\u00020\bH\u0002J\u0014\u0010:\u001a\u00020\u001a*\u00020D2\u0006\u0010K\u001a\u00020\u0014H\u0002J\u0014\u0010:\u001a\u00020\u001a*\u00020E2\u0006\u0010K\u001a\u00020\u0014H\u0002J\f\u0010:\u001a\u00020\u001a*\u00020@H\u0002J\u0014\u0010:\u001a\u00020\u001a*\u00020F2\u0006\u0010K\u001a\u00020\u0014H\u0002J\f\u0010L\u001a\u00020\u001a*\u00020<H\u0002R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006N"}, d2={"Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope;", "Lcom/apollographql/apollo3/ast/internal/ValidationScope;", "Lcom/apollographql/apollo3/ast/internal/VariableReferencesScope;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "fragmentDefinitions", "", "", "Lcom/apollographql/apollo3/ast/GQLFragmentDefinition;", "(Lcom/apollographql/apollo3/ast/Schema;Ljava/util/Map;)V", "directiveDefinitions", "Lcom/apollographql/apollo3/ast/GQLDirectiveDefinition;", "getDirectiveDefinitions", "()Ljava/util/Map;", "issues", "", "Lcom/apollographql/apollo3/ast/Issue;", "getIssues", "()Ljava/util/List;", "typeDefinitions", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "getTypeDefinitions", "variableReferences", "Lcom/apollographql/apollo3/ast/VariableReference;", "getVariableReferences", "addFieldMergingIssue", "", "fieldA", "Lcom/apollographql/apollo3/ast/GQLField;", "fieldB", "message", "areArgumentsEqual", "", "argumentsA", "", "Lcom/apollographql/apollo3/ast/GQLArgument;", "argumentsB", "areTypesEqual", "typeA", "Lcom/apollographql/apollo3/ast/GQLType;", "typeB", "areValuesEqual", "valueA", "Lcom/apollographql/apollo3/ast/GQLValue;", "valueB", "decapitalizeFirstLetter", "name", "fieldPairCanMerge", "fieldWithParentA", "Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope$FieldWithParent;", "fieldWithParentB", "fieldsInSetCanMerge", "fieldsWithParent", "haveSameResponseShape", "inferFragmentVariables", "fragment", "isFirstLetterUpperCase", "sameResponseShapeRecursive", "validate", "document", "Lcom/apollographql/apollo3/ast/GQLDocument;", "validateFragment", "validateOperation", "operation", "Lcom/apollographql/apollo3/ast/GQLOperationDefinition;", "checkDuplicateFragments", "checkDuplicateOperations", "collectFields", "Lcom/apollographql/apollo3/ast/GQLFragmentSpread;", "Lcom/apollographql/apollo3/ast/GQLInlineFragment;", "Lcom/apollographql/apollo3/ast/GQLSelectionSet;", "parentType", "pairs", "Lkotlin/Pair;", "T", "typeDefinitionInScope", "validateExecutable", "FieldWithParent", "apollo-ast"})
public final class ExecutableValidationScope
implements ValidationScope,
VariableReferencesScope {
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, GQLFragmentDefinition> fragmentDefinitions;
    @NotNull
    private final Map<String, GQLTypeDefinition> typeDefinitions;
    @NotNull
    private final Map<String, GQLDirectiveDefinition> directiveDefinitions;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private final List<VariableReference> variableReferences;

    public ExecutableValidationScope(@NotNull Schema schema, @NotNull Map<String, GQLFragmentDefinition> fragmentDefinitions) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(fragmentDefinitions, (String)"fragmentDefinitions");
        this.schema = schema;
        this.fragmentDefinitions = fragmentDefinitions;
        this.typeDefinitions = this.schema.getTypeDefinitions();
        this.directiveDefinitions = this.schema.getDirectiveDefinitions();
        this.issues = new ArrayList();
        this.variableReferences = new ArrayList();
    }

    @Override
    @NotNull
    public Map<String, GQLTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @Override
    @NotNull
    public Map<String, GQLDirectiveDefinition> getDirectiveDefinitions() {
        return this.directiveDefinitions;
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    @NotNull
    public List<VariableReference> getVariableReferences() {
        return this.variableReferences;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Issue> validate(@NotNull GQLDocument document) {
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.validateExecutable(document);
        Iterable $this$filterIsInstance$iv = document.getDefinitions();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof GQLFragmentDefinition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        this.checkDuplicateFragments(fragments);
        Iterable $this$forEach$iv = fragments;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)element$iv2;
            boolean bl = false;
            this.validate(it);
        }
        Iterable $this$filterIsInstance$iv2 = document.getDefinitions();
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GQLOperationDefinition)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List operations = (List)destination$iv$iv2;
        this.checkDuplicateOperations(operations);
        Iterable $this$forEach$iv2 = operations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            GQLOperationDefinition it = (GQLOperationDefinition)element$iv3;
            boolean bl = false;
            this.validate(it);
        }
        return this.getIssues();
    }

    @NotNull
    public final List<Issue> validateOperation(@NotNull GQLOperationDefinition operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.validate(operation);
        return this.getIssues();
    }

    @NotNull
    public final List<Issue> validateFragment(@NotNull GQLFragmentDefinition fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.validate(fragment);
        return this.getIssues();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VariableReference> inferFragmentVariables(@NotNull GQLFragmentDefinition fragment) {
        Object answer$iv$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.getVariableReferences().clear();
        this.validate(fragment);
        Iterable $this$groupBy$iv = this.getVariableReferences();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            VariableReference it = (VariableReference)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it.getVariable().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry it = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable bl3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                answer$iv$iv$iv = (VariableReference)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(GqltypeKt.pretty(it2.getExpectedType()));
            }
            List types = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
            if (types.size() == 1) continue;
            boolean $i$a$-check-ExecutableValidationScope$inferFragmentVariables$2$22 = false;
            String $i$a$-check-ExecutableValidationScope$inferFragmentVariables$2$22 = "Fragment " + fragment.getName() + " uses different types for variable '" + (String)it.getKey() + "': " + CollectionsKt.joinToString$default((Iterable)types, null, null, null, (int)0, null, null, (int)63, null);
            throw new IllegalStateException($i$a$-check-ExecutableValidationScope$inferFragmentVariables$2$22.toString());
        }
        Iterable $this$distinctBy$iv = this.getVariableReferences();
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            VariableReference it = (VariableReference)e$iv;
            boolean bl = false;
            String key$iv = it.getVariable().getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private final String decapitalizeFirstLetter(String name) {
        StringBuilder builder = new StringBuilder(name.length());
        boolean isDecapitalized = false;
        CharSequence $this$forEach$iv = name;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        int n = 0;
        while (n < charSequence.length()) {
            String string;
            char element$iv = charSequence.charAt(n);
            ++n;
            char it = element$iv;
            boolean bl = false;
            if (!isDecapitalized && Character.isLetter(it)) {
                isDecapitalized = true;
                String string2 = String.valueOf(it).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                string = string2;
            } else {
                string = String.valueOf(it);
            }
            builder.append(string);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final boolean isFirstLetterUpperCase(String name) {
        boolean bl;
        Character c;
        block1: {
            CharSequence $this$firstOrNull$iv = name;
            boolean $i$f$firstOrNull = false;
            CharSequence charSequence = $this$firstOrNull$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (!Character.isLetter(it)) continue;
                c = Character.valueOf(element$iv);
                break block1;
            }
            c = null;
        }
        Character c2 = c;
        return c2 == null ? true : (bl = Character.isUpperCase(c2.charValue()));
    }

    private final void validate(GQLField $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLFieldDefinition fieldDefinition = GqlfieldKt.definitionFromScope($this$validate, this.schema, typeDefinitionInScope);
        if (fieldDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Can't query `" + $this$validate.getName() + "` on type `" + typeDefinitionInScope.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        if ($this$validate.getAlias() != null) {
            if (this.isFirstLetterUpperCase($this$validate.getAlias())) {
                this.getIssues().add(new Issue.UpperCaseField(StringsKt.trimIndent((String)("\n                      Capitalized alias '" + $this$validate.getAlias() + "' is not supported as it causes name clashes with the generated models. Use '" + this.decapitalizeFirstLetter($this$validate.getAlias()) + "' instead.\n                    ")), $this$validate.getSourceLocation()));
            }
        } else if (this.isFirstLetterUpperCase($this$validate.getName())) {
            this.getIssues().add(new Issue.UpperCaseField(StringsKt.trimIndent((String)("\n                      Capitalized field '" + $this$validate.getName() + "' is not supported as it causes name clashes with the generated models. Use an alias instead.\n                    ")), $this$validate.getSourceLocation()));
        }
        if (GqldirectiveKt.findDeprecationReason(fieldDefinition.getDirectives()) != null) {
            this.getIssues().add(new Issue.DeprecatedUsage("Use of deprecated field `" + $this$validate.getName() + '`', $this$validate.getSourceLocation()));
        }
        GQLArguments gQLArguments = $this$validate.getArguments();
        if (gQLArguments != null) {
            GQLArguments it = gQLArguments;
            boolean bl = false;
            ValidationCommonKt.validateArguments(this, it, fieldDefinition.getArguments(), "field `" + fieldDefinition.getName() + '`');
        }
        GQLTypeDefinition leafTypeDefinition = this.getTypeDefinitions().get(GqltypeKt.leafType(fieldDefinition.getType()).getName());
        if (leafTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Unknown type `" + GqltypeKt.leafType(fieldDefinition.getType()).getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!(leafTypeDefinition instanceof GQLScalarTypeDefinition) && !(leafTypeDefinition instanceof GQLEnumTypeDefinition)) {
            if ($this$validate.getSelectionSet() == null) {
                ValidationScope.DefaultImpls.registerIssue$default(this, "Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
                return;
            }
            this.validate($this$validate.getSelectionSet(), leafTypeDefinition);
        } else if ($this$validate.getSelectionSet() != null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Field `" + $this$validate.getName() + "` of type `" + GqltypeKt.pretty(fieldDefinition.getType()) + "` must not have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate);
        }
    }

    private final void validate(GQLInlineFragment $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLTypeDefinition inlineFragmentTypeDefinition = this.getTypeDefinitions().get($this$validate.getTypeCondition().getName());
        if (inlineFragmentTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for inline fragment", $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(inlineFragmentTypeDefinition, typeDefinitionInScope, this.schema)) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Inline fragment cannot be spread here as result can never be of type `" + $this$validate.getTypeCondition().getName() + '`', $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate($this$validate.getSelectionSet(), inlineFragmentTypeDefinition);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate);
        }
    }

    private final void validate(GQLFragmentSpread $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$validate.getName());
        if (fragmentDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find fragment `" + $this$validate.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        GQLTypeDefinition fragmentTypeDefinition = this.getTypeDefinitions().get(fragmentDefinition.getTypeCondition().getName());
        if (fragmentTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + fragmentDefinition.getTypeCondition().getName() + "` for fragment " + $this$validate.getName(), fragmentDefinition.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        if (!GqltypedefinitionKt.sharesPossibleTypesWith(fragmentTypeDefinition, typeDefinitionInScope, this.schema)) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Fragment `" + $this$validate.getName() + "` cannot be spread here as result can never be of type `" + typeDefinitionInScope.getName() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate(fragmentDefinition.getSelectionSet(), fragmentTypeDefinition);
        Iterable $this$forEach$iv = $this$validate.getDirectives();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            ValidationCommonKt.validateDirective(this, it, $this$validate);
        }
    }

    private final void validateExecutable(GQLDocument $this$validateExecutable) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = $this$validateExecutable.getDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GQLDefinition it = (GQLDefinition)element$iv;
                boolean bl = false;
                if (!(!(it instanceof GQLOperationDefinition) && !(it instanceof GQLFragmentDefinition))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        GQLDefinition gQLDefinition = v0;
        if (gQLDefinition != null) {
            GQLDefinition it = gQLDefinition;
            boolean bl = false;
            ValidationScope.DefaultImpls.registerIssue$default(this, "Found an non-executable definition.", it.getSourceLocation(), null, null, 12, null);
            return;
        }
    }

    private final void validate(GQLFragmentDefinition $this$validate) {
        GQLTypeDefinition fragmentRootTypeDefinition = this.getTypeDefinitions().get($this$validate.getTypeCondition().getName());
        if (fragmentRootTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find type `" + $this$validate.getTypeCondition().getName() + "` for fragment `" + $this$validate.getName() + '`', $this$validate.getTypeCondition().getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate($this$validate.getSelectionSet(), fragmentRootTypeDefinition);
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), fragmentRootTypeDefinition.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private final void validate(GQLOperationDefinition $this$validate) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        this.getVariableReferences().clear();
        GQLTypeDefinition rootTypeDefinition = GqloperationdefinitionKt.rootTypeDefinition($this$validate, this.schema);
        if (rootTypeDefinition == null) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Cannot find a root type for operation type `" + $this$validate.getOperationType() + '`', $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        this.validate($this$validate.getSelectionSet(), rootTypeDefinition);
        this.fieldsInSetCanMerge(this.collectFields($this$validate.getSelectionSet(), rootTypeDefinition.getName()));
        Iterable $this$forEach$iv = this.getVariableReferences();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            VariableReference it = (VariableReference)element$iv2;
            boolean bl = false;
            ValidationCommonKt.validateVariable(this, $this$validate, it.getVariable(), it.getExpectedType());
        }
        Iterable $this$map$iv = this.getVariableReferences();
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VariableReference variableReference = (VariableReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getVariable().getName());
        }
        Set foundVariables = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv2 = $this$validate.getVariableDefinitions();
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            GQLVariableDefinition it = (GQLVariableDefinition)element$iv3;
            boolean bl = false;
            if (foundVariables.contains(it.getName())) continue;
            this.getIssues().add(new Issue.UnusedVariable("Variable `" + it.getName() + "` is unused", it.getSourceLocation()));
        }
    }

    private final void validate(GQLSelectionSet $this$validate, GQLTypeDefinition typeDefinitionInScope) {
        if ($this$validate.getSelections().isEmpty()) {
            ValidationScope.DefaultImpls.registerIssue$default(this, "Selection of type `" + typeDefinitionInScope.getName() + "` must have a selection of sub-fields", $this$validate.getSourceLocation(), null, null, 12, null);
            return;
        }
        Iterable $this$forEach$iv = $this$validate.getSelections();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                this.validate((GQLField)it, typeDefinitionInScope);
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                this.validate((GQLInlineFragment)it, typeDefinitionInScope);
                continue;
            }
            if (!(gQLSelection instanceof GQLFragmentSpread)) continue;
            this.validate((GQLFragmentSpread)it, typeDefinitionInScope);
        }
    }

    private final void fieldPairCanMerge(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        GQLType typeB;
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        if (!Intrinsics.areEqual((Object)parentTypeDefinitionA.getName(), (Object)parentTypeDefinitionB.getName()) && parentTypeDefinitionA instanceof GQLObjectTypeDefinition && parentTypeDefinitionB instanceof GQLObjectTypeDefinition) {
            this.sameResponseShapeRecursive(fieldWithParentA, fieldWithParentB);
            return;
        }
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLFieldDefinition gQLFieldDefinition = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLType typeA = gQLFieldDefinition == null ? null : gQLFieldDefinition.getType();
        GQLFieldDefinition gQLFieldDefinition2 = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        GQLType gQLType = typeB = gQLFieldDefinition2 == null ? null : gQLFieldDefinition2.getType();
        if (typeA == null || typeB == null) {
            return;
        }
        if (!this.areTypesEqual(typeA, typeB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different types");
            return;
        }
        GQLArguments gQLArguments = fieldA.getArguments();
        List list = gQLArguments == null ? null : gQLArguments.getArguments();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        GQLArguments gQLArguments2 = fieldB.getArguments();
        List list2 = gQLArguments2 == null ? null : gQLArguments2.getArguments();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if (!this.areArgumentsEqual(list, list2)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different arguments");
            return;
        }
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return;
        }
        GQLSelectionSet gQLSelectionSet = fieldA.getSelectionSet();
        List list3 = gQLSelectionSet == null ? null : this.collectFields(gQLSelectionSet, parentTypeDefinitionA.getName());
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List setA = list3;
        GQLSelectionSet gQLSelectionSet2 = fieldB.getSelectionSet();
        List list4 = gQLSelectionSet2 == null ? null : this.collectFields(gQLSelectionSet2, parentTypeDefinitionB.getName());
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        List setB = list4;
        this.fieldsInSetCanMerge(CollectionsKt.plus((Collection)setA, (Iterable)setB));
    }

    /*
     * WARNING - void declaration
     */
    private final void fieldsInSetCanMerge(List<FieldWithParent> fieldsWithParent) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = fieldsWithParent;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List fieldsForName = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.pairs(fieldsForName);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair it = (Pair)element$iv2;
                boolean bl3 = false;
                this.fieldPairCanMerge((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond());
            }
        }
    }

    private final boolean areTypesEqual(GQLType typeA, GQLType typeB) {
        boolean bl;
        GQLType gQLType = typeA;
        if (gQLType instanceof GQLNonNullType) {
            bl = typeB instanceof GQLNonNullType && this.areTypesEqual(((GQLNonNullType)typeA).getType(), ((GQLNonNullType)typeB).getType());
        } else if (gQLType instanceof GQLListType) {
            bl = typeB instanceof GQLListType && this.areTypesEqual(((GQLListType)typeA).getType(), ((GQLListType)typeB).getType());
        } else if (gQLType instanceof GQLNamedType) {
            bl = typeB instanceof GQLNamedType && Intrinsics.areEqual((Object)((GQLNamedType)typeA).getName(), (Object)((GQLNamedType)typeB).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areArgumentsEqual(List<GQLArgument> argumentsA, List<GQLArgument> argumentsB) {
        void $this$groupByTo$iv$iv;
        if (argumentsA.size() != argumentsB.size()) {
            return false;
        }
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)argumentsA, (Iterable)argumentsB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GQLArgument it = (GQLArgument)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            if (it.size() != 2) {
                return false;
            }
            if (this.areValuesEqual(((GQLArgument)it.get(0)).getValue(), ((GQLArgument)it.get(1)).getValue())) continue;
            return false;
        }
        return true;
    }

    private final void addFieldMergingIssue(GQLField fieldA, GQLField fieldB, String message) {
        ValidationScope.DefaultImpls.registerIssue$default(this, '`' + GqlfieldKt.responseName(fieldA) + "` cannot be merged with `" + GqlfieldKt.responseName(fieldB) + "`: " + message, fieldA.getSourceLocation(), null, null, 12, null);
        ValidationScope.DefaultImpls.registerIssue$default(this, '`' + GqlfieldKt.responseName(fieldB) + "` cannot be merged with `" + GqlfieldKt.responseName(fieldA) + "`: " + message, fieldB.getSourceLocation(), null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areValuesEqual(GQLValue valueA, GQLValue valueB) {
        boolean bl;
        GQLValue gQLValue = valueA;
        if (gQLValue instanceof GQLIntValue) {
            GQLIntValue gQLIntValue = valueB instanceof GQLIntValue ? (GQLIntValue)valueB : null;
            bl = gQLIntValue == null ? false : gQLIntValue.getValue() == ((GQLIntValue)valueA).getValue();
        } else if (gQLValue instanceof GQLFloatValue) {
            GQLFloatValue gQLFloatValue = valueB instanceof GQLFloatValue ? (GQLFloatValue)valueB : null;
            bl = Intrinsics.areEqual((Double)(gQLFloatValue == null ? null : Double.valueOf(gQLFloatValue.getValue())), (double)((GQLFloatValue)valueA).getValue());
        } else if (gQLValue instanceof GQLStringValue) {
            GQLStringValue gQLStringValue = valueB instanceof GQLStringValue ? (GQLStringValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLStringValue == null ? null : gQLStringValue.getValue()), (Object)((GQLStringValue)valueA).getValue());
        } else if (gQLValue instanceof GQLBooleanValue) {
            GQLBooleanValue gQLBooleanValue = valueB instanceof GQLBooleanValue ? (GQLBooleanValue)valueB : null;
            bl = gQLBooleanValue == null ? false : gQLBooleanValue.getValue() == ((GQLBooleanValue)valueA).getValue();
        } else if (gQLValue instanceof GQLEnumValue) {
            GQLEnumValue gQLEnumValue = valueB instanceof GQLEnumValue ? (GQLEnumValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLEnumValue == null ? null : gQLEnumValue.getValue()), (Object)((GQLEnumValue)valueA).getValue());
        } else if (gQLValue instanceof GQLNullValue) {
            bl = valueB instanceof GQLNullValue;
        } else if (gQLValue instanceof GQLListValue) {
            if (!(valueB instanceof GQLListValue)) {
                return false;
            }
            int n = 0;
            int n2 = ((GQLListValue)valueA).getValues().size();
            while (n < n2) {
                int i = n++;
                if (this.areValuesEqual(((GQLListValue)valueA).getValues().get(i), ((GQLListValue)valueB).getValues().get(i))) continue;
                return false;
            }
            bl = true;
        } else if (gQLValue instanceof GQLObjectValue) {
            void $this$groupByTo$iv$iv;
            if (!(valueB instanceof GQLObjectValue)) {
                return false;
            }
            Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)((GQLObjectValue)valueA).getFields(), (Iterable)((GQLObjectValue)valueB).getFields());
            boolean $i$f$groupBy = false;
            Iterable i = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                GQLObjectField it = (GQLObjectField)element$iv$iv;
                boolean bl2 = false;
                String key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = destination$iv$iv.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl4 = false;
                if (it.size() != 2) {
                    return false;
                }
                if (this.areValuesEqual(((GQLObjectField)it.get(0)).getValue(), ((GQLObjectField)it.get(1)).getValue())) continue;
                return false;
            }
            bl = true;
        } else if (gQLValue instanceof GQLVariableValue) {
            GQLVariableValue gQLVariableValue = valueB instanceof GQLVariableValue ? (GQLVariableValue)valueB : null;
            bl = Intrinsics.areEqual((Object)(gQLVariableValue == null ? null : gQLVariableValue.getName()), (Object)((GQLVariableValue)valueA).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean sameResponseShapeRecursive(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        void $this$groupByTo$iv$iv;
        if (!this.haveSameResponseShape(fieldWithParentA, fieldWithParentB)) {
            this.addFieldMergingIssue(fieldWithParentA.getField(), fieldWithParentB.getField(), "they have different shapes");
            return false;
        }
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        GQLSelectionSet gQLSelectionSet = fieldWithParentA.getField().getSelectionSet();
        List list = gQLSelectionSet == null ? null : this.collectFields(gQLSelectionSet, parentTypeDefinitionA.getName());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List setA = list;
        GQLSelectionSet gQLSelectionSet2 = fieldWithParentA.getField().getSelectionSet();
        List list2 = gQLSelectionSet2 == null ? null : this.collectFields(gQLSelectionSet2, parentTypeDefinitionB.getName());
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List setB = list2;
        Iterable $this$groupBy$iv = CollectionsKt.plus((Collection)setA, (Iterable)setB);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FieldWithParent it = (FieldWithParent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = GqlfieldKt.responseName(it.getField());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v5;
            block8: {
                List fieldsForName = (List)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.pairs(fieldsForName);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv2;
                    boolean bl3 = false;
                    if (!this.sameResponseShapeRecursive((FieldWithParent)it.getFirst(), (FieldWithParent)it.getSecond())) continue;
                    v5 = element$iv2;
                    break block8;
                }
                v5 = null;
            }
            if (v5 == null) continue;
            return false;
        }
        return true;
    }

    private final boolean haveSameResponseShape(FieldWithParent fieldWithParentA, FieldWithParent fieldWithParentB) {
        GQLField fieldA = fieldWithParentA.getField();
        GQLField fieldB = fieldWithParentB.getField();
        GQLTypeDefinition parentTypeDefinitionA = fieldWithParentA.getParentTypeDefinition();
        GQLTypeDefinition parentTypeDefinitionB = fieldWithParentB.getParentTypeDefinition();
        GQLFieldDefinition fieldDefinitionA = GqlfieldKt.definitionFromScope(fieldA, this.schema, parentTypeDefinitionA);
        GQLFieldDefinition fieldDefinitionB = GqlfieldKt.definitionFromScope(fieldB, this.schema, parentTypeDefinitionB);
        if (fieldDefinitionA == null || fieldDefinitionB == null) {
            return true;
        }
        GQLType typeA = null;
        typeA = fieldDefinitionA.getType();
        GQLType typeB = null;
        typeB = fieldDefinitionB.getType();
        while (true) {
            if (!(typeA instanceof GQLNonNullType || typeA instanceof GQLListType || typeB instanceof GQLNonNullType)) {
                if (!(typeB instanceof GQLListType)) break;
            }
            if (typeA instanceof GQLNonNullType && !(typeB instanceof GQLNonNullType)) {
                return false;
            }
            if (!(typeA instanceof GQLNonNullType) && typeB instanceof GQLNonNullType) {
                return false;
            }
            if (typeA instanceof GQLNonNullType && typeB instanceof GQLNonNullType) {
                typeA = ((GQLNonNullType)typeA).getType();
                typeB = ((GQLNonNullType)typeB).getType();
            }
            if (typeA instanceof GQLListType && !(typeB instanceof GQLListType)) {
                return false;
            }
            if (!(typeA instanceof GQLListType) && typeB instanceof GQLListType) {
                return false;
            }
            if (!(typeA instanceof GQLListType) || !(typeB instanceof GQLListType)) continue;
            typeA = ((GQLListType)typeA).getType();
            typeB = ((GQLListType)typeB).getType();
        }
        if (!(typeA instanceof GQLNamedType && typeB instanceof GQLNamedType)) {
            boolean $i$a$-check-ExecutableValidationScope$haveSameResponseShape$22 = false;
            String $i$a$-check-ExecutableValidationScope$haveSameResponseShape$22 = GqltypeKt.pretty(typeA) + " and " + GqltypeKt.pretty(typeB) + " should be GQLNamedType";
            throw new IllegalStateException($i$a$-check-ExecutableValidationScope$haveSameResponseShape$22.toString());
        }
        GQLTypeDefinition typeDefinitionA = this.getTypeDefinitions().get(((GQLNamedType)typeA).getName());
        GQLTypeDefinition typeDefinitionB = this.getTypeDefinitions().get(((GQLNamedType)typeB).getName());
        if (typeDefinitionA == null || typeDefinitionB == null) {
            return true;
        }
        if (typeDefinitionA instanceof GQLScalarTypeDefinition || typeDefinitionA instanceof GQLEnumTypeDefinition || typeDefinitionB instanceof GQLScalarTypeDefinition || typeDefinitionB instanceof GQLEnumTypeDefinition) {
            return Intrinsics.areEqual((Object)typeDefinitionA.getName(), (Object)typeDefinitionB.getName());
        }
        return true;
    }

    private final <T> List<Pair<T, T>> pairs(List<? extends T> $this$pairs) {
        List pairs = new ArrayList();
        int n = 0;
        int n2 = $this$pairs.size();
        while (n < n2) {
            int i = n++;
            int n3 = i + 1;
            int n4 = $this$pairs.size();
            while (n3 < n4) {
                int j = n3++;
                pairs.add(TuplesKt.to($this$pairs.get(i), $this$pairs.get(j)));
            }
        }
        return pairs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldWithParent> collectFields(GQLSelectionSet $this$collectFields, String parentType) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$collectFields.getSelections();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            GQLSelection selection = (GQLSelection)element$iv$iv;
            boolean bl = false;
            GQLSelection gQLSelection = selection;
            if (gQLSelection instanceof GQLField) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object)this.getTypeDefinitions().get(parentType));
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FieldWithParent fieldWithParent;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    GQLTypeDefinition typeDefinition = (GQLTypeDefinition)element$iv$iv2;
                    boolean bl3 = false;
                    if (typeDefinition == null) {
                        fieldWithParent = null;
                    } else {
                        GQLTypeDefinition it;
                        boolean bl4 = false;
                        fieldWithParent = new FieldWithParent((GQLField)selection, it);
                    }
                    if (fieldWithParent == null) continue;
                    FieldWithParent it$iv$iv = fieldWithParent;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else if (gQLSelection instanceof GQLInlineFragment) {
                list = this.collectFields((GQLInlineFragment)selection);
            } else if (gQLSelection instanceof GQLFragmentSpread) {
                list = this.collectFields((GQLFragmentSpread)selection);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FieldWithParent> collectFields(GQLInlineFragment $this$collectFields) {
        return this.collectFields($this$collectFields.getSelectionSet(), $this$collectFields.getTypeCondition().getName());
    }

    private final List<FieldWithParent> collectFields(GQLFragmentSpread $this$collectFields) {
        GQLFragmentDefinition fragmentDefinition = this.fragmentDefinitions.get($this$collectFields.getName());
        if (fragmentDefinition == null) {
            return CollectionsKt.emptyList();
        }
        return this.collectFields(fragmentDefinition.getSelectionSet(), fragmentDefinition.getTypeCondition().getName());
    }

    private final List<Issue> checkDuplicateFragments(List<GQLFragmentDefinition> $this$checkDuplicateFragments) {
        Map filtered = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$checkDuplicateFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLFragmentDefinition it = (GQLFragmentDefinition)element$iv;
            boolean bl = false;
            GQLFragmentDefinition existing = filtered.putIfAbsent(it.getName(), it);
            if (existing == null) continue;
            this.getIssues().add(new Issue.ValidationError("Fragment " + it.getName() + " is already defined", it.getSourceLocation(), null, null, 12, null));
        }
        return this.getIssues();
    }

    private final List<Issue> checkDuplicateOperations(List<GQLOperationDefinition> $this$checkDuplicateOperations) {
        Map filtered = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$checkDuplicateOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLOperationDefinition it = (GQLOperationDefinition)element$iv;
            boolean bl = false;
            if (it.getName() == null) {
                this.getIssues().add(new Issue.ValidationError("Apollo does not support anonymous operations", it.getSourceLocation(), null, null, 12, null));
                continue;
            }
            GQLOperationDefinition existing = filtered.putIfAbsent(it.getName(), it);
            if (existing == null) continue;
            this.getIssues().add(new Issue.ValidationError("Operation " + it.getName() + " is already defined", it.getSourceLocation(), null, null, 12, null));
        }
        return this.getIssues();
    }

    @Override
    public void registerIssue(@NotNull String message, @NotNull SourceLocation sourceLocation, @NotNull Issue.Severity severity, @NotNull ValidationDetails details) {
        ValidationScope.DefaultImpls.registerIssue(this, message, sourceLocation, severity, details);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/ast/internal/ExecutableValidationScope$FieldWithParent;", "", "field", "Lcom/apollographql/apollo3/ast/GQLField;", "parentTypeDefinition", "Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "(Lcom/apollographql/apollo3/ast/GQLField;Lcom/apollographql/apollo3/ast/GQLTypeDefinition;)V", "getField", "()Lcom/apollographql/apollo3/ast/GQLField;", "getParentTypeDefinition", "()Lcom/apollographql/apollo3/ast/GQLTypeDefinition;", "apollo-ast"})
    private static final class FieldWithParent {
        @NotNull
        private final GQLField field;
        @NotNull
        private final GQLTypeDefinition parentTypeDefinition;

        public FieldWithParent(@NotNull GQLField field, @NotNull GQLTypeDefinition parentTypeDefinition) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)parentTypeDefinition, (String)"parentTypeDefinition");
            this.field = field;
            this.parentTypeDefinition = parentTypeDefinition;
        }

        @NotNull
        public final GQLField getField() {
            return this.field;
        }

        @NotNull
        public final GQLTypeDefinition getParentTypeDefinition() {
            return this.parentTypeDefinition;
        }
    }
}

