/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.codegen.java.schema;

import com.apollographql.apollo3.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo3.compiler.codegen.SchemaLayout;
import com.apollographql.apollo3.compiler.codegen.java.CodegenJavaFile;
import com.apollographql.apollo3.compiler.codegen.java.JavaClassBuilder;
import com.apollographql.apollo3.compiler.codegen.java.JavaResolver;
import com.apollographql.apollo3.compiler.codegen.java.JavaSchemaContext;
import com.apollographql.apollo3.compiler.codegen.java.helpers.DocKt;
import com.apollographql.apollo3.compiler.codegen.java.schema.TypesBuilderKt;
import com.apollographql.apollo3.compiler.ir.IrScalar;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/compiler/codegen/java/schema/ScalarBuilder;", "Lcom/apollographql/apollo3/compiler/codegen/java/JavaClassBuilder;", "context", "Lcom/apollographql/apollo3/compiler/codegen/java/JavaSchemaContext;", "scalar", "Lcom/apollographql/apollo3/compiler/ir/IrScalar;", "targetTypeName", "", "(Lcom/apollographql/apollo3/compiler/codegen/java/JavaSchemaContext;Lcom/apollographql/apollo3/compiler/ir/IrScalar;Ljava/lang/String;)V", "layout", "Lcom/apollographql/apollo3/compiler/codegen/SchemaLayout;", "packageName", "simpleName", "build", "Lcom/apollographql/apollo3/compiler/codegen/java/CodegenJavaFile;", "prefixBuiltinScalarNames", "name", "prepare", "", "typeSpec", "Lcom/squareup/javapoet/TypeSpec;", "apollo-compiler"})
public final class ScalarBuilder
implements JavaClassBuilder {
    @NotNull
    private final JavaSchemaContext context;
    @NotNull
    private final IrScalar scalar;
    @Nullable
    private final String targetTypeName;
    @NotNull
    private final SchemaLayout layout;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;

    public ScalarBuilder(@NotNull JavaSchemaContext context, @NotNull IrScalar scalar, @Nullable String targetTypeName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        this.context = context;
        this.scalar = scalar;
        this.targetTypeName = targetTypeName;
        this.layout = this.context.getLayout();
        this.packageName = LayoutImplKt.typePackageName(this.layout);
        this.simpleName = this.prefixBuiltinScalarNames(this.layout.schemaTypeName(this.scalar.getName()));
    }

    private final String prefixBuiltinScalarNames(String name) {
        Object[] objectArray = new String[]{"String", "Boolean", "Int", "Float", "ID"};
        if (ArraysKt.contains((Object[])objectArray, (Object)name)) {
            return "GraphQL" + name;
        }
        return name;
    }

    @Override
    public void prepare() {
        JavaResolver javaResolver = this.context.getResolver();
        String string = this.scalar.getName();
        ClassName className = ClassName.get((String)this.packageName, (String)this.simpleName, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
        javaResolver.registerSchemaType(string, className);
    }

    @Override
    @NotNull
    public CodegenJavaFile build() {
        return new CodegenJavaFile(this.packageName, this.typeSpec(this.scalar));
    }

    private final TypeSpec typeSpec(IrScalar $this$typeSpec) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.simpleName).addModifiers(modifierArray);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"addModifiers(...)");
        TypeSpec typeSpec = DocKt.maybeAddDeprecation(DocKt.maybeAddDescription(builder, $this$typeSpec.getDescription()), $this$typeSpec.getDeprecationReason()).addField(TypesBuilderKt.typeFieldSpec($this$typeSpec, this.targetTypeName)).build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"build(...)");
        return typeSpec;
    }
}

