/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler.internal;

import com.apollographql.apollo3.ast.GQLTypeDefinition;
import com.apollographql.apollo3.ast.GqldirectiveKt;
import com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.ast.ReservedEnumValueName;
import com.apollographql.apollo3.ast.Schema;
import com.apollographql.apollo3.ast.SourceLocation;
import com.apollographql.apollo3.ast.SourceLocationKt;
import com.apollographql.apollo3.compiler.StringsKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"checkApolloTargetNameClashes", "", "Lcom/apollographql/apollo3/ast/Issue;", "schema", "Lcom/apollographql/apollo3/ast/Schema;", "apollo-compiler"})
@JvmName(name="-checkApolloDuplicateTargetNames")
@SourceDebugExtension(value={"SMAP\ncheckApolloTargetNameClashes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 checkApolloTargetNameClashes.kt\ncom/apollographql/apollo3/compiler/internal/-checkApolloDuplicateTargetNames\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,51:1\n1053#2:52\n1279#2,2:53\n1293#2,4:55\n503#3,7:59\n503#3,7:66\n*S KotlinDebug\n*F\n+ 1 checkApolloTargetNameClashes.kt\ncom/apollographql/apollo3/compiler/internal/-checkApolloDuplicateTargetNames\n*L\n24#1:52\n25#1:53,2\n25#1:55,4\n29#1:59,7\n35#1:66,7\n*E\n"})
public final class -checkApolloDuplicateTargetNames {
    @NotNull
    public static final List<Issue> checkApolloTargetNameClashes(@NotNull Schema schema) {
        String it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        List issues = new ArrayList();
        Iterable $this$sortedBy$iv = schema.getTypeDefinitions().values();
        boolean $i$f$sortedBy = false;
        Iterable $this$associateWith$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GQLTypeDefinition it = (GQLTypeDefinition)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (GQLTypeDefinition)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            GQLTypeDefinition gQLTypeDefinition = (GQLTypeDefinition)t;
            Object t2 = t;
            Map map = result$iv;
            bl = false;
            String string = GqldirectiveKt.findTargetName((List)it.getDirectives(), (Schema)schema);
            map.put(t2, string);
        }
        Map typesWithTargetName = result$iv;
        Map usedNames = new LinkedHashMap();
        Map $this$filterValues$iv = typesWithTargetName;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (String)entry.getValue();
            bl = false;
            if (!(it == null)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        Iterator iterator = ((Map)result$iv2).entrySet().iterator();
        while (iterator.hasNext()) {
            GQLTypeDefinition type = (GQLTypeDefinition)iterator.next().getKey();
            String name = StringsKt.uniqueName(type.getName(), CollectionsKt.toSet((Iterable)usedNames.keySet()));
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            usedNames.put(string, type);
        }
        $this$filterValues$iv = typesWithTargetName;
        $i$f$filterValues = false;
        LinkedHashMap result$iv3 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (String)entry.getValue();
            bl = false;
            if (!(it != null)) continue;
            result$iv3.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : ((Map)result$iv3).entrySet()) {
            String name;
            String targetName;
            GQLTypeDefinition type = (GQLTypeDefinition)entry.getKey();
            String string = targetName = (String)entry.getValue();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (usedNames.containsKey(name)) {
                Object v = usedNames.get(name);
                Intrinsics.checkNotNull(v);
                GQLTypeDefinition gQLTypeDefinition = (GQLTypeDefinition)v;
                issues.add(new ReservedEnumValueName('\'' + targetName + "' cannot be used as a target name for '" + type.getName() + "' because it clashes with '" + gQLTypeDefinition.getName() + "' defined at " + SourceLocationKt.pretty((SourceLocation)gQLTypeDefinition.getSourceLocation()), type.getSourceLocation()));
                continue;
            }
            usedNames.put(name, type);
        }
        return issues;
    }
}

