/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.compiler.ValidationScope;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLField;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.relocated.com.apollographql.apollo3.ast.GQLSelectionSet;
import com.apollographql.relocated.com.apollographql.apollo3.ast.Issue;
import com.apollographql.relocated.com.apollographql.apollo3.ast.Issue$UpperCaseField;
import com.apollographql.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.kotlin.ranges.RangesKt___RangesKt;
import com.apollographql.relocated.kotlin.text.StringsKt__IndentKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u0006\u001a\u00020\u000b*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\f\u001a\u0017\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"", "Lcom/apollographql/relocated/com/apollographql/apollo3/ast/GQLDefinition;", "definitions", "", "checkFragmentsOnly", "Lcom/apollographql/relocated/com/apollographql/apollo3/ast/Issue;", "checkCapitalizedFields", "(Ljava/util/List;Z)Ljava/util/List;", "Lcom/apollographql/apollo3/compiler/ValidationScope;", "Lcom/apollographql/relocated/com/apollographql/apollo3/ast/GQLSelection;", "selections", "", "(Lcom/apollographql/apollo3/compiler/ValidationScope;Ljava/util/List;)V", "", "name", "isFirstLetterUpperCase", "(Ljava/lang/String;)Z", "decapitalizeFirstLetter", "(Ljava/lang/String;)Ljava/lang/String;", "apollo-compiler"})
public final class -checkCapitalizedFields {
    public static final List<Issue> checkCapitalizedFields(List<? extends GQLDefinition> object, boolean bl) {
        ValidationScope validationScope;
        Iterator iterator2 = object;
        Intrinsics.checkNotNullParameter(iterator2, "definitions");
        ValidationScope validationScope2 = validationScope;
        validationScope = new ValidationScope((List<? extends GQLDefinition>)((Object)object)){
            private final List<Issue> issues;
            private final Map<String, GQLFragmentDefinition> fragmentsByName;
            {
                LinkedHashMap<K, V> linkedHashMap;
                ArrayList<T> arrayList2;
                ArrayList<T> arrayList3;
                ArrayList<T> arrayList4 = arrayList;
                arrayList = arrayList3;
                arrayList3 = new ArrayList<T>();
                this.issues = arrayList;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<T>();
                for (Object object : arrayList4) {
                    if (!(object instanceof GQLFragmentDefinition)) continue;
                    arrayList.add(object);
                }
                ArrayList<T> arrayList5 = arrayList;
                int n = RangesKt___RangesKt.coerceAtLeast(MapsKt__MapsJVMKt.mapCapacity(CollectionsKt__IterablesKt.collectionSizeOrDefault(arrayList5)));
                LinkedHashMap<K, V> linkedHashMap2 = linkedHashMap;
                linkedHashMap = new LinkedHashMap<K, V>(n);
                for (Object object : arrayList5) {
                    linkedHashMap2.put(((GQLFragmentDefinition)object).getName(), object);
                }
                this.fragmentsByName = linkedHashMap2;
            }

            public List<Issue> getIssues() {
                return this.issues;
            }

            public Map<String, GQLFragmentDefinition> getFragmentsByName() {
                return this.fragmentsByName;
            }
        };
        object = iterator2.iterator();
        while (object.hasNext()) {
            GQLDefinition gQLDefinition = (GQLDefinition)object.next();
            if (gQLDefinition instanceof GQLOperationDefinition && !bl) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLOperationDefinition)gQLDefinition).selectionSet.selections);
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLFragmentDefinition)gQLDefinition).selectionSet.selections);
        }
        return validationScope2.getIssues();
    }

    private static final void checkCapitalizedFields(ValidationScope validationScope, List<? extends GQLSelection> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (GQLSelection)object.next();
            if (object2 instanceof GQLField) {
                GQLField gQLField = (GQLField)object2;
                String string = gQLField.alias;
                if (string != null) {
                    if (-checkCapitalizedFields.isFirstLetterUpperCase(string)) {
                        GQLNode gQLNode = object2;
                        object2 = StringsKt__IndentKt.trimIndent("\n                      Capitalized alias '" + string + "' is not supported as it causes name clashes with the generated models. Use '" + -checkCapitalizedFields.decapitalizeFirstLetter(string) + "' instead.\n                    ");
                        validationScope.getIssues().add(new Issue$UpperCaseField(gQLNode.getSourceLocation(), (String)object2));
                    }
                } else if (-checkCapitalizedFields.isFirstLetterUpperCase(gQLField.name)) {
                    GQLNode gQLNode = object2;
                    object2 = StringsKt__IndentKt.trimIndent("\n                      Capitalized field '" + gQLField.name + "' is not supported as it causes name clashes with the generated models. Use an alias instead or the 'flattenModels' or 'decapitalizeFields' compiler option.\n                    ");
                    validationScope.getIssues().add(new Issue$UpperCaseField(gQLNode.getSourceLocation(), (String)object2));
                }
                if ((object2 = gQLField.selectionSet) == null) continue;
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLSelectionSet)object2).selections);
                continue;
            }
            if (object2 instanceof GQLInlineFragment) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLInlineFragment)object2).selectionSet.selections);
                continue;
            }
            if (!(object2 instanceof GQLFragmentSpread) || (object2 = validationScope.getFragmentsByName().get(((GQLFragmentSpread)object2).name)) == null) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLFragmentDefinition)object2).selectionSet.selections);
        }
    }

    private static final boolean isFirstLetterUpperCase(String object) {
        block1: {
            for (int i = 0; i < object.length(); ++i) {
                char c = object.charAt(i);
                if (!Character.isLetter(c)) continue;
                object = Character.valueOf(c);
                break block1;
            }
            object = null;
        }
        return object != null ? Character.isUpperCase(((Character)object).charValue()) : true;
    }

    private static final String decapitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "builder.toString()");
        return string3;
    }
}

