/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.kotlin.ranges;

import com.apollographql.relocated.kotlin.internal.ProgressionUtilKt;
import com.apollographql.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import com.apollographql.relocated.kotlin.ranges.IntProgressionIterator;
import java.util.Iterator;

public class IntProgression
implements Iterable,
KMappedMarker {
    public final int first;
    public final int last;
    public final int step;

    public IntProgression(int n, int n2, int n3) {
        if (n3 != 0) {
            if (n3 != Integer.MIN_VALUE) {
                this.first = n;
                this.last = ProgressionUtilKt.getProgressionLastElement(n, n2, n3);
                this.step = n3;
                return;
            }
            throw new IllegalArgumentException("Step must be greater than Int.MIN_VALUE to avoid overflow on negation.");
        }
        throw new IllegalArgumentException("Step must be non-zero.");
    }

    public boolean isEmpty() {
        return this.step > 0 ? this.first > this.last : this.first < this.last;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof IntProgression)) return false;
        if (this.isEmpty()) {
            if (((IntProgression)object).isEmpty()) return true;
        }
        object = (IntProgression)object;
        if (this.first != ((IntProgression)object).first) return false;
        if (this.last != ((IntProgression)object).last) return false;
        if (this.step != ((IntProgression)object).step) return false;
        return true;
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : (this.first * 31 + this.last) * 31 + this.step;
    }

    public String toString() {
        return this.step > 0 ? this.first + ".." + this.last + " step " + this.step : this.first + " downTo " + this.last + " step " + -this.step;
    }

    public final Iterator iterator() {
        IntProgression intProgression = this;
        int n = intProgression.first;
        int n2 = intProgression.last;
        int n3 = intProgression.step;
        return new IntProgressionIterator(n, n2, n3);
    }
}

