/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.concurrent;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.internal.Util;
import com.apollographql.relocated.okhttp3.internal.concurrent.Task;
import com.apollographql.relocated.okhttp3.internal.concurrent.TaskLoggerKt;
import com.apollographql.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.relocated.okhttp3.internal.concurrent.TaskRunner$RealBackend;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class TaskQueue {
    public boolean shutdown;
    public Task activeTask;
    public final List futureTasks;
    public boolean cancelActiveTask;
    public final TaskRunner taskRunner;
    public final String name;

    public TaskQueue(TaskRunner taskRunner, String string) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(string, "name");
        ((TaskQueue)((Object)arrayList2)).taskRunner = taskRunner;
        ((TaskQueue)((Object)arrayList2)).name = string;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.futureTasks = arrayList2;
    }

    /*
     * Unable to fully structure code
     */
    public final void schedule(Task var1_2, long var2_3) {
        v0 = this;
        Intrinsics.checkNotNullParameter(var1_2, "task");
        var4_4 = v0.taskRunner;
        synchronized (var4_4) {
            block10: {
                if (!v0.shutdown) ** GOTO lbl24
                if (!var1_2.cancelable) break block10;
                ** try [egrp 2[TRYBLOCK] [2 : 28->31)] { 
lbl12:
                // 1 sources

                if (!TaskRunner.logger.isLoggable(Level.FINE)) ** GOTO lbl17
                TaskLoggerKt.access$log(var1_2, this, "schedule canceled (queue is shutdown)");
lbl17:
                // 2 sources

                return;
            }
            if (!TaskRunner.logger.isLoggable(Level.FINE)) ** GOTO lbl23
            TaskLoggerKt.access$log(var1_2, this, "schedule failed (queue is shutdown)");
lbl23:
            // 2 sources

            throw new RejectedExecutionException();
lbl24:
            // 1 sources

            if (!this.scheduleAndDecide$okhttp(var1_2, var2_3, false)) ** GOTO lbl27
            this.taskRunner.kickCoordinator$okhttp(this);
lbl27:
            // 2 sources

            v1 = var4_4;
            return;
        }
    }

    public final boolean scheduleAndDecide$okhttp(Task task, long l, boolean n) {
        block10: {
            block8: {
                block9: {
                    Task task2 = task;
                    Intrinsics.checkNotNullParameter(task2, "task");
                    TaskQueue taskQueue = task2.queue;
                    if (taskQueue == this) break block9;
                    if (!(taskQueue == null)) break block10;
                    task.queue = this;
                }
                TaskQueue taskQueue = this;
                ((TaskRunner$RealBackend)taskQueue.taskRunner.backend).getClass();
                long l2 = System.nanoTime();
                long l3 = l2 + l;
                int n2 = ((ArrayList)taskQueue.futureTasks).indexOf(task);
                if (n2 != -1) {
                    if (task.nextExecuteNanoTime <= l3) {
                        if (TaskRunner.logger.isLoggable(Level.FINE)) {
                            TaskLoggerKt.access$log(task, this, "already scheduled");
                        }
                        return false;
                    }
                    ((ArrayList)this.futureTasks).remove(n2);
                }
                task.nextExecuteNanoTime = l3;
                if (TaskRunner.logger.isLoggable(Level.FINE)) {
                    String string = n != 0 ? "run again after ".concat(TaskLoggerKt.formatDuration(l3 - l2)) : "scheduled after ".concat(TaskLoggerKt.formatDuration(l3 - l2));
                    TaskLoggerKt.access$log(task, this, string);
                }
                n = 0;
                Iterator iterator2 = ((ArrayList)this.futureTasks).iterator();
                while (iterator2.hasNext()) {
                    if (!(((Task)iterator2.next()).nextExecuteNanoTime - l2 > l)) {
                        ++n;
                        continue;
                    }
                    break block8;
                }
                n = -1;
            }
            if (n == -1) {
                n = ((ArrayList)this.futureTasks).size();
            }
            ((ArrayList)this.futureTasks).add(n, task);
            return n == 0;
        }
        throw new IllegalStateException("task is in multiple queues".toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelAll() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            StringBuilder stringBuilder = new StringBuilder("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread, "Thread.currentThread()");
            throw new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append(this).toString());
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            StringBuilder stringBuilder = new StringBuilder("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread, "Thread.currentThread()");
            throw new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append(this).toString());
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            taskQueue.shutdown = true;
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    public final boolean cancelAllAndDecide$okhttp() {
        Task task = this.activeTask;
        if (task != null) {
            Task task2 = task;
            Intrinsics.checkNotNull(task2);
            if (task2.cancelable) {
                this.cancelActiveTask = true;
            }
        }
        boolean bl = false;
        for (int i = ((ArrayList)this.futureTasks).size() - 1; i >= 0; --i) {
            if (!((Task)((ArrayList)this.futureTasks).get((int)i)).cancelable) continue;
            Task task3 = (Task)((ArrayList)this.futureTasks).get(i);
            if (TaskRunner.logger.isLoggable(Level.FINE)) {
                TaskLoggerKt.access$log(task3, this, "canceled");
            }
            bl = true;
            ((ArrayList)this.futureTasks).remove(i);
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }
}

