/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.http1;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.kotlin.text.StringsKt__StringsJVMKt;
import com.apollographql.relocated.okhttp3.Headers;
import com.apollographql.relocated.okhttp3.HttpUrl;
import com.apollographql.relocated.okhttp3.HttpUrl$Builder;
import com.apollographql.relocated.okhttp3.HttpUrl$Companion;
import com.apollographql.relocated.okhttp3.OkHttpClient;
import com.apollographql.relocated.okhttp3.Protocol;
import com.apollographql.relocated.okhttp3.Request;
import com.apollographql.relocated.okhttp3.Response;
import com.apollographql.relocated.okhttp3.Response$Builder;
import com.apollographql.relocated.okhttp3.internal.Util;
import com.apollographql.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.relocated.okhttp3.internal.http.HttpHeaders;
import com.apollographql.relocated.okhttp3.internal.http.StatusLine;
import com.apollographql.relocated.okhttp3.internal.http.StatusLine$Companion;
import com.apollographql.relocated.okhttp3.internal.http1.HeadersReader;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSink;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSource;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$FixedLengthSource;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$KnownLengthSink;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$UnknownLengthSource;
import com.apollographql.relocated.okio.BufferedSink;
import com.apollographql.relocated.okio.BufferedSource;
import com.apollographql.relocated.okio.Sink;
import com.apollographql.relocated.okio.Source;
import java.io.EOFException;
import java.io.IOException;
import java.net.Proxy;
import java.net.Socket;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    public int state;
    public final HeadersReader headersReader;
    public Headers trailers;
    public final OkHttpClient client;
    public final RealConnection connection;
    public final BufferedSource source;
    public final BufferedSink sink;

    @Override
    public final Sink createRequestBody(Request object, long l) {
        block5: {
            Object object2;
            block6: {
                block4: {
                    Http1ExchangeCodec$KnownLengthSink http1ExchangeCodec$KnownLengthSink;
                    block2: {
                        block3: {
                            Http1ExchangeCodec$ChunkedSink http1ExchangeCodec$ChunkedSink;
                            if (!StringsKt__StringsJVMKt.equals("chunked", ((Request)object).headers.get("Transfer-Encoding"))) break block2;
                            if (!(((Http1ExchangeCodec)object2).state == 1)) break block3;
                            ((Http1ExchangeCodec)object2).state = 2;
                            object = http1ExchangeCodec$ChunkedSink;
                            http1ExchangeCodec$ChunkedSink = new Http1ExchangeCodec$ChunkedSink((Http1ExchangeCodec)object2);
                            break block4;
                        }
                        object2 = "state: " + ((Http1ExchangeCodec)object2).state;
                        throw new IllegalStateException(object2.toString());
                    }
                    if (l == -1L) break block5;
                    if (!(((Http1ExchangeCodec)object2).state == 1)) break block6;
                    ((Http1ExchangeCodec)object2).state = 2;
                    object = http1ExchangeCodec$KnownLengthSink;
                    http1ExchangeCodec$KnownLengthSink = new Http1ExchangeCodec$KnownLengthSink((Http1ExchangeCodec)object2);
                }
                return object;
            }
            object2 = "state: " + ((Http1ExchangeCodec)object2).state;
            throw new IllegalStateException(object2.toString());
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        Socket socket = ((Http1ExchangeCodec)((Object)socket)).connection.rawSocket;
        if (socket != null) {
            Util.closeQuietly(socket);
        }
    }

    @Override
    public final void writeRequestHeaders(Request request) {
        StringBuilder stringBuilder;
        Object object = ((Http1ExchangeCodec)((Object)string)).connection.route.proxy.type();
        Intrinsics.checkNotNullExpressionValue(object, "connection.route().proxy.type()");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append(request.method);
        stringBuilder.append(' ');
        Object object2 = request.url;
        if (!((HttpUrl)object2).isHttps && object == Proxy.Type.HTTP) {
            stringBuilder2.append(object2);
        } else {
            HttpUrl httpUrl = object2;
            object = httpUrl.encodedPath();
            object2 = httpUrl.encodedQuery();
            if (object2 != null) {
                object = (String)object + '?' + (String)object2;
            }
            stringBuilder2.append((String)object);
        }
        Http1ExchangeCodec http1ExchangeCodec = string;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(" HTTP/1.1");
        String string = stringBuilder3.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        http1ExchangeCodec.writeRequest(request.headers, string);
    }

    @Override
    public final long reportedContentLength(Response response) {
        long l;
        if (!HttpHeaders.promisesBody(response)) {
            l = 0L;
        } else {
            Object object = null;
            String string = response.headers.get("Transfer-Encoding");
            if (string != null) {
                object = string;
            }
            l = StringsKt__StringsJVMKt.equals("chunked", (String)object) ? -1L : Util.headersContentLength(response);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Source openResponseBodySource(Response object) {
        Http1ExchangeCodec$UnknownLengthSource http1ExchangeCodec$UnknownLengthSource;
        Object object2;
        if (!HttpHeaders.promisesBody((Response)object)) {
            return ((Http1ExchangeCodec)object2).newFixedLengthSource(0L);
        }
        Object object3 = null;
        String string = ((Response)object).headers.get("Transfer-Encoding");
        if (string != null) {
            object3 = string;
        }
        if (StringsKt__StringsJVMKt.equals("chunked", (String)object3)) {
            object = ((Response)object).request.url;
            if (((Http1ExchangeCodec)object2).state == 4) {
                Http1ExchangeCodec$ChunkedSource http1ExchangeCodec$ChunkedSource;
                ((Http1ExchangeCodec)object2).state = 5;
                object3 = http1ExchangeCodec$ChunkedSource;
                http1ExchangeCodec$ChunkedSource = new Http1ExchangeCodec$ChunkedSource((Http1ExchangeCodec)object2, (HttpUrl)object);
                return object3;
            }
            object2 = "state: " + ((Http1ExchangeCodec)object2).state;
            throw new IllegalStateException(object2.toString());
        }
        long l = Util.headersContentLength((Response)object);
        if (l != -1L) {
            return ((Http1ExchangeCodec)object2).newFixedLengthSource(l);
        }
        if (!(((Http1ExchangeCodec)object2).state == 4)) {
            object2 = "state: " + ((Http1ExchangeCodec)object2).state;
            throw new IllegalStateException(object2.toString());
        }
        ((Http1ExchangeCodec)object2).state = 5;
        object = ((Http1ExchangeCodec)object2).connection;
        synchronized (object) {
            ((RealConnection)object).noNewExchanges = true;
        }
        object = http1ExchangeCodec$UnknownLengthSource;
        http1ExchangeCodec$UnknownLengthSource = new Http1ExchangeCodec$UnknownLengthSource((Http1ExchangeCodec)object2);
        return object;
    }

    @Override
    public final void flushRequest() {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String string) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(string, "requestLine");
        if (((Http1ExchangeCodec)((Object)string2)).state == 0) {
            ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8(string).writeUtf8("\r\n");
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
            }
            ((Http1ExchangeCodec)((Object)string2)).sink.writeUtf8("\r\n");
            ((Http1ExchangeCodec)((Object)string2)).state = 1;
            return;
        }
        String string2 = "state: " + ((Http1ExchangeCodec)((Object)string2)).state;
        throw new IllegalStateException(string2.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response$Builder readResponseHeaders(boolean bl) {
        Response$Builder response$Builder;
        long l;
        Object object;
        Object object2;
        boolean bl2;
        Object object3;
        int n = ((Http1ExchangeCodec)object3).state;
        if (!(n == 1 || n == 3)) {
            object3 = "state: " + ((Http1ExchangeCodec)object3).state;
            throw new IllegalStateException(object3.toString());
        }
        try {
            bl2 = bl;
            object2 = ((Http1ExchangeCodec)object3).headersReader;
            object = ((HeadersReader)object2).source.readUtf8LineStrict(((HeadersReader)object2).headerLimit);
            HeadersReader headersReader = object2;
            HeadersReader headersReader2 = headersReader;
            l = headersReader.headerLimit - (long)((String)object).length();
        }
        catch (EOFException eOFException) {
            object3 = ((Http1ExchangeCodec)object3).connection.route.address.url;
            String string = "/...";
            object3.getClass();
            try {
                object3 = new HttpUrl$Builder().parse$okhttp((HttpUrl)object3, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object3 = null;
            }
            Object object4 = object3;
            Intrinsics.checkNotNull(object4);
            ((HttpUrl$Builder)object4).encodedUsername = HttpUrl$Companion.canonicalize$okhttp$default("", 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 251);
            ((HttpUrl$Builder)object4).encodedPassword = HttpUrl$Companion.canonicalize$okhttp$default("", 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, 251);
            object3 = ((HttpUrl$Builder)object4).build().url;
            throw new IOException("unexpected end of stream on " + (String)object3, eOFException);
        }
        headersReader2.headerLimit = l;
        object2 = StatusLine$Companion.parse((String)object);
        object = response$Builder;
        ((Response$Builder)object)();
        Protocol protocol = ((StatusLine)object2).protocol;
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        ((Response$Builder)object).protocol = protocol;
        ((Response$Builder)object).code = ((StatusLine)object2).code;
        String string = ((StatusLine)object2).message;
        Intrinsics.checkNotNullParameter(string, "message");
        ((Response$Builder)object).message = string;
        response$Builder.headers = ((Http1ExchangeCodec)object3).headersReader.readHeaders().newBuilder();
        if (bl2 && ((StatusLine)object2).code == 100) {
            return null;
        }
        if (((StatusLine)object2).code == 100) {
            ((Http1ExchangeCodec)object3).state = 3;
            return object;
        }
        ((Http1ExchangeCodec)object3).state = 4;
        return object;
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Http1ExchangeCodec$FixedLengthSource newFixedLengthSource(long l) {
        if (((Http1ExchangeCodec)((Object)string)).state == 4) {
            ((Http1ExchangeCodec)((Object)string)).state = 5;
            return new Http1ExchangeCodec$FixedLengthSource((Http1ExchangeCodec)((Object)string), l);
        }
        String string = "state: " + ((Http1ExchangeCodec)((Object)string)).state;
        throw new IllegalStateException(string.toString());
    }

    public Http1ExchangeCodec(OkHttpClient okHttpClient, RealConnection realConnection, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        HeadersReader headersReader;
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        ((Http1ExchangeCodec)((Object)headersReader2)).client = okHttpClient;
        ((Http1ExchangeCodec)((Object)headersReader2)).connection = realConnection;
        ((Http1ExchangeCodec)((Object)headersReader2)).source = bufferedSource;
        ((Http1ExchangeCodec)((Object)headersReader2)).sink = bufferedSink;
        HeadersReader headersReader2 = headersReader;
        headersReader = new HeadersReader(bufferedSource);
        v1.headersReader = headersReader2;
    }

    public static final /* synthetic */ BufferedSink access$getSink$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.sink;
    }

    public static final /* synthetic */ BufferedSource access$getSource$p(Http1ExchangeCodec http1ExchangeCodec) {
        return http1ExchangeCodec.source;
    }
}

