/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.http2;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.internal.http2.Http2;
import com.apollographql.relocated.okhttp3.internal.http2.Http2Reader;
import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.BufferedSource;
import com.apollographql.relocated.okio.Source;
import com.apollographql.relocated.okio.Timeout;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Reader$ContinuationSource
implements Source {
    public int length;
    public int flags;
    public int streamId;
    public int left;
    public int padding;
    public final BufferedSource source;

    public Http2Reader$ContinuationSource(BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        this.source = bufferedSource;
    }

    @Override
    public final long read(Buffer buffer, long l) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        while ((n = this.left) == 0) {
            int n2;
            int n3;
            Http2Reader$ContinuationSource http2Reader$ContinuationSource = this;
            http2Reader$ContinuationSource.source.skip(this.padding);
            http2Reader$ContinuationSource.padding = 0;
            if ((http2Reader$ContinuationSource.flags & 4) != 0) {
                return -1L;
            }
            Http2Reader$ContinuationSource http2Reader$ContinuationSource2 = this;
            n = http2Reader$ContinuationSource2.streamId;
            BufferedSource bufferedSource = http2Reader$ContinuationSource2.source;
            Intrinsics.checkNotNullParameter(bufferedSource, "$this$readMedium");
            http2Reader$ContinuationSource2.left = n3 = (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
            http2Reader$ContinuationSource2.length = n3;
            n3 = http2Reader$ContinuationSource2.source.readByte() & 0xFF;
            http2Reader$ContinuationSource2.flags = http2Reader$ContinuationSource2.source.readByte() & 0xFF;
            Logger logger2 = Http2Reader.logger;
            if (logger2.isLoggable(Level.FINE)) {
                Http2Reader$ContinuationSource http2Reader$ContinuationSource3 = this;
                int n4 = http2Reader$ContinuationSource3.length;
                int n5 = http2Reader$ContinuationSource3.flags;
                logger2.fine(Http2.frameLog(this.streamId, n4, n3, n5, true));
            }
            this.streamId = n2 = this.source.readInt() & Integer.MAX_VALUE;
            if (n3 == 9) {
                if (n2 == n) continue;
                throw new IOException("TYPE_CONTINUATION streamId changed");
            }
            throw new IOException(n3 + " != TYPE_CONTINUATION");
        }
        long l2 = this.source.read(buffer, Math.min(l, (long)n));
        if (l2 == -1L) {
            return -1L;
        }
        this.left -= (int)l2;
        return l2;
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() {
    }
}

