/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.http2;

import com.apollographql.relocated.kotlin.collections.EmptyList$$ExternalSyntheticOutline0;
import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero0;
import com.apollographql.relocated.okhttp3.internal.http1.Http1ExchangeCodec$ChunkedSource$$ExternalSyntheticOutline0;
import com.apollographql.relocated.okhttp3.internal.http2.Hpack$Writer;
import com.apollographql.relocated.okhttp3.internal.http2.Http2;
import com.apollographql.relocated.okhttp3.internal.http2.Settings;
import com.apollographql.relocated.okio.Buffer;
import com.apollographql.relocated.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Writer
implements Closeable {
    public static final Logger logger = Logger.getLogger(Http2.class.getName());
    public final Buffer hpackBuffer;
    public int maxFrameSize;
    public boolean closed;
    public final Hpack$Writer hpackWriter;
    public final BufferedSink sink;
    public final boolean client;

    public Http2Writer(BufferedSink object, boolean bl) {
        Hpack$Writer hpack$Writer;
        Buffer buffer;
        Intrinsics.checkNotNullParameter(object, "sink");
        closeable.sink = object;
        closeable.client = bl;
        Closeable closeable = buffer;
        buffer = new Buffer();
        v1.hpackBuffer = closeable;
        v1.maxFrameSize = 16384;
        object = hpack$Writer;
        hpack$Writer = new Hpack$Writer((Buffer)closeable);
        v1.hpackWriter = object;
    }

    public final synchronized void applyAndAckSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "peerSettings");
        if (!this.closed) {
            int n = this.maxFrameSize;
            int n2 = settings.set;
            if ((n2 & 0x20) != 0) {
                n = settings.values[5];
            }
            this.maxFrameSize = n;
            n = (n2 & 2) != 0 ? settings.values[1] : -1;
            if (n != -1) {
                Hpack$Writer hpack$Writer = this.hpackWriter;
                int n3 = (n2 & 2) != 0 ? settings.values[1] : -1;
                hpack$Writer.getClass();
                n3 = Math.min(n3, 16384);
                n2 = hpack$Writer.maxDynamicTableByteCount;
                if (n2 != n3) {
                    if (n3 < n2) {
                        hpack$Writer.smallestHeaderTableSizeSetting = Math.min(hpack$Writer.smallestHeaderTableSizeSetting, n3);
                    }
                    hpack$Writer.emitDynamicTableSizeUpdate = true;
                    hpack$Writer.maxDynamicTableByteCount = n3;
                    n2 = hpack$Writer.dynamicTableByteCount;
                    if (n3 < n2) {
                        if (n3 == 0) {
                            Hpack$Writer hpack$Writer2 = hpack$Writer;
                            Arrays.fill(hpack$Writer2.dynamicTable, 0, hpack$Writer2.dynamicTable.length, null);
                            hpack$Writer2.nextHeaderIndex = hpack$Writer2.dynamicTable.length - 1;
                            hpack$Writer2.headerCount = 0;
                            hpack$Writer2.dynamicTableByteCount = 0;
                        } else {
                            hpack$Writer.evictToRecoverBytes(n2 - n3);
                        }
                    }
                }
            }
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 0, 4, 1);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void rstStream$enumunboxing$(int n, int n2) {
        Intrinsics$$ExternalSyntheticCheckNotZero0.m(n2, "errorCode");
        if (!this.closed) {
            if (n2 != 0) {
                int n3 = n2 - 1;
                if (n3 != -1) {
                    Http2Writer http2Writer = this;
                    http2Writer.frameHeader(n, 4, 3, 0);
                    BufferedSink bufferedSink = http2Writer.sink;
                    if (n2 != 0) {
                        bufferedSink.writeInt(n3);
                        this.sink.flush();
                        return;
                    }
                    throw null;
                }
                throw new IllegalArgumentException("Failed requirement.".toString());
            }
            throw null;
        }
        throw new IOException("closed");
    }

    public final synchronized void ping(int n, int n2, boolean bl) {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 8, 6, bl ? 1 : 0);
            http2Writer.sink.writeInt(n);
            http2Writer.sink.writeInt(n2);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void goAway$enumunboxing$(int n, int n2, byte[] byArray) {
        Intrinsics$$ExternalSyntheticCheckNotZero0.m(n2, "errorCode");
        if (!this.closed) {
            if (n2 != 0) {
                int n3 = n2 - 1;
                if (n3 != -1) {
                    Http2Writer http2Writer = this;
                    http2Writer.frameHeader(0, byArray.length + 8, 7, 0);
                    http2Writer.sink.writeInt(n);
                    BufferedSink bufferedSink = http2Writer.sink;
                    if (n2 != 0) {
                        bufferedSink.writeInt(n3);
                        if (byArray.length == 0 ^ true) {
                            this.sink.write(byArray);
                        }
                        this.sink.flush();
                        return;
                    }
                    throw null;
                }
                throw new IllegalArgumentException("errorCode.httpCode == -1".toString());
            }
            throw null;
        }
        throw new IOException("closed");
    }

    public final synchronized void windowUpdate(int n, long l) {
        if (!((Http2Writer)((Object)string)).closed) {
            if (l != 0L && l <= Integer.MAX_VALUE) {
                Http2Writer http2Writer = string;
                http2Writer.frameHeader(n, 4, 8, 0);
                http2Writer.sink.writeInt((int)l);
                http2Writer.sink.flush();
                return;
            }
            String string = Http1ExchangeCodec$ChunkedSource$$ExternalSyntheticOutline0.m("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: ", l);
            throw new IllegalArgumentException(string.toString());
        }
        throw new IOException("closed");
    }

    public final void frameHeader(int n, int n2, int n3, int n4) {
        Object object;
        Logger logger2 = logger;
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine(Http2.frameLog(n, n2, n3, n4, false));
        }
        if (n2 <= ((Http2Writer)object).maxFrameSize) {
            if ((n & (int)0x80000000L) == 0) {
                Http2Writer http2Writer = object;
                object = http2Writer.sink;
                Intrinsics.checkNotNullParameter(object, "$this$writeMedium");
                object.writeByte(n2 >>> 16 & 0xFF);
                object.writeByte(n2 >>> 8 & 0xFF);
                object.writeByte(n2 & 0xFF);
                http2Writer.sink.writeByte(n3 & 0xFF);
                http2Writer.sink.writeByte(n4 & 0xFF);
                http2Writer.sink.writeInt(n & Integer.MAX_VALUE);
                return;
            }
            object = EmptyList$$ExternalSyntheticOutline0.m("reserved bit set: ", n);
            throw new IllegalArgumentException(object.toString());
        }
        object = "FRAME_SIZE_ERROR length > " + ((Http2Writer)object).maxFrameSize + ": " + n2;
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final synchronized void close() {
        this.closed = true;
        this.sink.close();
    }
}

