/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import java.util.regex.Pattern;
import kotlin.Metadata;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\n\u0010\u0004\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0002*\u00020\u0002\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0002*\u00020\u0002H\u0000\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"JAVA_RESERVED_WORDS", "", "", "[Ljava/lang/String;", "escapeJavaReservedWord", "escapeKotlinReservedWord", "escapeKotlinReservedWordInEnum", "escapeKotlinReservedWordInSealedClass", "escapeTypeReservedWord", "apollo-compiler"})
public final class ReservedKeywordsKt {
    private static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "true", "void", "volatile", "while"};

    public static final String escapeJavaReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        if (ArraysKt___ArraysKt.contains(JAVA_RESERVED_WORDS, string)) {
            string = string.concat("_");
        }
        return string;
    }

    public static final String escapeKotlinReservedWord(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        return string2;
    }

    public static final String escapeTypeReservedWord(String string) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        Pattern pattern = Pattern.compile("(?:type)_*");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(pattern)");
        return pattern.matcher(string).matches() ? string.concat("_") : null;
    }

    public static final String escapeKotlinReservedWordInEnum(String string) {
        String string2;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Pattern pattern = Pattern.compile("(?:name|ordinal)_*");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(pattern)");
        string = pattern.matcher(string).matches() ? string.concat("_") : ((string2 = ReservedKeywordsKt.escapeTypeReservedWord(string)) == null ? ReservedKeywordsKt.escapeKotlinReservedWord(string) : string2);
        return string;
    }

    public static final String escapeKotlinReservedWordInSealedClass(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        String string3 = ReservedKeywordsKt.escapeTypeReservedWord(string2);
        if (string3 == null) {
            string3 = ReservedKeywordsKt.escapeKotlinReservedWord(string);
        }
        return string3;
    }
}

