/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.com.squareup.moshi;

import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonWriter;
import com.apollographql.apollo3.relocated.okio.BufferedSink;
import java.io.IOException;

public final class JsonUtf8Writer
extends JsonWriter {
    public static final String[] REPLACEMENT_CHARS = new String[128];
    public final BufferedSink sink;
    public String separator = ":";
    public String deferredName;

    public JsonUtf8Writer(BufferedSink bufferedSink) {
        if (bufferedSink != null) {
            this.sink = bufferedSink;
            this.pushScope(6);
            return;
        }
        throw new NullPointerException("sink == null");
    }

    public static void string(BufferedSink bufferedSink, String string) {
        String[] stringArray = REPLACEMENT_CHARS;
        bufferedSink.writeByte(34);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            String string2;
            char c = string.charAt(i);
            if (c < '\u0080') {
                string2 = stringArray[c];
                if (string2 == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n < i) {
                bufferedSink.writeUtf8(n, i, string);
            }
            bufferedSink.writeUtf8(string2);
            n = i + 1;
        }
        if (n < n2) {
            bufferedSink.writeUtf8(n, n2, string);
        }
        bufferedSink.writeByte(34);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = i;
            JsonUtf8Writer.REPLACEMENT_CHARS[i] = String.format("\\u%04x", objectArray2);
        }
        String[] stringArray = REPLACEMENT_CHARS;
        stringArray[34] = "\\\"";
        stringArray[92] = "\\\\";
        stringArray[9] = "\\t";
        stringArray[8] = "\\b";
        stringArray[10] = "\\n";
        stringArray[13] = "\\r";
        JsonUtf8Writer.REPLACEMENT_CHARS[12] = "\\f";
    }

    @Override
    public final void setIndent(String string) {
        String string2 = !string.isEmpty() ? string : null;
        this.indent = string2;
        string = !string.isEmpty() ? ": " : ":";
        this.separator = string;
    }

    @Override
    public final JsonWriter beginArray() {
        if (!this.promoteValueToName) {
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.writeDeferredName();
            int n = 1;
            int n2 = 2;
            int n3 = 91;
            int n4 = jsonUtf8Writer.stackSize;
            int n5 = this.flattenStackSize;
            if (n4 == n5 && ((n4 = this.scopes[n4 - 1]) == n || n4 == n2)) {
                this.flattenStackSize = ~n5;
            } else {
                JsonUtf8Writer jsonUtf8Writer2 = this;
                JsonUtf8Writer jsonUtf8Writer3 = this;
                jsonUtf8Writer3.beforeValue();
                jsonUtf8Writer3.checkStack();
                jsonUtf8Writer2.pushScope(n);
                jsonUtf8Writer2.pathIndices[this.stackSize - 1] = 0;
                jsonUtf8Writer2.sink.writeByte(n3);
            }
            return this;
        }
        throw new IllegalStateException("Array cannot be used as a map key in JSON at path " + this.getPath());
    }

    @Override
    public final JsonWriter endArray() {
        return this.close(1, 2, ']');
    }

    @Override
    public final JsonWriter beginObject() {
        if (!this.promoteValueToName) {
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.writeDeferredName();
            int n = 3;
            int n2 = 5;
            int n3 = 123;
            int n4 = jsonUtf8Writer.stackSize;
            int n5 = this.flattenStackSize;
            if (n4 == n5 && ((n4 = this.scopes[n4 - 1]) == n || n4 == n2)) {
                this.flattenStackSize = ~n5;
            } else {
                JsonUtf8Writer jsonUtf8Writer2 = this;
                JsonUtf8Writer jsonUtf8Writer3 = this;
                jsonUtf8Writer3.beforeValue();
                jsonUtf8Writer3.checkStack();
                jsonUtf8Writer2.pushScope(n);
                jsonUtf8Writer2.pathIndices[this.stackSize - 1] = 0;
                jsonUtf8Writer2.sink.writeByte(n3);
            }
            return this;
        }
        throw new IllegalStateException("Object cannot be used as a map key in JSON at path " + this.getPath());
    }

    @Override
    public final JsonWriter endObject() {
        this.promoteValueToName = false;
        return this.close(3, 5, '}');
    }

    @Override
    public final JsonWriter name(String string) {
        if (string != null) {
            if (this.stackSize != 0) {
                int n = this.peekScope();
                if (!(n != 3 && n != 5 || this.deferredName != null || this.promoteValueToName)) {
                    JsonUtf8Writer jsonUtf8Writer = this;
                    jsonUtf8Writer.deferredName = string;
                    jsonUtf8Writer.pathNames[this.stackSize - 1] = string;
                    return jsonUtf8Writer;
                }
                throw new IllegalStateException("Nesting problem.");
            }
            throw new IllegalStateException("JsonWriter is closed.");
        }
        throw new NullPointerException("name == null");
    }

    @Override
    public final JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        if (this.promoteValueToName) {
            this.promoteValueToName = false;
            return this.name(string);
        }
        JsonUtf8Writer jsonUtf8Writer = this;
        jsonUtf8Writer.writeDeferredName();
        jsonUtf8Writer.beforeValue();
        JsonUtf8Writer.string(jsonUtf8Writer.sink, string);
        int n = this.stackSize - 1;
        jsonUtf8Writer.pathIndices[n] = jsonUtf8Writer.pathIndices[n] + 1;
        return jsonUtf8Writer;
    }

    @Override
    public final JsonWriter nullValue() {
        if (!this.promoteValueToName) {
            if (this.deferredName != null) {
                if (this.serializeNulls) {
                    this.writeDeferredName();
                } else {
                    this.deferredName = null;
                    return this;
                }
            }
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.beforeValue();
            jsonUtf8Writer.sink.writeUtf8("null");
            int n = this.stackSize - 1;
            jsonUtf8Writer.pathIndices[n] = jsonUtf8Writer.pathIndices[n] + 1;
            return jsonUtf8Writer;
        }
        throw new IllegalStateException("null cannot be used as a map key in JSON at path " + this.getPath());
    }

    @Override
    public final JsonWriter value(boolean bl) {
        if (!this.promoteValueToName) {
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.writeDeferredName();
            jsonUtf8Writer.beforeValue();
            BufferedSink bufferedSink = jsonUtf8Writer.sink;
            String string = bl ? "true" : "false";
            JsonUtf8Writer jsonUtf8Writer2 = this;
            bufferedSink.writeUtf8(string);
            int n = this.stackSize - 1;
            jsonUtf8Writer2.pathIndices[n] = jsonUtf8Writer2.pathIndices[n] + 1;
            return jsonUtf8Writer2;
        }
        throw new IllegalStateException("Boolean cannot be used as a map key in JSON at path " + this.getPath());
    }

    @Override
    public final JsonWriter value(double d) {
        if (!((JsonWriter)((Object)stringBuilder2)).lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2("Numeric values must be finite, but was ");
            throw new IllegalArgumentException(stringBuilder.append(d).toString());
        }
        if (((JsonWriter)((Object)stringBuilder2)).promoteValueToName) {
            ((JsonWriter)((Object)stringBuilder2)).promoteValueToName = false;
            return ((JsonUtf8Writer)((Object)stringBuilder2)).name(Double.toString(d));
        }
        JsonUtf8Writer jsonUtf8Writer = stringBuilder2;
        jsonUtf8Writer.writeDeferredName();
        jsonUtf8Writer.beforeValue();
        jsonUtf8Writer.sink.writeUtf8(Double.toString(d));
        int n = ((JsonWriter)((Object)stringBuilder2)).stackSize - 1;
        jsonUtf8Writer.pathIndices[n] = jsonUtf8Writer.pathIndices[n] + 1;
        return jsonUtf8Writer;
    }

    @Override
    public final JsonWriter value(long l) {
        if (this.promoteValueToName) {
            this.promoteValueToName = false;
            return this.name(Long.toString(l));
        }
        JsonUtf8Writer jsonUtf8Writer = this;
        jsonUtf8Writer.writeDeferredName();
        jsonUtf8Writer.beforeValue();
        jsonUtf8Writer.sink.writeUtf8(Long.toString(l));
        int n = this.stackSize - 1;
        jsonUtf8Writer.pathIndices[n] = jsonUtf8Writer.pathIndices[n] + 1;
        return jsonUtf8Writer;
    }

    @Override
    public final JsonWriter value(Number number) {
        if (number == null) {
            return this.nullValue();
        }
        String string = number.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + number);
        }
        if (this.promoteValueToName) {
            this.promoteValueToName = false;
            return this.name(string);
        }
        JsonUtf8Writer jsonUtf8Writer = this;
        jsonUtf8Writer.writeDeferredName();
        jsonUtf8Writer.beforeValue();
        jsonUtf8Writer.sink.writeUtf8(string);
        int n = this.stackSize - 1;
        jsonUtf8Writer.pathIndices[n] = jsonUtf8Writer.pathIndices[n] + 1;
        return jsonUtf8Writer;
    }

    @Override
    public final void flush() {
        if (this.stackSize != 0) {
            this.sink.flush();
            return;
        }
        throw new IllegalStateException("JsonWriter is closed.");
    }

    @Override
    public final void close() {
        JsonUtf8Writer jsonUtf8Writer = this;
        jsonUtf8Writer.sink.close();
        int n = jsonUtf8Writer.stackSize;
        if (n <= 1 && (n != 1 || this.scopes[n - 1] == 7)) {
            this.stackSize = 0;
            return;
        }
        throw new IOException("Incomplete document");
    }

    public final JsonUtf8Writer close(int n, int n2, char c) {
        int n3 = this.peekScope();
        if (n3 != n2 && n3 != n) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName == null) {
            n = this.stackSize;
            int n4 = ~this.flattenStackSize;
            if (n == n4) {
                this.flattenStackSize = n4;
                return this;
            }
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.stackSize = --n;
            jsonUtf8Writer.pathNames[n] = null;
            jsonUtf8Writer.pathIndices[--n] = jsonUtf8Writer.pathIndices[n] + 1;
            if (n3 == n2 && this.indent != null) {
                JsonUtf8Writer jsonUtf8Writer2 = this;
                jsonUtf8Writer2.sink.writeByte(10);
                n2 = jsonUtf8Writer2.stackSize;
                for (n = 1; n < n2; ++n) {
                    this.sink.writeUtf8(this.indent);
                }
            }
            JsonUtf8Writer jsonUtf8Writer3 = this;
            jsonUtf8Writer3.sink.writeByte(c);
            return jsonUtf8Writer3;
        }
        throw new IllegalStateException("Dangling name: " + this.deferredName);
    }

    public final void writeDeferredName() {
        block6: {
            if (this.deferredName == null) break block6;
            int n = this.peekScope();
            if (n == 5) {
                this.sink.writeByte(44);
            } else if (n != 3) {
                throw new IllegalStateException("Nesting problem.");
            }
            if (this.indent != null) {
                JsonUtf8Writer jsonUtf8Writer = this;
                jsonUtf8Writer.sink.writeByte(10);
                int n2 = jsonUtf8Writer.stackSize;
                for (n = 1; n < n2; ++n) {
                    this.sink.writeUtf8(this.indent);
                }
            }
            JsonUtf8Writer jsonUtf8Writer = this;
            jsonUtf8Writer.scopes[this.stackSize - 1] = n = 4;
            JsonUtf8Writer.string(jsonUtf8Writer.sink, this.deferredName);
            jsonUtf8Writer.deferredName = null;
        }
    }

    public final void beforeValue() {
        int n;
        switch (this.peekScope()) {
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
            case 9: {
                throw new IllegalStateException("Sink from valueSink() was not closed");
            }
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                n = 7;
                break;
            }
            case 4: {
                n = 5;
                this.sink.writeUtf8(this.separator);
                break;
            }
            case 2: {
                this.sink.writeByte(44);
            }
            case 1: {
                if (this.indent != null) {
                    JsonUtf8Writer jsonUtf8Writer = this;
                    jsonUtf8Writer.sink.writeByte(10);
                    int n2 = jsonUtf8Writer.stackSize;
                    for (n = 1; n < n2; ++n) {
                        this.sink.writeUtf8(this.indent);
                    }
                }
                n = 2;
            }
        }
        this.scopes[this.stackSize - 1] = n;
    }
}

