/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__CollectionsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.AndroidPlatform$CustomTrustRootIndex;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.AndroidCertificateChainCleaner$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.AndroidSocketAdapter;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.CloseGuard;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.CloseGuard$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.ConscryptSocketAdapter;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.DeferredSocketAdapter;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.SocketAdapter;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.StandardAndroidSocketAdapter$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;

public final class AndroidPlatform
extends Platform {
    public static final boolean isSupported;
    public final List socketAdapters;
    public final CloseGuard closeGuard;

    public AndroidPlatform() {
        ArrayList arrayList;
        DeferredSocketAdapter deferredSocketAdapter;
        DeferredSocketAdapter deferredSocketAdapter2;
        DeferredSocketAdapter deferredSocketAdapter3;
        Object[] objectArray = new SocketAdapter[4];
        objectArray[0] = StandardAndroidSocketAdapter$Companion.buildIfSupported$default();
        Object object = deferredSocketAdapter3;
        deferredSocketAdapter3 = new DeferredSocketAdapter(AndroidSocketAdapter.playProviderFactory);
        objectArray[1] = object;
        object = deferredSocketAdapter2;
        deferredSocketAdapter2 = new DeferredSocketAdapter(ConscryptSocketAdapter.factory);
        objectArray[2] = object;
        object = deferredSocketAdapter;
        deferredSocketAdapter = new DeferredSocketAdapter(BouncyCastleSocketAdapter.factory);
        objectArray[3] = object;
        object = arrayList;
        arrayList = new ArrayList();
        for (Object e : (ArrayList)CollectionsKt__CollectionsKt.listOfNotNull(objectArray)) {
            if (!((SocketAdapter)e).isSupported()) continue;
            ((ArrayList)object).add(e);
        }
        AndroidPlatform androidPlatform = this;
        androidPlatform.socketAdapters = object;
        androidPlatform.closeGuard = CloseGuard$Companion.get();
    }

    static {
        block4: {
            boolean bl;
            block3: {
                block2: {
                    if (Intrinsics.areEqual("Dalvik", System.getProperty("java.vm.name")) && Build.VERSION.SDK_INT < 30) break block2;
                    bl = false;
                    break block3;
                }
                if (!(Build.VERSION.SDK_INT >= 21)) break block4;
                bl = true;
            }
            isSupported = bl;
            return;
        }
        String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
        throw new IllegalStateException(string.toString());
    }

    @Override
    public final void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n) {
        Intrinsics.checkNotNullParameter(inetSocketAddress, "address");
        try {
            socket.connect(inetSocketAddress, n);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", classCastException);
            }
            throw classCastException;
        }
    }

    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Object var4_4;
        block2: {
            Intrinsics.checkNotNullParameter(list, "protocols");
            for (Object e : (ArrayList)((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var4_4 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block2;
            }
            var4_4 = null;
        }
        SocketAdapter socketAdapter = var4_4;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        Object var2_2;
        block1: {
            for (Object e : (ArrayList)((AndroidPlatform)((Object)socketAdapter)).socketAdapters) {
                var2_2 = e;
                if (!((SocketAdapter)e).matchesSocket(sSLSocket)) continue;
                break block1;
            }
            var2_2 = null;
        }
        SocketAdapter socketAdapter = var2_2;
        return socketAdapter != null ? socketAdapter.getSelectedProtocol(sSLSocket) : null;
    }

    @Override
    public final Object getStackTraceForCloseable() {
        Object object;
        block5: {
            block4: {
                AndroidPlatform androidPlatform = string;
                String string = "response.body().close()";
                object = androidPlatform.closeGuard;
                object.getClass();
                Object[] objectArray = ((CloseGuard)object).getMethod;
                if (((CloseGuard)object).getMethod == null) break block4;
                CloseGuard closeGuard = object;
                try {
                    object = objectArray.invoke(null, new Object[0]);
                }
                catch (Exception exception) {}
                Method method = closeGuard.openMethod;
                Method method2 = method;
                Intrinsics.checkNotNull(method);
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string;
                method2.invoke(object, objectArray);
                break block5;
            }
            object = null;
        }
        return object;
    }

    @Override
    public final void logCloseableLeak(Object object, String string) {
        Intrinsics.checkNotNullParameter(string, "message");
        if (!this.closeGuard.warnIfOpen(object)) {
            Platform.log(string, 5, null);
        }
    }

    @Override
    public final boolean isCleartextTrafficPermitted(String string) {
        boolean bl;
        Intrinsics.checkNotNullParameter(string, "hostname");
        if (Build.VERSION.SDK_INT >= 24) {
            bl = NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(string);
        } else if (Build.VERSION.SDK_INT >= 23) {
            NetworkSecurityPolicy networkSecurityPolicy = NetworkSecurityPolicy.getInstance();
            Intrinsics.checkNotNullExpressionValue(networkSecurityPolicy, "NetworkSecurityPolicy.getInstance()");
            bl = networkSecurityPolicy.isCleartextTrafficPermitted();
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public final CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        CertificateChainCleaner certificateChainCleaner = AndroidCertificateChainCleaner$Companion.buildIfSupported(x509TrustManager);
        if (certificateChainCleaner == null) {
            BasicCertificateChainCleaner basicCertificateChainCleaner;
            certificateChainCleaner = basicCertificateChainCleaner;
            basicCertificateChainCleaner = new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
        }
        return certificateChainCleaner;
    }

    @Override
    public final TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        AndroidPlatform$CustomTrustRootIndex androidPlatform$CustomTrustRootIndex;
        Class<?> clazz = x509TrustManager.getClass();
        String string = "findTrustAnchorByIssuerAndSignature";
        Class[] classArray = new Class[1];
        classArray[0] = X509Certificate.class;
        Method method = clazz.getDeclaredMethod(string, classArray);
        Intrinsics.checkNotNullExpressionValue(method, "method");
        method.setAccessible(true);
        TrustRootIndex trustRootIndex = androidPlatform$CustomTrustRootIndex;
        try {
            androidPlatform$CustomTrustRootIndex = new AndroidPlatform$CustomTrustRootIndex(x509TrustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            trustRootIndex = super.buildTrustRootIndex(x509TrustManager);
        }
        return trustRootIndex;
    }
}

