/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.ranges.RangesKt___RangesKt;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack$Reader;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$ReaderRunnable;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$ReaderRunnable$settings$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$pushDataLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$pushRequestLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection$pushResetLater$$inlined$execute$default$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Reader$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Reader$ContinuationSource;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Reader$Handler;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Settings;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.BufferedSource;
import com.apollographql.apollo3.relocated.okio.ByteString;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Reader
implements Closeable {
    public static final Logger logger;
    public final BufferedSource source;
    public final boolean client;
    public final Http2Reader$ContinuationSource continuation;
    public final Hpack$Reader hpackReader;

    public Http2Reader(BufferedSource object, boolean bl) {
        Hpack$Reader hpack$Reader;
        Http2Reader$ContinuationSource http2Reader$ContinuationSource;
        closeable.source = object;
        closeable.client = bl;
        Closeable closeable = http2Reader$ContinuationSource;
        http2Reader$ContinuationSource = new Http2Reader$ContinuationSource((BufferedSource)object);
        v1.continuation = closeable;
        object = hpack$Reader;
        hpack$Reader = new Hpack$Reader((Http2Reader$ContinuationSource)closeable);
        v1.hpackReader = object;
    }

    static {
        Logger logger2 = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(Http2::class.java.name)");
        logger = logger2;
    }

    public final void readConnectionPreface(Http2Reader$Handler object) {
        block8: {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter(object, "handler");
                    if (!((Http2Reader)((Object)byteString)).client) break block6;
                    if (!((Http2Reader)((Object)byteString)).nextFrame(true, (Http2Reader$Handler)object)) {
                        throw new IOException("Required SETTINGS preface not received");
                    }
                    break block7;
                }
                ByteString byteString = Http2.CONNECTION_PREFACE;
                object = ((Http2Reader)((Object)byteString)).source.readByteString(byteString.data.length);
                Logger logger2 = logger;
                if (logger2.isLoggable(Level.FINE)) {
                    logger2.fine(Util.format(Intrinsics.stringPlus(((ByteString)object).hex(), "<< CONNECTION "), new Object[0]));
                }
                if (!Intrinsics.areEqual(byteString, object)) break block8;
            }
            return;
        }
        throw new IOException(Intrinsics.stringPlus(((ByteString)object).utf8(), "Expected a connection header but was "));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final boolean nextFrame(boolean var1_5, Http2Reader$Handler var2_10) {
        block55: {
            Intrinsics.checkNotNullParameter(var2_10, "handler");
            try {
                this.source.require(9L);
                var3_11 = this.source;
            }
            catch (EOFException v10) {
                return false;
            }
            Intrinsics.checkNotNullParameter(var3_11, "<this>");
            var3_12 = (var3_11.readByte() & 255) << 16 | (var3_11.readByte() & 255) << 8 | var3_11.readByte() & 255;
            if (var3_12 > 16384) break block55;
            var4_13 = this.source.readByte() & 255;
            var5_15 = this.source.readByte() & 255;
            var6_19 = this.source.readInt() & 0x7FFFFFFF;
            var7_20 = Http2Reader.logger;
            if (var7_20.isLoggable(Level.FINE)) {
                var7_20.fine(Http2.frameLog(var6_19, var3_12, var4_13, var5_15, true));
            }
            if (var1_5 && var4_13 != 4) {
                var1_6 /* !! */  = Http2.FRAME_NAMES;
                if (var4_13 < Http2.FRAME_NAMES.length) {
                    var1_6 /* !! */  = var1_6 /* !! */ [var4_13];
                } else {
                    v0 = new Object[1];
                    var1_6 /* !! */  = v0;
                    v0[0] = var4_13;
                    var1_6 /* !! */  = Util.format("0x%02x", var1_6 /* !! */ );
                }
                v1 = this;
                v1(Intrinsics.stringPlus(var1_6 /* !! */ , "Expected a SETTINGS frame but was "));
                throw v1;
            }
            switch (var4_13) {
                default: {
                    this.source.skip(var3_12);
                    break;
                }
                case 8: {
                    if (var3_12 == 4) {
                        var0_1 = (long)this.source.readInt() & 0x7FFFFFFFL;
                        if (var0_1 != 0L) {
                            ((Http2Connection$ReaderRunnable)var2_10).windowUpdate(var6_19, var0_1);
                            break;
                        }
                        throw new IOException("windowSizeIncrement was 0");
                    }
                    throw new IOException(Intrinsics.stringPlus(var3_12, "TYPE_WINDOW_UPDATE length !=4: "));
                }
                case 7: {
                    if (var3_12 < 8) ** GOTO lbl58
                    if (var6_19 != 0) ** GOTO lbl57
                    var1_5 = this.source.readInt();
                    var4_13 = this.source.readInt();
                    var3_12 -= 8;
                    for (ErrorCode var8_25 : (ErrorCode[])ErrorCode.$VALUES.clone()) {
                        if (!(var8_25.httpCode == var4_13)) {
                            continue;
                        }
                        ** GOTO lbl50
                    }
                    var8_25 = null;
lbl50:
                    // 2 sources

                    if (var8_25 != null) {
                        var4_14 = ByteString.EMPTY;
                        if (var3_12 > 0) {
                            var4_14 = this.source.readByteString(var3_12);
                        }
                        ((Http2Connection$ReaderRunnable)var2_10).goAway((int)var1_5, var8_25, var4_14);
                        break;
                    }
                    throw new IOException(Intrinsics.stringPlus(var4_13, "TYPE_GOAWAY unexpected error code: "));
lbl57:
                    // 1 sources

                    throw new IOException("TYPE_GOAWAY streamId != 0");
lbl58:
                    // 1 sources

                    throw new IOException(Intrinsics.stringPlus(var3_12, "TYPE_GOAWAY length < 8: "));
                }
                case 6: {
                    if (var3_12 == 8) {
                        if (var6_19 == 0) {
                            var1_5 = this.source.readInt();
                            var0_2 = this.source.readInt();
                            var3_12 = (var5_15 & 1) != 0 ? 1 : 0;
                            ((Http2Connection$ReaderRunnable)var2_10).ping((boolean)var3_12, (int)var1_5, var0_2);
                            break;
                        }
                        throw new IOException("TYPE_PING streamId != 0");
                    }
                    throw new IOException(Intrinsics.stringPlus(var3_12, "TYPE_PING length != 8: "));
                }
                case 5: {
                    this.readPushPromise((Http2Reader$Handler)var2_10, var3_12, var5_15, var6_19);
                    break;
                }
                case 4: {
                    if (var6_19 == 0) {
                        if ((var5_15 & 1) != 0) {
                            if (var3_12 == 0) break;
                            throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
                        }
                        if (var3_12 % 6 == 0) {
                            var1_7 = v2;
                            v2 = new Settings();
                            v3 = RangesKt___RangesKt.step(RangesKt___RangesKt.until(0, var3_12), 6);
                            var3_12 = v3.first;
                            var4_13 = v3.last;
                            var5_15 = v3.step;
                            if (var5_15 > 0 && var3_12 <= var4_13 || var5_15 < 0 && var4_13 <= var3_12) {
                                while (true) {
                                    var6_19 = var3_12 + var5_15;
                                    var7_22 = this.source.readShort() & 65535;
                                    var8_26 = this.source.readInt();
                                    switch (var7_22) {
                                        default: {
                                            break;
                                        }
                                        case 5: {
                                            if (var8_26 >= 16384 && var8_26 <= 0xFFFFFF) break;
                                            throw new IOException(Intrinsics.stringPlus(var8_26, "PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: "));
                                        }
                                        case 4: {
                                            var7_22 = 7;
                                            if (var8_26 >= 0) break;
                                            throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                                        }
                                        case 3: {
                                            var7_22 = 4;
                                            break;
                                        }
                                        case 2: {
                                            if (var8_26 == 0 || var8_26 == 1) break;
                                            throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                                        }
                                    }
                                    var1_7.set(var7_22, var8_26);
                                    if (var3_12 == var4_13) break;
                                    var3_12 = var6_19;
                                }
                            }
                            this = (Http2Connection$ReaderRunnable)var2_10;
                            v4 = this.this$0;
                            var2_10 = v4;
                            var2_10 = Intrinsics.stringPlus(" applyAndAckSettings", var2_10.connectionName);
                            v4.writerQueue.schedule(new Http2Connection$ReaderRunnable$settings$$inlined$execute$default$1((String)var2_10, (Http2Connection$ReaderRunnable)this, var1_7), 0L);
                            break;
                        }
                        throw new IOException(Intrinsics.stringPlus(var3_12, "TYPE_SETTINGS length % 6 != 0: "));
                    }
                    throw new IOException("TYPE_SETTINGS streamId != 0");
                }
                case 3: {
                    if (var3_12 != 4) ** GOTO lbl154
                    if (var6_19 == 0) ** GOTO lbl153
                    var0_3 = this.source.readInt();
                    for (ErrorCode var5_17 : (ErrorCode[])ErrorCode.$VALUES.clone()) {
                        if (!(var5_17.httpCode == var0_3)) {
                            continue;
                        }
                        ** GOTO lbl127
                    }
                    var5_17 = null;
lbl127:
                    // 2 sources

                    if (var5_17 == null) ** GOTO lbl152
                    var0_4 = (Http2Connection$ReaderRunnable)var2_10;
                    var0_4.this$0.getClass();
                    if (Http2Connection.pushedStream$okhttp(var6_19)) {
                        var0_4 = var0_4.this$0;
                        var0_4.getClass();
                        var1_8 /* !! */  = var0_4.connectionName + '[' + var6_19 + "] onReset";
                        var0_4.pushQueue.schedule(new Http2Connection$pushResetLater$$inlined$execute$default$1((String)var1_8 /* !! */ , (Http2Connection)var0_4, var6_19, var5_17), 0L);
                        break;
                    }
                    var0_4 = var0_4.this$0.removeStream$okhttp(var6_19);
                    if (var0_4 == null) break;
                    v5 = var0_4;
                    synchronized (v5) {
                        if (v5.errorCode != null) ** GOTO lbl150
                        var0_4.errorCode = var5_17;
                        var0_4.notifyAll();
lbl150:
                        // 2 sources

                        // ** MonitorExit[var0_4] (shouldn't be in output)
                        break;
                    }
lbl152:
                    // 1 sources

                    throw new IOException(Intrinsics.stringPlus(var0_3, "TYPE_RST_STREAM unexpected error code: "));
lbl153:
                    // 1 sources

                    throw new IOException("TYPE_RST_STREAM streamId == 0");
lbl154:
                    // 1 sources

                    throw new IOException("TYPE_RST_STREAM length: " + var3_12 + " != 4");
                }
                case 2: {
                    if (var3_12 == 5) {
                        if (var6_19 != 0) {
                            this.source.readInt();
                            this.source.readByte();
                            break;
                        }
                        throw new IOException("TYPE_PRIORITY streamId == 0");
                    }
                    throw new IOException("TYPE_PRIORITY length: " + var3_12 + " != 5");
                }
                case 1: {
                    if (var6_19 != 0) {
                        var1_5 = (var5_15 & 1) != 0;
                        var4_13 = (var5_15 & 8) != 0 ? this.source.readByte() & 255 : 0;
                        if ((var5_15 & 32) != 0) {
                            this.source.readInt();
                            this.source.readByte();
                            var3_12 -= 5;
                        }
                        this = this.readHeaderBlock(Http2Reader$Companion.lengthWithoutPadding(var3_12, var5_15, var4_13), var4_13, var5_15, var6_19);
                        ((Http2Connection$ReaderRunnable)var2_10).headers(var1_5, var6_19, (List)this);
                        break;
                    }
                    throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
                }
                case 0: {
                    if (var6_19 != 0) {
                        var1_5 = (var5_15 & 1) != 0;
                        if (!((var5_15 & 32) != 0)) {
                            var4_13 = (var5_15 & 8) != 0 ? this.source.readByte() & 255 : 0;
                            var3_12 = Http2Reader$Companion.lengthWithoutPadding(var3_12, var5_15, var4_13);
                            var5_18 = this.source;
                            var2_10 = (Http2Connection$ReaderRunnable)var2_10;
                            Intrinsics.checkNotNullParameter(var5_18, "source");
                            var2_10.this$0.getClass();
                            if (Http2Connection.pushedStream$okhttp(var6_19)) {
                                v7 = var5_18;
                                var2_10 = var2_10.this$0;
                                var2_10.getClass();
                                var5_18 = v8;
                                v8 = new Buffer();
                                var7_23 = var3_12;
                                v7.require(var7_23);
                                v7.read((Buffer)var5_18, var7_23);
                                var7_24 = var2_10.connectionName + '[' + var6_19 + "] onData";
                                var2_10.pushQueue.schedule(new Http2Connection$pushDataLater$$inlined$execute$default$1(var7_24, (Http2Connection)var2_10, var6_19, (Buffer)var5_18, var3_12, var1_5), 0L);
                            } else {
                                var7_20 = var2_10.this$0.getStream(var6_19);
                                if (var7_20 == null) {
                                    v9 = var2_10;
                                    v9.this$0.writeSynResetLater$okhttp(var6_19, ErrorCode.PROTOCOL_ERROR);
                                    var1_9 = var3_12;
                                    v9.this$0.updateConnectionFlowControl$okhttp(var1_9);
                                    var5_18.skip(var1_9);
                                } else {
                                    if (Util.assertionsEnabled && Thread.holdsLock(var7_20)) {
                                        throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var7_20));
                                    }
                                    var7_20.source.receive$okhttp(var5_18, var3_12);
                                    if (var1_5) {
                                        var7_20.receiveHeaders(Util.EMPTY_HEADERS, true);
                                    }
                                }
                            }
                            this.source.skip(var4_13);
                            break;
                        }
                        throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
                    }
                    throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
                }
            }
            return true;
        }
        throw new IOException(Intrinsics.stringPlus(var3_12, "FRAME_SIZE_ERROR: "));
    }

    @Override
    public final void close() {
        this.source.close();
    }

    public final List readHeaderBlock(int n, int n2, int n3, int n4) {
        Http2Reader http2Reader = hpack$Reader2;
        Http2Reader$ContinuationSource http2Reader$ContinuationSource = http2Reader.continuation;
        http2Reader$ContinuationSource.left = n;
        http2Reader$ContinuationSource.length = n;
        http2Reader$ContinuationSource.padding = n2;
        http2Reader$ContinuationSource.flags = n3;
        http2Reader$ContinuationSource.streamId = n4;
        Hpack$Reader hpack$Reader = http2Reader.hpackReader;
        while (!hpack$Reader.source.exhausted()) {
            block19: {
                int n5;
                block24: {
                    block27: {
                        ByteString byteString;
                        block26: {
                            block25: {
                                block20: {
                                    block23: {
                                        Header header;
                                        ByteString byteString2;
                                        block22: {
                                            block21: {
                                                n2 = hpack$Reader.source.readByte() & 0xFF;
                                                if (n2 == 128) break block19;
                                                if ((n2 & 0x80) == 128) {
                                                    n3 = (n2 = hpack$Reader.readInt(n2, 127) - 1) >= 0 && n2 <= Hpack.STATIC_HEADER_TABLE.length - 1 ? 1 : 0;
                                                    if (n3 != 0) {
                                                        hpack$Reader.headerList.add(Hpack.STATIC_HEADER_TABLE[n2]);
                                                        continue;
                                                    }
                                                    n3 = hpack$Reader.nextHeaderIndex + 1 + (n2 - Hpack.STATIC_HEADER_TABLE.length);
                                                    if (n3 >= 0) {
                                                        Header[] headerArray = hpack$Reader.dynamicTable;
                                                        if (n3 < hpack$Reader.dynamicTable.length) {
                                                            ArrayList arrayList = hpack$Reader.headerList;
                                                            Header header2 = headerArray[n3];
                                                            Intrinsics.checkNotNull(header2);
                                                            arrayList.add(header2);
                                                            continue;
                                                        }
                                                    }
                                                    throw new IOException(Intrinsics.stringPlus(n2 + 1, "Header index too large "));
                                                }
                                                if (n2 == 64) {
                                                    Header header3;
                                                    ByteString byteString3 = hpack$Reader.readByteString();
                                                    Intrinsics.checkNotNullParameter(byteString3, "name");
                                                    n3 = 0;
                                                    n4 = byteString3.getSize$okio();
                                                    while (n3 < n4) {
                                                        n5 = n3 + 1;
                                                        if (!(65 <= (n3 = (int)byteString3.internalGet$okio(n3)) && n3 <= 90)) {
                                                            n3 = n5;
                                                            continue;
                                                        }
                                                        throw new IOException(Intrinsics.stringPlus(byteString3.utf8(), "PROTOCOL_ERROR response malformed: mixed case name: "));
                                                    }
                                                    ByteString byteString4 = hpack$Reader.readByteString();
                                                    Header header4 = header3;
                                                    header3 = new Header(byteString3, byteString4);
                                                    hpack$Reader.insertIntoDynamicTable(header4);
                                                    continue;
                                                }
                                                if ((n2 & 0x40) != 64) break block20;
                                                if (!((n2 = hpack$Reader.readInt(n2, 63) - 1) >= 0 && n2 <= Hpack.STATIC_HEADER_TABLE.length - 1)) break block21;
                                                byteString2 = Hpack.STATIC_HEADER_TABLE[n2].name;
                                                break block22;
                                            }
                                            n3 = hpack$Reader.nextHeaderIndex + 1 + (n2 - Hpack.STATIC_HEADER_TABLE.length);
                                            if (n3 < 0) break block23;
                                            Header[] headerArray = hpack$Reader.dynamicTable;
                                            if (n3 >= hpack$Reader.dynamicTable.length) break block23;
                                            Header header5 = headerArray[n3];
                                            Intrinsics.checkNotNull(header5);
                                            byteString2 = header5.name;
                                        }
                                        ByteString byteString5 = hpack$Reader.readByteString();
                                        Header header6 = header;
                                        header = new Header(byteString2, byteString5);
                                        hpack$Reader.insertIntoDynamicTable(header6);
                                        continue;
                                    }
                                    throw new IOException(Intrinsics.stringPlus(n2 + 1, "Header index too large "));
                                }
                                if ((n2 & 0x20) == 32) {
                                    hpack$Reader.maxDynamicTableByteCount = n2 = hpack$Reader.readInt(n2, 31);
                                    if (n2 >= 0 && n2 <= hpack$Reader.headerTableSizeSetting) {
                                        n3 = hpack$Reader.dynamicTableByteCount;
                                        if (n2 >= n3) continue;
                                        if (n2 == 0) {
                                            Arrays.fill(hpack$Reader.dynamicTable, 0, hpack$Reader.dynamicTable.length, null);
                                            hpack$Reader.nextHeaderIndex = hpack$Reader.dynamicTable.length - 1;
                                            hpack$Reader.headerCount = 0;
                                            hpack$Reader.dynamicTableByteCount = 0;
                                            continue;
                                        }
                                        hpack$Reader.evictToRecoverBytes(n3 - n2);
                                        continue;
                                    }
                                    throw new IOException(Intrinsics.stringPlus(hpack$Reader.maxDynamicTableByteCount, "Invalid dynamic table size update "));
                                }
                                if (n2 == 16 || n2 == 0) break block24;
                                if (!((n2 = hpack$Reader.readInt(n2, 15) - 1) >= 0 && n2 <= Hpack.STATIC_HEADER_TABLE.length - 1)) break block25;
                                byteString = Hpack.STATIC_HEADER_TABLE[n2].name;
                                break block26;
                            }
                            n3 = hpack$Reader.nextHeaderIndex + 1 + (n2 - Hpack.STATIC_HEADER_TABLE.length);
                            if (n3 < 0) break block27;
                            Header[] headerArray = hpack$Reader.dynamicTable;
                            if (n3 >= hpack$Reader.dynamicTable.length) break block27;
                            Header header = headerArray[n3];
                            Intrinsics.checkNotNull(header);
                            byteString = header.name;
                        }
                        ByteString byteString6 = hpack$Reader.readByteString();
                        hpack$Reader.headerList.add(new Header(byteString, byteString6));
                        continue;
                    }
                    throw new IOException(Intrinsics.stringPlus(n2 + 1, "Header index too large "));
                }
                ByteString byteString = hpack$Reader.readByteString();
                Intrinsics.checkNotNullParameter(byteString, "name");
                n3 = 0;
                n4 = byteString.getSize$okio();
                while (n3 < n4) {
                    n5 = n3 + 1;
                    if (!(65 <= (n3 = (int)byteString.internalGet$okio(n3)) && n3 <= 90)) {
                        n3 = n5;
                        continue;
                    }
                    throw new IOException(Intrinsics.stringPlus(byteString.utf8(), "PROTOCOL_ERROR response malformed: mixed case name: "));
                }
                ByteString byteString7 = hpack$Reader.readByteString();
                hpack$Reader.headerList.add(new Header(byteString, byteString7));
                continue;
            }
            throw new IOException("index == 0");
        }
        Hpack$Reader hpack$Reader2 = ((Http2Reader)((Object)hpack$Reader2)).hpackReader;
        List list = CollectionsKt.toList(hpack$Reader2.headerList);
        hpack$Reader2.headerList.clear();
        return list;
    }

    public final void readPushPromise(Http2Reader$Handler object, int n, int n2, int n3) {
        if (n3 != 0) {
            int n4 = (n2 & 8) != 0 ? this.source.readByte() & 0xFF : 0;
            Http2Reader$Handler http2Reader$Handler = object;
            int n5 = this.source.readInt() & Integer.MAX_VALUE;
            object = this.readHeaderBlock(Http2Reader$Companion.lengthWithoutPadding(n - 4, n2, n4), n4, n2, n3);
            Http2Connection$ReaderRunnable http2Connection$ReaderRunnable = (Http2Connection$ReaderRunnable)http2Reader$Handler;
            http2Connection$ReaderRunnable.getClass();
            Http2Connection http2Connection = http2Connection$ReaderRunnable.this$0;
            http2Connection.getClass();
            synchronized (http2Connection) {
                block6: {
                    if (!http2Connection.currentPushRequests.contains(n5)) break block6;
                    Http2Connection http2Connection2 = http2Connection;
                    http2Connection2.writeSynResetLater$okhttp(n5, ErrorCode.PROTOCOL_ERROR);
                    // ** MonitorExit[v3] (shouldn't be in output)
                }
                Http2Connection http2Connection3 = http2Connection;
                Http2Connection http2Connection4 = http2Connection3;
                Http2Connection http2Connection5 = http2Connection3;
                http2Connection3.currentPushRequests.add(n5);
                String string = http2Connection.connectionName + '[' + n5 + "] onRequest";
                http2Connection4.pushQueue.schedule(new Http2Connection$pushRequestLater$$inlined$execute$default$1(string, http2Connection, n5, (List)object), 0L);
                return;
            }
        }
        throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
    }
}

