/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.platform.android;

import android.net.ssl.SSLSockets;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.Platform$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.Android10SocketAdapter$Companion;
import com.apollographql.apollo3.relocated.okhttp3.internal.platform.android.SocketAdapter;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public final class Android10SocketAdapter
implements SocketAdapter {
    @Override
    public final boolean matchesSocket(SSLSocket sSLSocket) {
        return SSLSockets.isSupportedSocket((SSLSocket)sSLSocket);
    }

    @Override
    public final boolean isSupported() {
        return Android10SocketAdapter$Companion.isSupported();
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        Object object = sSLSocket.getApplicationProtocol();
        if (object == null ? true : Intrinsics.areEqual(object, "")) {
            object = null;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String stringArray, List list) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(list, "protocols");
        try {
            SSLSockets.setUseSessionTickets((SSLSocket)sSLSocket2, (boolean)true);
            SSLParameters sSLParameters = sSLSocket2.getSSLParameters();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Android internal error", illegalArgumentException);
        }
        stringArray = Platform$Companion.alpnProtocolNames(list).toArray(new String[0]);
        if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        SSLParameters sSLParameters = sSLParameters;
        sSLParameters.setApplicationProtocols(stringArray);
        sSLSocket.setSSLParameters(sSLParameters);
    }
}

