/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.org.objectweb.asm;

import com.apollographql.apollo3.relocated.org.objectweb.asm.ByteVector;
import com.apollographql.apollo3.relocated.org.objectweb.asm.Edge;
import com.apollographql.apollo3.relocated.org.objectweb.asm.Frame;

public final class Label {
    public static final Label EMPTY_LIST = new Label();
    public short flags;
    public short lineNumber;
    public int[] otherLineNumbers;
    public int bytecodeOffset;
    public int[] forwardReferences;
    public short inputStackSize;
    public short outputStackSize;
    public short outputStackMax;
    public short subroutineId;
    public Frame frame;
    public Label nextBasicBlock;
    public Edge outgoingEdges;
    public Label nextListElement;

    public final Label getCanonicalInstance() {
        Frame frame = label.frame;
        if (frame != null) {
            Label label = frame.owner;
        }
        return label;
    }

    public final void put(ByteVector byteVector, int n, boolean bl) {
        if ((this.flags & 4) == 0) {
            if (bl) {
                int n2 = byteVector.length;
                this.addForwardReference(n, 0x20000000, n2);
                byteVector.putInt(-1);
            } else {
                int n3 = byteVector.length;
                this.addForwardReference(n, 0x10000000, n3);
                byteVector.putShort(-1);
            }
        } else if (bl) {
            byteVector.putInt(this.bytecodeOffset - n);
        } else {
            byteVector.putShort(this.bytecodeOffset - n);
        }
    }

    public final boolean resolve(byte[] byArray, int n) {
        Label label = this;
        this.flags = (short)(this.flags | 4);
        label.bytecodeOffset = n;
        int[] nArray = label.forwardReferences;
        if (label.forwardReferences == null) {
            return false;
        }
        int n2 = 0;
        for (int i = nArray[0]; i > 0; i -= 2) {
            int n3 = this.forwardReferences[i - 1];
            int n4 = this.forwardReferences[i];
            int n5 = n - n3;
            int n6 = n4 & 0xFFFFFFF;
            if ((n4 & 0xF0000000) == 0x10000000) {
                if (n5 < Short.MIN_VALUE || n5 > Short.MAX_VALUE) {
                    n2 = byArray[n3] & 0xFF;
                    byArray[n3] = n2 < 198 ? (byte)(n2 + 49) : (byte)(n2 + 20);
                    n2 = 1;
                }
                n3 = n6 + 1;
                byArray[n6] = (byte)(n5 >>> 8);
                byArray[n3] = (byte)n5;
                continue;
            }
            int n7 = n5;
            int n8 = n5;
            int n9 = n5;
            n3 = n6 + 1;
            byArray[n6] = (byte)(n5 >>> 24);
            n5 = n3 + 1;
            byArray[n3] = (byte)(n9 >>> 16);
            n3 = n5 + 1;
            byArray[n5] = (byte)(n8 >>> 8);
            byArray[n3] = (byte)n7;
        }
        return n2 != 0;
    }

    public final String toString() {
        return "L" + System.identityHashCode(this);
    }

    public final void addForwardReference(int n, int n2, int n3) {
        int[] nArray;
        int n4;
        if (this.forwardReferences == null) {
            this.forwardReferences = new int[6];
        }
        if ((n4 = this.forwardReferences[0]) + 2 >= (nArray = this.forwardReferences).length) {
            nArray = new int[nArray.length + 6];
            int n5 = nArray.length;
            System.arraycopy(nArray, 0, nArray, 0, n5);
            this.forwardReferences = nArray;
        }
        int[] nArray2 = this.forwardReferences;
        int n6 = n4 + 1;
        nArray2[n6] = n;
        nArray2[++n6] = n2 | n3;
        this.forwardReferences[0] = n6;
    }
}

