/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.kotlin.collections;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.ArrayIterator;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.CollectionToArray;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.markers.KMappedMarker;
import java.util.Collection;
import java.util.Iterator;

public final class ArrayAsCollection
implements Collection,
KMappedMarker {
    public final Object[] values;
    public final boolean isVarargs;

    public ArrayAsCollection(Object[] objectArray, boolean bl) {
        Intrinsics.checkNotNullParameter(objectArray, "values");
        this.values = objectArray;
        this.isVarargs = bl;
    }

    @Override
    public final boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public final boolean contains(Object object) {
        return ArraysKt.contains(this.values, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsAll(Collection iterator2) {
        Object t;
        Iterator iterator3 = iterator2;
        Intrinsics.checkNotNullParameter(iterator3, "elements");
        if (iterator3.isEmpty()) {
            return true;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (ArraysKt.contains(this.values, t = iterator2.next()));
        return false;
    }

    @Override
    public final Iterator iterator() {
        Object[] objectArray = objectArray.values;
        Intrinsics.checkNotNullParameter(objectArray.values, "array");
        return new ArrayIterator(objectArray);
    }

    @Override
    public final Object[] toArray() {
        return CollectionsKt__CollectionsJVMKt.copyToArrayOfAny(this.values, this.isVarargs);
    }

    public final boolean add(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public final boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public final boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public final boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public final int size() {
        return this.values.length;
    }

    public final Object[] toArray(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "array");
        return CollectionToArray.toArray(this, objectArray);
    }
}

