/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.concurrent;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.Task;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskLoggerKt;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner$Companion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class TaskQueue {
    public final TaskRunner taskRunner;
    public final String name;
    public boolean shutdown;
    public Task activeTask;
    public final ArrayList futureTasks;
    public boolean cancelActiveTask;

    public TaskQueue(TaskRunner taskRunner, String string) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(string, "name");
        ((TaskQueue)((Object)arrayList2)).taskRunner = taskRunner;
        ((TaskQueue)((Object)arrayList2)).name = string;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.futureTasks = arrayList2;
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    /*
     * Unable to fully structure code
     */
    public final void schedule(Task var1_1, long var2_2) {
        v0 = this;
        Intrinsics.checkNotNullParameter(var1_1, "task");
        var4_3 = v0.taskRunner;
        synchronized (var4_3) {
            block10: {
                if (!v0.shutdown) ** GOTO lbl24
                if (!var1_1.getCancelable()) break block10;
                ** try [egrp 2[TRYBLOCK] [2 : 28->31)] { 
lbl12:
                // 1 sources

                if (!TaskRunner$Companion.getLogger().isLoggable(Level.FINE)) ** GOTO lbl17
                TaskLoggerKt.access$log(var1_1, this, "schedule canceled (queue is shutdown)");
lbl17:
                // 2 sources

                return;
            }
            if (!TaskRunner$Companion.getLogger().isLoggable(Level.FINE)) ** GOTO lbl23
            TaskLoggerKt.access$log(var1_1, this, "schedule failed (queue is shutdown)");
lbl23:
            // 2 sources

            throw new RejectedExecutionException();
lbl24:
            // 1 sources

            if (!this.scheduleAndDecide$okhttp(var1_1, var2_2, false)) ** GOTO lbl27
            this.taskRunner.kickCoordinator$okhttp(this);
lbl27:
            // 2 sources

            v2 = var4_3;
            return;
        }
    }

    public final boolean scheduleAndDecide$okhttp(Task task, long l, boolean n) {
        block10: {
            block8: {
                block9: {
                    Task task2 = task;
                    Intrinsics.checkNotNullParameter(task2, "task");
                    TaskQueue taskQueue = task2.queue;
                    if (taskQueue == this) break block9;
                    if (!(taskQueue == null)) break block10;
                    task.queue = this;
                }
                TaskQueue taskQueue = this;
                taskQueue.taskRunner.backend.getClass();
                long l2 = System.nanoTime();
                long l3 = l2 + l;
                int n2 = taskQueue.futureTasks.indexOf(task);
                if (n2 != -1) {
                    if (task.nextExecuteNanoTime <= l3) {
                        if (TaskRunner.logger.isLoggable(Level.FINE)) {
                            TaskLoggerKt.access$log(task, this, "already scheduled");
                        }
                        return false;
                    }
                    this.futureTasks.remove(n2);
                }
                task.nextExecuteNanoTime = l3;
                if (TaskRunner.logger.isLoggable(Level.FINE)) {
                    String string = n != 0 ? Intrinsics.stringPlus(TaskLoggerKt.formatDuration(l3 - l2), "run again after ") : Intrinsics.stringPlus(TaskLoggerKt.formatDuration(l3 - l2), "scheduled after ");
                    TaskLoggerKt.access$log(task, this, string);
                }
                n = 0;
                Iterator iterator2 = this.futureTasks.iterator();
                while (iterator2.hasNext()) {
                    if (!(((Task)iterator2.next()).nextExecuteNanoTime - l2 > l)) {
                        ++n;
                        continue;
                    }
                    break block8;
                }
                n = -1;
            }
            if (n == -1) {
                n = this.futureTasks.size();
            }
            this.futureTasks.add(n, task);
            return n == 0;
        }
        throw new IllegalStateException("task is in multiple queues".toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelAll() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            taskQueue.shutdown = true;
            if (taskQueue.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            TaskRunner taskRunner2 = taskRunner;
            return;
        }
    }

    public final boolean cancelAllAndDecide$okhttp() {
        Task task = this.activeTask;
        if (task != null && task.cancelable) {
            this.cancelActiveTask = true;
        }
        boolean bl = false;
        int n = this.futureTasks.size() - 1;
        if (n >= 0) {
            while (true) {
                int n2 = n + -1;
                if (((Task)this.futureTasks.get((int)n)).cancelable) {
                    Task task2 = (Task)this.futureTasks.get(n);
                    if (TaskRunner.logger.isLoggable(Level.FINE)) {
                        TaskLoggerKt.access$log(task2, this, "canceled");
                    }
                    bl = true;
                    this.futureTasks.remove(n);
                }
                if (n2 < 0) break;
                n = n2;
            }
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }
}

