/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u00110\u0011H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001b\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\n\u0010#\u001a\u00060$j\u0002`%J\u0018\u0010&\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "()V", "recordJournals", "", "", "Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RecordJournal;", "addOptimisticUpdate", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "addOptimisticUpdates", "recordSet", "", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "keys", "merge", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "removeOptimisticUpdates", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "mergeJournalRecord", "RecordJournal", "RemovalResult", "apollo-normalized-cache-api"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nOptimisticCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimisticCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n1192#2,2:195\n1220#2,4:197\n1601#2,9:201\n1849#2:210\n1850#2:212\n1610#2:213\n1358#2:214\n1444#2,5:215\n1236#2,4:222\n1#3:211\n438#4:220\n388#4:221\n*S KotlinDebug\n*F\n+ 1 OptimisticCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache\n*L\n27#1:195,2\n27#1:197,4\n28#1:201,9\n28#1:210\n28#1:212\n28#1:213\n79#1:214\n79#1:215,5\n112#1:222,4\n28#1:211\n112#1:220\n112#1:221\n*E\n"})
public final class OptimisticCache
extends NormalizedCache {
    @NotNull
    private final Map<String, RecordJournal> recordJournals = new LinkedHashMap();

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            NormalizedCache normalizedCache = this.getNextCache();
            Record nonOptimisticRecord = normalizedCache != null ? normalizedCache.loadRecord(key, cacheHeaders) : null;
            record = this.mergeJournalRecord(nonOptimisticRecord, key);
        }
        catch (Exception ignore) {
            record = null;
        }
        return record;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Map map;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Object object = this.getNextCache();
        if (object != null && (object = object.loadRecords(keys, cacheHeaders)) != null) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = (Iterable)object;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Record record = (Record)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getKey(), element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        Map nonOptimisticRecords = map;
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Record it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.mergeJournalRecord((Record)nonOptimisticRecords.get(key), key) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Object object = this.getNextCache();
        if (object == null || (object = ((NormalizedCache)object).merge(record, cacheHeaders)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Object object = this.getNextCache();
        if (object == null || (object = ((NormalizedCache)object).merge(records, cacheHeaders)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    public void clearAll() {
        block0: {
            this.recordJournals.clear();
            NormalizedCache normalizedCache = this.getNextCache();
            if (normalizedCache == null) break block0;
            normalizedCache.clearAll();
        }
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        NormalizedCache normalizedCache = this.getNextCache();
        boolean result = normalizedCache != null ? normalizedCache.remove(cacheKey, cascade) : false;
        RecordJournal recordJournal = this.recordJournals.get(cacheKey.getKey());
        if (recordJournal != null) {
            this.recordJournals.remove(cacheKey.getKey());
            result = true;
            if (cascade) {
                for (CacheKey cacheReference : recordJournal.getCurrent().referencedFields()) {
                    result = result && this.remove(new CacheKey(cacheReference.getKey()), true);
                }
            }
        }
        return result;
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = NormalizedCache.Companion.patternToRegex(pattern);
        int total = 0;
        Iterator<Map.Entry<String, RecordJournal>> iterator = this.recordJournals.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RecordJournal> entry = iterator.next();
            if (!regex.matches((CharSequence)entry.getKey())) continue;
            iterator.remove();
            ++total;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return total + chainRemoved;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> addOptimisticUpdates(@NotNull Collection<Record> recordSet) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(recordSet, (String)"recordSet");
        Iterable $this$flatMap$iv = recordSet;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.addOptimisticUpdate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<String> addOptimisticUpdate(@NotNull Record record) {
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        RecordJournal journal = this.recordJournals.get(record.getKey());
        if (journal == null) {
            this.recordJournals.put(record.getKey(), new RecordJournal(record));
            set = record.fieldKeys();
        } else {
            set = journal.addPatch(record);
        }
        return set;
    }

    @NotNull
    public final Set<String> removeOptimisticUpdates(@NotNull UUID mutationId) {
        Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
        Set changedCacheKeys = new LinkedHashSet();
        Iterator<Map.Entry<String, RecordJournal>> iterator = this.recordJournals.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RecordJournal> entry = iterator.next();
            RemovalResult result = entry.getValue().removePatch(mutationId);
            changedCacheKeys.addAll((Collection)result.getChangedKeys());
            if (!result.isEmpty()) continue;
            iterator.remove();
        }
        return changedCacheKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, RecordJournal> map = this.recordJournals;
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            RecordJournal journal = (RecordJournal)entry2.getValue();
            Record record = journal.getCurrent();
            map3.put(k, record);
        }
        Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map5 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map4, map5);
    }

    private final Record mergeJournalRecord(Record $this$mergeJournalRecord, String key) {
        Object object;
        RecordJournal journal = this.recordJournals.get(key);
        if (journal != null) {
            object = $this$mergeJournalRecord;
            if (object == null || (object = object.mergeWith(journal.getCurrent())) == null || (object = (Record)object.getFirst()) == null) {
                object = journal.getCurrent();
            }
        } else {
            object = $this$mergeJournalRecord;
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RecordJournal;", "", "record", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;)V", "current", "getCurrent", "()Lcom/apollographql/apollo3/cache/normalized/api/Record;", "setCurrent", "patches", "", "addPatch", "", "", "removePatch", "Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RemovalResult;", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "apollo-normalized-cache-api"})
    @SourceDebugExtension(value={"SMAP\nOptimisticCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimisticCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RecordJournal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n348#2,7:195\n*S KotlinDebug\n*F\n+ 1 OptimisticCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RecordJournal\n*L\n158#1:195,7\n*E\n"})
    private static final class RecordJournal {
        @NotNull
        private Record current;
        @NotNull
        private final List<Record> patches;

        public RecordJournal(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.current = record;
            Object[] objectArray = new Record[]{record};
            this.patches = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @NotNull
        public final Record getCurrent() {
            return this.current;
        }

        public final void setCurrent(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"<set-?>");
            this.current = record;
        }

        @NotNull
        public final Set<String> addPatch(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Pair<Record, Set<String>> pair = this.current.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.current = mergedRecord;
            this.patches.add(record);
            return changedKeys;
        }

        @NotNull
        public final RemovalResult removePatch(@NotNull UUID mutationId) {
            int start;
            int recordIndex;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
                List<Record> $this$indexOfFirst$iv = this.patches;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Record> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Record item$iv;
                    Record it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)mutationId, (Object)it.getMutationId())) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = recordIndex = -1;
            }
            if (recordIndex == -1) {
                return new RemovalResult(SetsKt.emptySet(), false);
            }
            if (this.patches.size() == 1) {
                return new RemovalResult(this.current.fieldKeys(), true);
            }
            Record oldRecord = this.current;
            this.patches.remove(recordIndex).getKey();
            Record cur = null;
            int n = this.patches.size();
            for (int i = start = Math.max(0, recordIndex - 1); i < n; ++i) {
                Record mergedRecord;
                Record record = this.patches.get(i);
                cur = cur == null ? record : (mergedRecord = (Record)cur.mergeWith(record).component1());
            }
            Record record = cur;
            Intrinsics.checkNotNull(record);
            this.current = record;
            return new RemovalResult(Record.Companion.changedKeys$apollo_normalized_cache_api(oldRecord, this.current), false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/OptimisticCache$RemovalResult;", "", "changedKeys", "", "", "isEmpty", "", "(Ljava/util/Set;Z)V", "getChangedKeys", "()Ljava/util/Set;", "()Z", "apollo-normalized-cache-api"})
    private static final class RemovalResult {
        @NotNull
        private final Set<String> changedKeys;
        private final boolean isEmpty;

        public RemovalResult(@NotNull Set<String> changedKeys, boolean isEmpty) {
            Intrinsics.checkNotNullParameter(changedKeys, (String)"changedKeys");
            this.changedKeys = changedKeys;
            this.isEmpty = isEmpty;
        }

        @NotNull
        public final Set<String> getChangedKeys() {
            return this.changedKeys;
        }

        public final boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

