/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava.printer;

import com.apollographql.federation.graphqljava.FederationDirectives;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.SchemaPrinter;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ServiceSDLPrinter {
    private ServiceSDLPrinter() {
    }

    @Deprecated(since="05/16/2024")
    public static String generateServiceSDL(GraphQLSchema schema, final boolean queryTypeShouldBeEmpty) {
        HashSet<Object> hiddenDirectiveDefinitions = new HashSet<Object>();
        hiddenDirectiveDefinitions.addAll(DirectiveInfo.GRAPHQL_SPECIFICATION_DIRECTIVE_MAP.keySet());
        hiddenDirectiveDefinitions.addAll(FederationDirectives.allNames);
        HashSet<String> hiddenTypeDefinitions = new HashSet<String>();
        hiddenTypeDefinitions.add("_Any");
        hiddenTypeDefinitions.add("_Entity");
        hiddenTypeDefinitions.add("_FieldSet");
        hiddenTypeDefinitions.add("_Service");
        final String queryTypeName = schema.getQueryType().getName();
        final GraphqlFieldVisibility oldFieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        GraphqlFieldVisibility newFieldVisibility = new GraphqlFieldVisibility(){

            public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
                if (fieldsContainer.getName().equals(queryTypeName)) {
                    if (queryTypeShouldBeEmpty) {
                        return Collections.emptyList();
                    }
                    return fieldsContainer.getFieldDefinitions().stream().filter(field -> !"_service".equals(field.getName()) && !"_entities".equals(field.getName())).collect(Collectors.toList());
                }
                return oldFieldVisibility.getFieldDefinitions(fieldsContainer);
            }

            public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
                if (fieldsContainer.getName().equals(queryTypeName) && (queryTypeShouldBeEmpty || "_service".equals(fieldName) || "_entities".equals(fieldName))) {
                    return null;
                }
                return oldFieldVisibility.getFieldDefinition(fieldsContainer, fieldName);
            }
        };
        GraphQLCodeRegistry newCodeRegistry = schema.getCodeRegistry().transform(codeRegistryBuilder -> codeRegistryBuilder.fieldVisibility(newFieldVisibility));
        GraphQLSchema federatedSchema = schema.transform(schemaBuilder -> schemaBuilder.codeRegistry(newCodeRegistry));
        Predicate<GraphQLSchemaElement> shouldIncludeSchemaElement = element -> !(element instanceof GraphQLDirective && hiddenDirectiveDefinitions.contains(((GraphQLDirective)element).getName()) || element instanceof GraphQLNamedSchemaElement && hiddenTypeDefinitions.contains(((GraphQLNamedSchemaElement)element).getName()));
        SchemaPrinter.Options options = SchemaPrinter.Options.defaultOptions().includeSchemaDefinition(true).includeSchemaElement(shouldIncludeSchemaElement);
        return new SchemaPrinter(options).print(federatedSchema).trim();
    }

    public static String generateServiceSDLV2(GraphQLSchema schema) {
        Predicate<GraphQLSchemaElement> excludeBuiltInDirectiveDefinitions = element -> !(element instanceof GraphQLDirective) || !DirectiveInfo.isGraphqlSpecifiedDirective((GraphQLDirective)((GraphQLDirective)element));
        return new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeSchemaDefinition(true).includeScalarTypes(true).includeSchemaElement(excludeBuiltInDirectiveDefinitions)).print(schema).trim();
    }
}

