/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client;

import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.api.Adapter;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.CustomScalarType;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.MutableExecutionOptions;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.api.http.HttpRequestComposer;
import com.apollographql.java.client.ApolloCall;
import com.apollographql.java.client.ApolloCallback;
import com.apollographql.java.client.ApolloDisposable;
import com.apollographql.java.client.interceptor.ApolloInterceptor;
import com.apollographql.java.client.interceptor.ApolloInterceptorChain;
import com.apollographql.java.client.interceptor.internal.AutoPersistedQueryInterceptor;
import com.apollographql.java.client.interceptor.internal.DefaultInterceptorChain;
import com.apollographql.java.client.internal.Assertions;
import com.apollographql.java.client.internal.DefaultApolloCall;
import com.apollographql.java.client.internal.DefaultApolloDisposable;
import com.apollographql.java.client.network.NetworkTransport;
import com.apollographql.java.client.network.http.HttpEngine;
import com.apollographql.java.client.network.http.HttpInterceptor;
import com.apollographql.java.client.network.http.HttpNetworkTransport;
import com.apollographql.java.client.network.http.internal.BatchingHttpInterceptor;
import com.apollographql.java.client.network.http.internal.OkHttpHttpEngine;
import com.apollographql.java.client.network.ws.WebSocketNetworkTransport;
import com.apollographql.java.client.network.ws.protocol.GraphQLWsProtocol;
import com.apollographql.java.client.network.ws.protocol.WsProtocol;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApolloClient
implements Closeable {
    private Executor executor;
    private List<ApolloInterceptor> interceptors;
    private CustomScalarAdapters customScalarAdapters;
    private NetworkInterceptor networkInterceptor;
    private HttpMethod httpMethod;
    private List<HttpHeader> httpHeaders;
    private Boolean sendApqExtensions;
    private Boolean sendDocument;
    private Boolean enableAutoPersistedQueries;
    private Boolean canBeBatched;

    private ApolloClient(Executor executor, NetworkTransport httpNetworkTransport, NetworkTransport subscriptionNetworkTransport, List<ApolloInterceptor> interceptors, CustomScalarAdapters customScalarAdapters, HttpMethod httpMethod, List<HttpHeader> httpHeaders, Boolean sendApqExtensions, Boolean sendDocument, Boolean enableAutoPersistedQueries, Boolean canBeBatched) {
        this.executor = executor;
        this.interceptors = interceptors;
        this.customScalarAdapters = customScalarAdapters;
        this.httpMethod = httpMethod;
        this.httpHeaders = httpHeaders;
        this.sendApqExtensions = sendApqExtensions;
        this.sendDocument = sendDocument;
        this.enableAutoPersistedQueries = enableAutoPersistedQueries;
        this.canBeBatched = canBeBatched;
        this.networkInterceptor = new NetworkInterceptor(httpNetworkTransport, subscriptionNetworkTransport);
    }

    public <D extends Query.Data> ApolloCall<D> query(@NotNull Query<D> operation) {
        return new DefaultApolloCall<D>(this, operation);
    }

    public <D extends Mutation.Data> ApolloCall<D> mutation(@NotNull Mutation<D> operation) {
        return new DefaultApolloCall<D>(this, operation);
    }

    public <D extends Subscription.Data> ApolloCall<D> subscription(@NotNull Subscription<D> operation) {
        return new DefaultApolloCall<D>(this, operation);
    }

    public <D extends Operation.Data> ApolloDisposable execute(@NotNull ApolloRequest<D> apolloRequest, @NotNull ApolloCallback<D> callback) {
        ApolloRequest.Builder requestBuilder = new ApolloRequest.Builder(apolloRequest.getOperation()).addExecutionContext((ExecutionContext)this.customScalarAdapters).addExecutionContext(apolloRequest.getExecutionContext()).httpMethod(this.httpMethod).httpHeaders(this.httpHeaders).sendApqExtensions(this.sendApqExtensions).sendDocument(this.sendDocument).enableAutoPersistedQueries(this.enableAutoPersistedQueries);
        if (apolloRequest.getHttpMethod() != null) {
            requestBuilder.httpMethod(apolloRequest.getHttpMethod());
        }
        if (apolloRequest.getHttpHeaders() != null) {
            requestBuilder.httpHeaders(apolloRequest.getHttpHeaders());
        }
        if (apolloRequest.getSendApqExtensions() != null) {
            requestBuilder.sendApqExtensions(apolloRequest.getSendApqExtensions());
        }
        if (apolloRequest.getSendDocument() != null) {
            requestBuilder.sendDocument(apolloRequest.getSendDocument());
        }
        if (apolloRequest.getEnableAutoPersistedQueries() != null) {
            requestBuilder.enableAutoPersistedQueries(apolloRequest.getEnableAutoPersistedQueries());
        }
        if (apolloRequest.getCanBeBatched() != null) {
            requestBuilder.addHttpHeader("X-APOLLO-CAN-BE-BATCHED", apolloRequest.getCanBeBatched().toString());
        } else if (this.canBeBatched != null) {
            requestBuilder.addHttpHeader("X-APOLLO-CAN-BE-BATCHED", this.canBeBatched.toString());
        }
        DefaultApolloDisposable disposable = new DefaultApolloDisposable();
        ArrayList<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>(this.interceptors);
        interceptors.add(this.networkInterceptor);
        this.executor.execute(() -> new DefaultInterceptorChain(interceptors, 0, disposable).proceed(requestBuilder.build(), callback));
        return disposable;
    }

    public CustomScalarAdapters getCustomScalarAdapters() {
        return this.customScalarAdapters;
    }

    @Override
    public void close() {
        if (this.executor instanceof ApolloDefaultExecutor) {
            ((ApolloDefaultExecutor)this.executor).shutdown();
        }
    }

    private static Executor defaultExecutor() {
        return new ApolloDefaultExecutor();
    }

    private static class NetworkInterceptor
    implements ApolloInterceptor {
        private NetworkTransport httpNetworkTransport;
        private NetworkTransport subscriptionNetworkTransport;

        private NetworkInterceptor(NetworkTransport httpNetworkTransport, NetworkTransport subscriptionNetworkTransport) {
            this.httpNetworkTransport = httpNetworkTransport;
            this.subscriptionNetworkTransport = subscriptionNetworkTransport;
        }

        @Override
        public <D extends Operation.Data> void intercept(@NotNull ApolloRequest<D> request, @NotNull ApolloInterceptorChain chain, @NotNull ApolloCallback<D> callback) {
            if (request.getOperation() instanceof Query || request.getOperation() instanceof Mutation) {
                this.httpNetworkTransport.execute(request, callback, chain.getDisposable());
            } else {
                this.subscriptionNetworkTransport.execute(request, callback, chain.getDisposable());
            }
        }
    }

    private static class ApolloDefaultExecutor
    implements Executor {
        private final ExecutorService executor = Executors.newCachedThreadPool(runnable -> new Thread(runnable, "Apollo Dispatcher"));

        private ApolloDefaultExecutor() {
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.executor.execute(command);
        }

        public void shutdown() {
            this.executor.shutdown();
        }
    }

    @ApolloExperimental
    static interface RetryOnError {
        public boolean retryOnError(ApolloRequest var1);
    }

    public static class Builder
    implements MutableExecutionOptions<Builder> {
        private HttpEngine httpEngine;
        private NetworkTransport networkTransport;
        private NetworkTransport subscriptionNetworkTransport;
        private String httpServerUrl;
        private String webSocketServerUrl;
        private Call.Factory callFactory;
        private WebSocket.Factory webSocketFactory;
        private Executor executor;
        private List<ApolloInterceptor> interceptors = new ArrayList<ApolloInterceptor>();
        private List<HttpInterceptor> httpInterceptors = new ArrayList<HttpInterceptor>();
        private WsProtocol.Factory wsProtocolFactory;
        private List<HttpHeader> wsHeaders = new ArrayList<HttpHeader>();
        private WebSocketNetworkTransport.ReopenWhen wsReopenWhen;
        private Long wsIdleTimeoutMillis;
        private final CustomScalarAdapters.Builder customScalarAdaptersBuilder = new CustomScalarAdapters.Builder();
        private ExecutionContext executionContext;
        private HttpMethod httpMethod;
        private final ArrayList<HttpHeader> httpHeaders = new ArrayList();
        private Boolean sendApqExtensions;
        private Boolean sendDocument;
        private Boolean enableAutoPersistedQueries;
        private Boolean canBeBatched;
        private Boolean httpExposeErrorBody;
        private Boolean retryOnError;

        public Builder serverUrl(String serverUrl) {
            this.httpServerUrl = serverUrl;
            return this;
        }

        public Builder httpServerUrl(String httpServerUrl) {
            this.httpServerUrl = httpServerUrl;
            return this;
        }

        public Builder webSocketServerUrl(String webSocketServerUrl) {
            this.webSocketServerUrl = webSocketServerUrl;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.callFactory = okHttpClient;
            this.webSocketFactory = okHttpClient;
            return this;
        }

        public Builder callFactory(Call.Factory factory) {
            this.callFactory = factory;
            return this;
        }

        public Builder webSocketFactory(WebSocket.Factory factory) {
            this.webSocketFactory = factory;
            return this;
        }

        public Builder dispatcher(Executor dispatcher) {
            this.executor = dispatcher;
            return this;
        }

        public Builder addInterceptor(ApolloInterceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder addInterceptors(@NotNull List<ApolloInterceptor> interceptors) {
            this.interceptors.addAll((Collection<ApolloInterceptor>)Assertions.checkNotNull(interceptors, "interceptors is null"));
            return this;
        }

        public Builder interceptors(@NotNull List<ApolloInterceptor> interceptors) {
            this.interceptors = Assertions.checkNotNull(interceptors, "interceptors is null");
            return this;
        }

        public Builder addHttpInterceptor(@NotNull HttpInterceptor interceptor) {
            this.httpInterceptors.add(Assertions.checkNotNull(interceptor, "interceptor is null"));
            return this;
        }

        public Builder addHttpInterceptors(@NotNull List<HttpInterceptor> interceptors) {
            this.httpInterceptors.addAll((Collection<HttpInterceptor>)Assertions.checkNotNull(interceptors, "interceptors is null"));
            return this;
        }

        public Builder httpInterceptors(@NotNull List<HttpInterceptor> interceptors) {
            this.httpInterceptors = Assertions.checkNotNull(interceptors, "interceptors is null");
            return this;
        }

        public Builder customScalarAdapters(@NotNull CustomScalarAdapters customScalarAdapters) {
            this.customScalarAdaptersBuilder.clear();
            this.customScalarAdaptersBuilder.addAll(customScalarAdapters);
            return this;
        }

        public <T> Builder addCustomScalarAdapter(@NotNull CustomScalarType customScalarType, @NotNull Adapter<T> customScalarAdapter) {
            this.customScalarAdaptersBuilder.add(customScalarType, customScalarAdapter);
            return this;
        }

        public Builder wsProtocolFactory(WsProtocol.Factory wsProtocolFactory) {
            this.wsProtocolFactory = wsProtocolFactory;
            return this;
        }

        public Builder addWsHeader(@NotNull HttpHeader header) {
            this.wsHeaders.add(Assertions.checkNotNull(header, "header is null"));
            return this;
        }

        public Builder addWsHeaders(@NotNull List<HttpHeader> headers) {
            this.wsHeaders.addAll((Collection<HttpHeader>)Assertions.checkNotNull(headers, "headers is null"));
            return this;
        }

        public Builder wsHeaders(@NotNull List<HttpHeader> headers) {
            this.wsHeaders = Assertions.checkNotNull(headers, "headers is null");
            return this;
        }

        public Builder wsReopenWhen(WebSocketNetworkTransport.ReopenWhen reopenWhen) {
            this.wsReopenWhen = reopenWhen;
            return this;
        }

        public Builder wsIdleTimeoutMillis(long wsIdleTimeoutMillis) {
            this.wsIdleTimeoutMillis = wsIdleTimeoutMillis;
            return this;
        }

        public Builder httpEngine(HttpEngine httpEngine) {
            this.httpEngine = httpEngine;
            return this;
        }

        public Builder httpExposeErrorBody(boolean httpExposeErrorBody) {
            this.httpExposeErrorBody = httpExposeErrorBody;
            return this;
        }

        public Builder networkTransport(NetworkTransport networkTransport) {
            this.networkTransport = networkTransport;
            return this;
        }

        public Builder subscriptionNetworkTransport(NetworkTransport subscriptionNetworkTransport) {
            this.subscriptionNetworkTransport = subscriptionNetworkTransport;
            return this;
        }

        @ApolloExperimental
        public Builder retryOnError(RetryOnError retryOnError) {
            throw new IllegalStateException("Not supported yet");
        }

        public ApolloClient build() {
            NetworkTransport subscriptionNetworkTransport;
            NetworkTransport networkTransport;
            if (this.executor == null) {
                this.executor = ApolloClient.defaultExecutor();
            }
            if (this.networkTransport != null) {
                if (this.httpServerUrl != null) {
                    throw new IllegalStateException("Apollo: 'httpServerUrl' has no effect if 'networkTransport' is set");
                }
                if (this.httpEngine != null) {
                    throw new IllegalStateException("Apollo: 'httpEngine' has no effect if 'networkTransport' is set");
                }
                if (this.callFactory != null) {
                    throw new IllegalStateException("Apollo: 'callFactory' has no effect if 'networkTransport' is set");
                }
                if (this.httpExposeErrorBody != null) {
                    throw new IllegalStateException("Apollo: 'httpExposeErrorBody' has no effect if 'networkTransport' is set");
                }
                networkTransport = this.networkTransport;
            } else {
                Assertions.checkNotNull(this.httpServerUrl, "serverUrl is missing");
                if (this.callFactory != null) {
                    if (this.httpEngine != null) {
                        throw new IllegalStateException("Apollo: 'httpEngine' has no effect if 'callFactory' is set");
                    }
                } else {
                    this.callFactory = new OkHttpClient();
                }
                if (this.httpEngine == null) {
                    this.httpEngine = new OkHttpHttpEngine(this.callFactory);
                }
                if (this.httpExposeErrorBody == null) {
                    this.httpExposeErrorBody = false;
                }
                networkTransport = new HttpNetworkTransport((HttpRequestComposer)new DefaultHttpRequestComposer(this.httpServerUrl), this.httpEngine, this.httpInterceptors, this.httpExposeErrorBody);
            }
            if (this.subscriptionNetworkTransport != null) {
                if (this.webSocketServerUrl != null) {
                    throw new IllegalStateException("Apollo: 'webSocketServerUrl' has no effect if 'subscriptionNetworkTransport' is set");
                }
                if (this.webSocketFactory != null) {
                    throw new IllegalStateException("Apollo: 'webSocketFactory' has no effect if 'subscriptionNetworkTransport' is set");
                }
                if (this.wsProtocolFactory != null) {
                    throw new IllegalStateException("Apollo: 'wsProtocolFactory' has no effect if 'subscriptionNetworkTransport' is set");
                }
                if (this.wsHeaders != null) {
                    throw new IllegalStateException("Apollo: 'wsHeaders' has no effect if 'subscriptionNetworkTransport' is set");
                }
                if (this.wsIdleTimeoutMillis != null) {
                    throw new IllegalStateException("Apollo: 'wsIdleTimeoutMillis' has no effect if 'subscriptionNetworkTransport' is set");
                }
                subscriptionNetworkTransport = this.subscriptionNetworkTransport;
            } else {
                if (this.webSocketServerUrl == null) {
                    this.webSocketServerUrl = this.httpServerUrl;
                }
                if (this.webSocketServerUrl == null) {
                    subscriptionNetworkTransport = networkTransport;
                } else {
                    if (this.webSocketFactory == null) {
                        OkHttpClient okHttpClient = this.webSocketFactory = this.callFactory instanceof OkHttpClient ? (OkHttpClient)this.callFactory : new OkHttpClient();
                    }
                    if (this.wsProtocolFactory == null) {
                        this.wsProtocolFactory = new GraphQLWsProtocol.Factory();
                    }
                    if (this.wsReopenWhen == null) {
                        this.wsReopenWhen = (throwable, attempt) -> false;
                    }
                    if (this.wsIdleTimeoutMillis == null) {
                        this.wsIdleTimeoutMillis = 60000L;
                    }
                    subscriptionNetworkTransport = new WebSocketNetworkTransport(this.webSocketFactory, this.wsProtocolFactory, this.webSocketServerUrl, this.wsHeaders, this.wsReopenWhen, this.executor, this.wsIdleTimeoutMillis);
                }
            }
            return new ApolloClient(this.executor, networkTransport, subscriptionNetworkTransport, this.interceptors, this.customScalarAdaptersBuilder.build(), this.httpMethod, this.httpHeaders, this.sendApqExtensions, this.sendDocument, this.enableAutoPersistedQueries, this.canBeBatched);
        }

        public Builder autoPersistedQueries() {
            return this.autoPersistedQueries(HttpMethod.Get, HttpMethod.Post, true);
        }

        public Builder autoPersistedQueries(HttpMethod httpMethodForHashedQueries) {
            return this.autoPersistedQueries(httpMethodForHashedQueries, HttpMethod.Post, true);
        }

        public Builder autoPersistedQueries(HttpMethod httpMethodForHashedQueries, HttpMethod httpMethodForDocumentQueries) {
            return this.autoPersistedQueries(httpMethodForHashedQueries, httpMethodForDocumentQueries, true);
        }

        public Builder autoPersistedQueries(HttpMethod httpMethodForHashedQueries, HttpMethod httpMethodForDocumentQueries, boolean enableByDefault) {
            this.addInterceptor(new AutoPersistedQueryInterceptor(httpMethodForHashedQueries, httpMethodForDocumentQueries));
            this.enableAutoPersistedQueries(enableByDefault);
            return this;
        }

        public Builder httpBatching(long batchIntervalMillis, int maxBatchSize, boolean enableByDefault) {
            this.addHttpInterceptor(new BatchingHttpInterceptor(batchIntervalMillis, maxBatchSize, this.httpExposeErrorBody != null && this.httpExposeErrorBody != false));
            this.canBeBatched(enableByDefault);
            return this;
        }

        @NotNull
        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        @Nullable
        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Nullable
        public List<HttpHeader> getHttpHeaders() {
            return this.httpHeaders;
        }

        @Nullable
        public Boolean getSendApqExtensions() {
            return this.sendApqExtensions;
        }

        @Nullable
        public Boolean getSendDocument() {
            return this.sendDocument;
        }

        @Nullable
        public Boolean getEnableAutoPersistedQueries() {
            return this.enableAutoPersistedQueries;
        }

        @Nullable
        public Boolean getCanBeBatched() {
            return this.canBeBatched;
        }

        public Builder addExecutionContext(@NotNull ExecutionContext executionContext) {
            this.executionContext = this.executionContext.plus(executionContext);
            return this;
        }

        public Builder httpMethod(@Nullable HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder httpHeaders(@Nullable List<HttpHeader> list) {
            this.httpHeaders.clear();
            this.httpHeaders.addAll(list);
            return this;
        }

        public Builder addHttpHeader(@NotNull String name, @NotNull String value) {
            this.httpHeaders.add(new HttpHeader(name, value));
            return this;
        }

        public Builder sendApqExtensions(@Nullable Boolean sendApqExtensions) {
            this.sendApqExtensions = sendApqExtensions;
            return this;
        }

        public Builder sendDocument(@Nullable Boolean sendDocument) {
            this.sendDocument = sendDocument;
            return this;
        }

        public Builder enableAutoPersistedQueries(@Nullable Boolean enableAutoPersistedQueries) {
            this.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return this;
        }

        public Builder canBeBatched(@Nullable Boolean canBeBatched) {
            this.canBeBatched = canBeBatched;
            return this;
        }
    }
}

