/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.interceptor.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.AutoPersistedQueriesNotSupported;
import com.apollographql.java.client.ApolloCallback;
import com.apollographql.java.client.interceptor.ApolloInterceptor;
import com.apollographql.java.client.interceptor.ApolloInterceptorChain;
import com.apollographql.java.client.interceptor.internal.AutoPersistedQueryInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AutoPersistedQueryInterceptor
implements ApolloInterceptor {
    private final HttpMethod httpMethodForHashedQueries;
    private final HttpMethod httpMethodForDocumentQueries;
    private static final String PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND = "PersistedQueryNotFound";
    private static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";

    public AutoPersistedQueryInterceptor(HttpMethod httpMethodForHashedQueries, HttpMethod httpMethodForDocumentQueries) {
        this.httpMethodForHashedQueries = httpMethodForHashedQueries;
        this.httpMethodForDocumentQueries = httpMethodForDocumentQueries;
    }

    @Override
    public <D extends Operation.Data> void intercept(final @NotNull ApolloRequest<D> request, final @NotNull ApolloInterceptorChain chain, final @NotNull ApolloCallback<D> callback) {
        Boolean enabled = request.getEnableAutoPersistedQueries();
        if (enabled == null) {
            enabled = true;
        }
        if (!enabled.booleanValue()) {
            chain.proceed(request, callback);
        }
        boolean isMutation = request.getOperation() instanceof Mutation;
        ApolloRequest request2 = request.newBuilder().httpMethod(isMutation ? HttpMethod.Post : this.httpMethodForHashedQueries).sendDocument(Boolean.valueOf(false)).sendApqExtensions(Boolean.valueOf(true)).build();
        ApolloCallback callback2 = new ApolloCallback<D>(){

            @Override
            public void onResponse(@NotNull ApolloResponse<D> response) {
                if (AutoPersistedQueryInterceptor.isPersistedQueryNotFound(response.errors)) {
                    AutoPersistedQueryInterceptor.this.continueWithDocumentRequest(chain, request, callback);
                } else if (AutoPersistedQueryInterceptor.isPersistedQueryNotSupported(response.errors)) {
                    callback.onResponse(new ApolloResponse.Builder(request.getOperation(), request.getRequestUuid()).exception((ApolloException)new AutoPersistedQueriesNotSupported()).build());
                } else {
                    callback.onResponse(AutoPersistedQueryInterceptor.addAutoPersistedQueryInfo(response, true));
                }
            }
        };
        chain.proceed(request2, callback2);
    }

    private <D extends Operation.Data> void continueWithDocumentRequest(ApolloInterceptorChain chain, ApolloRequest<D> request, final ApolloCallback<D> callback) {
        boolean isMutation = request.getOperation() instanceof Mutation;
        ApolloRequest request2 = request.newBuilder().httpMethod(isMutation ? HttpMethod.Post : this.httpMethodForDocumentQueries).sendDocument(Boolean.valueOf(true)).sendApqExtensions(Boolean.valueOf(true)).build();
        ApolloCallback callback2 = new ApolloCallback<D>(){

            @Override
            public void onResponse(@NotNull ApolloResponse<D> response) {
                callback.onResponse(AutoPersistedQueryInterceptor.addAutoPersistedQueryInfo(response, false));
            }
        };
        chain.proceed(request2, callback2);
    }

    private static <D extends Operation.Data> ApolloResponse<D> addAutoPersistedQueryInfo(ApolloResponse<D> response, boolean hit) {
        return response.newBuilder().addExecutionContext((ExecutionContext)new AutoPersistedQueryInfo(hit)).build();
    }

    private static boolean isPersistedQueryNotFound(List<Error> errors) {
        if (errors == null) {
            return false;
        }
        for (Error error : errors) {
            if (!error.getMessage().equals(PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPersistedQueryNotSupported(List<Error> errors) {
        if (errors == null) {
            return false;
        }
        for (Error error : errors) {
            if (!error.getMessage().equals(PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED)) continue;
            return true;
        }
        return false;
    }
}

