/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.java.client.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.java.client.ApolloCall;
import com.apollographql.java.client.ApolloCallback;
import com.apollographql.java.client.ApolloClient;
import com.apollographql.java.client.ApolloDisposable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultApolloCall<D extends Operation.Data>
implements ApolloCall<D> {
    private final ApolloClient apolloClient;
    private final Operation<D> operation;
    private ExecutionContext executionContext = ExecutionContext.Empty;
    private HttpMethod httpMethod;
    private List<HttpHeader> httpHeaders;
    private Boolean sendApqExtensions;
    private Boolean sendDocument;
    private Boolean enableAutoPersistedQueries;
    private Boolean canBeBatched;
    private Boolean retryOnError;

    public DefaultApolloCall(ApolloClient apolloClient, Operation<D> operation) {
        this.apolloClient = apolloClient;
        this.operation = operation;
    }

    @Override
    public ApolloDisposable enqueue(@NotNull ApolloCallback<D> callback) {
        ApolloRequest apolloRequest = new ApolloRequest.Builder(this.operation).executionContext(this.executionContext).httpMethod(this.httpMethod).httpHeaders(this.httpHeaders).sendApqExtensions(this.sendApqExtensions).sendDocument(this.sendDocument).enableAutoPersistedQueries(this.enableAutoPersistedQueries).canBeBatched(this.canBeBatched).retryOnError(this.retryOnError).build();
        return this.apolloClient.execute(apolloRequest, callback);
    }

    @NotNull
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public List<HttpHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Nullable
    public Boolean getSendApqExtensions() {
        return this.sendApqExtensions;
    }

    @Nullable
    public Boolean getSendDocument() {
        return this.sendDocument;
    }

    @Nullable
    public Boolean getEnableAutoPersistedQueries() {
        return this.enableAutoPersistedQueries;
    }

    @Nullable
    public Boolean getCanBeBatched() {
        return this.canBeBatched;
    }

    @Nullable
    public Boolean getRetryOnError() {
        return this.retryOnError;
    }

    public ApolloCall<D> addExecutionContext(@NotNull ExecutionContext executionContext) {
        this.executionContext = this.executionContext.plus(executionContext);
        return this;
    }

    public ApolloCall<D> httpMethod(@Nullable HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public ApolloCall<D> httpHeaders(@Nullable List<HttpHeader> list) {
        this.httpHeaders = list;
        return this;
    }

    public ApolloCall<D> addHttpHeader(@NotNull String name, @NotNull String value) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<HttpHeader>();
        }
        this.httpHeaders.add(new HttpHeader(name, value));
        return this;
    }

    public ApolloCall<D> sendApqExtensions(@Nullable Boolean sendApqExtensions) {
        this.sendApqExtensions = sendApqExtensions;
        return this;
    }

    public ApolloCall<D> sendDocument(@Nullable Boolean sendDocument) {
        this.sendDocument = sendDocument;
        return this;
    }

    public ApolloCall<D> enableAutoPersistedQueries(@Nullable Boolean enableAutoPersistedQueries) {
        this.enableAutoPersistedQueries = enableAutoPersistedQueries;
        return this;
    }

    public ApolloCall<D> canBeBatched(@Nullable Boolean canBeBatched) {
        this.canBeBatched = canBeBatched;
        return this;
    }

    public ApolloCall<D> retryOnError(@Nullable Boolean retryOnError) {
        throw new IllegalStateException("Not supported yet");
    }
}

